<?php

/**
 * @package     EasyStore.Plugin
 * @subpackage  System.easystoremail
 *
 * @copyright   (C) 2016 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Plugin\System\EasyStoreMail\Extension;

use Joomla\CMS\Log\Log;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;
use JoomShaper\Component\EasyStore\Site\Lib\Email;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


/**
 * Easy Store Mail plugin for mail sending service.
 *
 * @since  1.0.0
 */
final class EasyStoreMail extends CMSPlugin implements SubscriberInterface
{
    /**
     * function for getSubscribedEvents : new Joomla 4 feature
     *
     * @return array
     *
     * @since   1.0.0
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onSuccessfulPayment'   => 'sendMail',
            'onFailedPayment'   => 'sendMail',
            'onOrderPlaced'   => 'sendMail',
        ];
    }

    public function sendMail(Event $event)
    {
        $arguments   = $event->getArguments();
        $data        = $arguments['subject'];
        $bcc         = null;

        if ($data->type == 'order_confirmation') {
            $settings   = SettingsHelper::getSettings();
            $bcc        = $settings->get('general.storeEmail', '');
        }
        
        try {
            $email = new Email($data->customer_email, $data->type, $bcc);
            $email->bind($data->variables)->send();
            Log::add('EasyStoreMail: Email Send success', Log::ALL, 'email.easystore');
        } catch (\Exception $e) {
            Log::add('EasyStoreMail: Email Send failed' . $e->getMessage(), Log::ALL, 'email.easystore');
        }
    }
}