<?php

/**
 * @package     EasyStore.Site
 * @subpackage  EasyStore.Stripe
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Plugin\EasyStore\Stripe\Utils;


use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
use Joomla\CMS\Plugin\PluginHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects


/**
 * Class that contains constants for the Stripe payment gateway.
 * @since 1.0.0
*/
class StripeConstants 
{
    public $plugin;
    public $pluginParams;
    

    public function __construct() {
        $this->plugin       = PluginHelper::getPlugin('easystore', 'stripe');
        $this->pluginParams = new Registry($this->plugin->params);
    }

    public function getStripeSecretKey(){
        return $this->pluginParams->get('stripe_secret_key','');
    }

    public function getSuccessUrl() {
        return Route::_(Uri::base() . 'index.php?option=com_easystore&task=payment.onPaymentSuccess');
    }

    public function getCancelUrl() {
        return Route::_(Uri::base() . 'index.php?option=com_easystore&task=payment.onPaymentCancel');
    }

    public function getWebHookSecret(){
        return $this->pluginParams->get('stripe_webhook_secret_key','');
    }

    public function getWebHookUrl(){
        return Route::_('index.php?option=com_easystore&task=payment.onPaymentNotify&type=stripe');
    }

} 