/**
 * @copyright   Copyright (C) 2020 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 * @since      1.0.0
 */

Joomla = window.Joomla || {};
((Joomla, document) => {
	document.addEventListener('DOMContentLoaded', function () {
		// Function to update the profile image when a file is selected
		const updateProfileImage = () => {
			const fileInput = document.getElementById('jform_image');
			const profileImageContainer = document.querySelector('.easystore-profile-image-container');
			let imageFileState = '';

			fileInput.addEventListener('change', (event) => {
				const selectedFile = event.target.files[0];
				const isImageFile = isImage(selectedFile);

				if (isImageFile) {
					imageFileState = selectedFile;
					const firstChild = profileImageContainer.firstElementChild;
					const imageSrc = URL.createObjectURL(selectedFile);
					const isDefaultIcon = firstChild.classList.contains('easystore-svg');

					if (isDefaultIcon) {
						// uploading for the first time
						const imageEl = createImage(imageSrc);
						firstChild.replaceWith(imageEl);
					} else {
						// image already uploaded
						firstChild.setAttribute('src', imageSrc);
					}
				} else {
					if (!imageFileState) {
						event.target.value = null;
					} else {
						const container = new DataTransfer();
						container.items.add(imageFileState);
						event.target.files = container.files;
					}
				}
			});

			function isImage(file) {
				if (!file) return false;
				return file.type.startsWith('image/');
			}

			function createImage(src = '', width = 250) {
				const img = document.createElement('img');
				img.src = src;
				img.width = width;
				return img;
			}
		};

		const easystoreDiv = document.querySelector('.easystore-same-address');
		const radioButtons = document.getElementsByName('jform[is_billing_same]');

		const showHideDiv = () => {
			var activeValue;
			for (var i = 0; i < radioButtons.length; i++) {
				if (radioButtons[i].classList.contains('active')) {
					activeValue = radioButtons[i].value;
					break; // Exit the loop once the active radio button is found
				}
			}
			if (activeValue == 1) {
				easystoreDiv.classList.add('hidden');
			} else {
				easystoreDiv.classList.remove('hidden');
			}
		};

		// Call the function to initialize the event listener
		updateProfileImage();
		showHideDiv();

		document.addEventListener('click', function (event) {
			if (event.target.hasAttribute('easystore-profile-is-same-as-shipping')) {
				const isChecked = event.target.checked;
				let element = document.querySelector('.billing-content');
				// Get all elements with the class '.easystore-billing'
				const billingElements = document.querySelectorAll('.easystore-billing');

				if (isChecked) {
					element.classList.add('hidden');
					// Loop through the elements and set the 'required' attribute
					billingElements.forEach((element) => {
						element.removeAttribute('required');
					});
				} else {
					element.classList.remove('hidden');

					// Loop through the elements and set the 'required' attribute
					billingElements.forEach((element) => {
						element.setAttribute('required', 'true');
					});
				}
			}
		});

		document.addEventListener('change', function (event) {
			if (event.target.name === 'jform[shipping_country]' || event.target.name === 'jform[billing_country]') {
				const targetDropdown =
					event.target.name === 'jform[shipping_country]' ? 'jform_shipping_state' : 'jform_billing_state';
				const countryNumericCode = event.target.value;
				const countries = Joomla.getOptions('countriesList', false);
				const country = countries.find((country) => country.numeric_code === countryNumericCode);
				const fancySelect = document.getElementById(targetDropdown).closest('joomla-field-fancy-select');

				// Clear fancySelect
				fancySelect.choicesInstance.setChoices(
					[
						{
							id: '',
							text: '',
						},
					],
					'id',
					'text',
					false,
				);

				fancySelect.choicesInstance.setChoiceByValue('');
				var newEvent = document.createEvent('HTMLEvents');
				newEvent.initEvent('change', true, false);
				document.getElementById(targetDropdown).dispatchEvent(newEvent);

				fancySelect.choicesInstance.clearChoices();

				// Set new Data in fancySelect
				if (country.states) {
					country.states.forEach((value) => {
						const option = {};
						option.innerText = value.name;
						option.id = value.id;
						fancySelect.choicesInstance.setChoices([option], 'id', 'innerText', false);
					});
				}
			}

			if (event.target.name === 'jform[is_billing_same]') {
				if (event.target.value == 1) {
					easystoreDiv.classList.add('hidden');
				} else {
					easystoreDiv.classList.remove('hidden');
				}
			}
		});
	});
})(Joomla, document);
