document.addEventListener('alpine:init', () => {
	Alpine.data('easystore_order', (base, status) => ({
		init() {
			this.status = status;
			this.checkForUrl();
			this.showSaveAsDraftButton = this.status === 'draft';

			this.$watch('status', (value) => {
				this.showSaveAsDraftButton = value === 'draft';
				this.checkForUrl();
			});
		},
		showSaveButton: false,
		showEditButton: false,
		showSaveAsDraftButton: false,
		status: '',

		checkForUrl() {
			const url = new URL(window.location);

			if (!!url.hash && url.hash === '#/order-details') {
				this.showSaveButton = false;
				this.showEditButton = true;
			} else {
				this.showSaveButton = true;
				this.showEditButton = false;
			}
		},
		triggerSaveButton(event) {
			event.preventDefault();
			const saveButton = document.querySelector('#easystore-save-order');

			if (saveButton) {
				saveButton.click();
				window.location.href = `${base}order-details`;
				this.showSaveAsDraftButton = false;
				this.showEditButton = true;
				this.showSaveButton = false;
				this.status = 'active';
			}
		},
		triggerEditButton(event) {
			event.preventDefault();
			const editButton = document.querySelector('#easystore-edit-order-button');

			if (editButton) {
				editButton.click();
				this.showSaveButton = true;
				this.showEditButton = false;
			}
		},
		triggerSaveAsDraftButton(event) {
			event.preventDefault();
			const saveAsButton = document.querySelector('#easystore-save-as-draft');

			if (saveAsButton) {
				saveAsButton.click();
				this.showSaveButton = true;
				this.showEditButton = false;
			}
		},
	}));
});
