/**
 * @copyright   Copyright (C) 2020 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 * @since      1.0.0
 */

Joomla = window.Joomla || {};
((Joomla, document) => {
	document.addEventListener('DOMContentLoaded', function () {
		document.addEventListener('change', function (event) {
			if (event.target.name === 'jform[shipping_country]' || event.target.name === 'jform[billing_country]') {
				const targetDropdown =
					event.target.name === 'jform[shipping_country]' ? 'jform_shipping_state' : 'jform_billing_state';
				const countryNumericCode = event.target.value;
				const countries = Joomla.getOptions('countriesList', false);
				const country = countries.find((country) => country.numeric_code === countryNumericCode);
				const fancySelect = document.getElementById(targetDropdown).closest('joomla-field-fancy-select');

				// Clear fancySelect
                fancySelect.choicesInstance.setChoices([{
                    id: '',
                    text: ''
                }], 'id', 'text', false);
                
                fancySelect.choicesInstance.setChoiceByValue('');
                var newEvent = document.createEvent('HTMLEvents');
                newEvent.initEvent('change', true, false);
                document.getElementById(targetDropdown).dispatchEvent(newEvent);

                fancySelect.choicesInstance.clearChoices();

				// Set new Data in fancySelect
				if (country.states) {
					country.states.forEach((value) => {
						const option = {};
						option.innerText = value.name;
						option.id = value.id;
						fancySelect.choicesInstance.setChoices([option], 'id', 'innerText', false);
					});
				}
			}
		});
	});
})(Joomla, document);
