/**
 * @copyright   Copyright (C) 2020 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 * @since      1.0.0
 */

Joomla = window.Joomla || {};
(function (Joomla, document) {
    document.addEventListener('DOMContentLoaded', function () {
        document.addEventListener('click', function (event) {
            if (event.target.id === 'easystore-create-webhook') {
                event.preventDefault();

                const paymentType = event.target.dataset.paymenttype;
                const url =
                    `${Joomla.getOptions(
                        'easystore.base'
                    )}/index.php?option=com_easystore&task=payment.onPaymentCreateWebhook&type=` + paymentType;

                Joomla.request({
                    url,
                    method: 'POST',
                    onSuccess: response => {
                        response = JSON.parse(response);

                        if (response.data.success) {
                            if (response.data.message !== 'already_created') {
                                document.querySelector('#jform_params_stripe_webhook_secret_key').value =
                                    response.data.message;
                                event.target.disabled = true;
                                Joomla.renderMessages({
                                    message: [Joomla.Text._('PLG_EASYSTORE_STRIPE_WEBHOOK_ENDPOINT_CREATED')],
                                });
                                // Trigger the save button
                                Joomla.submitbutton('plugin.apply');
                            }
                        } else {
                            Joomla.renderMessages({
                                error: [response.data.message],
                            });
                        }
                    },
                    onError: xhr => {
                        Joomla.renderMessages(Joomla.ajaxErrorsMessages(xhr));
                    },
                });
            }
        });
    });
})(Joomla, document);
