async function getCartDrawerContent() {
    const response = await fetch('index.php?option=com_easystore&task=display.createDrawer');
    const data = await response.json();

    document.body.insertAdjacentHTML('beforeend', data.data);
}

window.addEventListener('alpine:init', async () => {
    getCartDrawerContent();

    Alpine.data('cartDrawer', () => {
        return {
            init() {
                this.$watch('open', async value => {
                    this.isLoading = true;
                    if (value) {
                        const response = await this.fetchData();
                        this.$refs.drawerContent.innerHTML = response.data.content;
                        this.checkout_url = response.data.checkout_url;
                    } else {
                        this.$refs.drawerContent.innerHTML = null;
                    }
                    this.isLoading = false;
                });

                window.addEventListener('keyup', event => {
                    if (event.key === 'Escape' && document.body.classList.contains('easystore-drawer-active')) {
                        this.closeDrawer();
                    }
                });
            },
            open: false,
            isLoading: false,
            checkout_url: '',
            openDrawer() {
                this.open = true;
                document.body.classList.add('easystore-drawer-active');
            },
            closeDrawer() {
                this.$refs.drawerContainer.classList.add('easystore-drawer-closing');
                setTimeout(() => {
                    this.open = false;
                    document.body.classList.remove('easystore-drawer-active');
                    this.$refs.drawerContainer.classList.remove('easystore-drawer-closing');
                }, 300);
            },
            async fetchData() {
                const response = await fetch('index.php?option=com_easystore&task=cart.getCartDrawerContent');
                const data = await response.json();
                return data;
            },
        };
    });
});
