SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";



-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__assets`
--


INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES 
(1, 0, 0, 205, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(8, 1, 17, 58, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(9, 1, 59, 60, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 61, 62, 1, 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 63, 68, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
(12, 1, 69, 70, 1, 'com_login', 'com_login', '{}'),
(13, 1, 71, 72, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 73, 74, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 75, 76, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 77, 84, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
(17, 1, 85, 86, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 87, 132, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
(19, 1, 133, 136, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(20, 1, 137, 138, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
(21, 1, 139, 140, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
(22, 1, 141, 142, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 143, 144, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
(24, 1, 145, 148, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
(26, 1, 149, 150, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 19, 2, 'com_content.category.2', 'Uncategorised', '{}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{}'),
(30, 19, 134, 135, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
(32, 24, 146, 147, 2, 'com_users.category.7', 'Uncategorised', '{}'),
(33, 1, 151, 152, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 153, 154, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(35, 1, 155, 156, 1, 'com_tags', 'com_tags', '{}'),
(36, 1, 157, 158, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 159, 160, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 161, 162, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 88, 89, 2, 'com_modules.module.2', 'Login', '{}'),
(41, 18, 90, 91, 2, 'com_modules.module.3', 'Popular Articles', '{}'),
(42, 18, 92, 93, 2, 'com_modules.module.4', 'Recently Added Articles', '{}'),
(43, 18, 94, 95, 2, 'com_modules.module.8', 'Toolbar', '{}'),
(44, 18, 96, 97, 2, 'com_modules.module.9', 'Quick Icons', '{}'),
(45, 18, 98, 99, 2, 'com_modules.module.10', 'Logged-in Users', '{}'),
(46, 18, 100, 101, 2, 'com_modules.module.12', 'Admin Menu', '{}'),
(47, 18, 102, 103, 2, 'com_modules.module.13', 'Admin Submenu', '{}'),
(48, 18, 104, 105, 2, 'com_modules.module.14', 'User Status', '{}'),
(49, 18, 106, 107, 2, 'com_modules.module.15', 'Title', '{}'),
(51, 18, 108, 109, 2, 'com_modules.module.17', 'Breadcrumbs', '{}'),
(52, 18, 110, 111, 2, 'com_modules.module.79', 'Multilanguage status', '{}'),
(53, 18, 112, 113, 2, 'com_modules.module.86', 'Joomla Version', '{}'),
(54, 16, 78, 79, 2, 'com_menus.menu.1', 'Main Menu', '{}'),
(55, 18, 114, 115, 2, 'com_modules.module.87', 'Sample Data', '{}'),
(56, 1, 163, 182, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(60, 56, 164, 165, 2, 'com_sppagebuilder.page.1', 'Home - Legacy', '{}'),
(65, 1, 183, 184, 1, '#__speasyimagegallery_albums.1', '#__speasyimagegallery_albums.1', '{}'),
(66, 56, 166, 167, 2, 'com_sppagebuilder.page.2', 'About', '{}'),
(67, 56, 168, 169, 2, 'com_sppagebuilder.page.3', 'Contact', '{}'),
(68, 56, 170, 171, 2, 'com_sppagebuilder.page.4', 'Services', '{}'),
(69, 8, 20, 57, 2, 'com_content.category.8', 'Blog', '{}'),
(70, 69, 21, 22, 3, 'com_content.article.1', 'How Marching for Science Risks Politicizing It', '{}'),
(71, 69, 23, 24, 3, 'com_content.article.2', 'After Setbacks and Suits, Miami to Open Science Museum', '{}'),
(72, 69, 25, 26, 3, 'com_content.article.3', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
(75, 16, 80, 81, 2, 'com_menus.menu.2', 'Company', '{}'),
(76, 16, 82, 83, 2, 'com_menus.menu.3', 'Quick Links', '{}'),
(78, 69, 27, 28, 3, 'com_content.article.4', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
(79, 69, 29, 30, 3, 'com_content.article.5', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
(80, 69, 31, 32, 3, 'com_content.article.6', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
(81, 69, 33, 34, 3, 'com_content.article.7', 'Want to Make More Baskets? Science Has the Answer', '{}'),
(82, 69, 35, 36, 3, 'com_content.article.8', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
(83, 69, 37, 38, 3, 'com_content.article.9', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
(84, 18, 116, 117, 2, 'com_modules.module.96', 'Joomla Module', '{}'),
(88, 18, 118, 119, 2, 'com_modules.module.98', 'Latest Articles', '{}'),
(90, 1, 185, 186, 1, 'com_fields', 'com_fields', '{}'),
(91, 1, 187, 188, 1, 'com_associations', 'com_associations', '{}'),
(92, 1, 189, 190, 1, 'com_privacy', 'com_privacy', '{}'),
(93, 1, 191, 192, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(94, 56, 172, 173, 2, 'com_sppagebuilder.page.5', 'Home - Corporate', '{}'),
(95, 56, 174, 175, 2, 'com_sppagebuilder.page.6', 'Home - Fashion', '{}'),
(96, 56, 176, 177, 2, 'com_sppagebuilder.page.7', 'Home - Life Style', '{}'),
(97, 56, 178, 179, 2, 'com_sppagebuilder.page.8', 'Home - Sea Food', '{}'),
(98, 56, 180, 181, 2, 'com_sppagebuilder.page.9', 'Home - Default', '{}'),
(99, 69, 39, 40, 3, 'com_content.article.10', 'How Marching for Science Risks Politicizing It', '{}'),
(100, 69, 41, 42, 3, 'com_content.article.11', 'After Setbacks and Suits, Miami to Open Science Museum', '{}'),
(101, 69, 43, 44, 3, 'com_content.article.12', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
(102, 69, 45, 46, 3, 'com_content.article.13', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
(103, 69, 47, 48, 3, 'com_content.article.14', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
(104, 69, 49, 50, 3, 'com_content.article.15', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
(105, 69, 51, 52, 3, 'com_content.article.16', 'Want to Make More Baskets? Science Has the Answer', '{}'),
(106, 69, 53, 54, 3, 'com_content.article.17', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
(107, 69, 55, 56, 3, 'com_content.article.18', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
(109, 1, 193, 194, 1, 'com_easystore', 'com_easystore', '{}'),
(111, 18, 120, 121, 2, 'com_modules.module.122', 'Shop Topbar Carousel', '{}'),
(113, 11, 64, 65, 2, 'com_languages.language.2', 'Arabic (اللغة العربية)', '{}'),
(114, 11, 66, 67, 2, 'com_languages.language.3', 'French (fr-FR)', '{}'),
(117, 18, 122, 123, 2, 'com_modules.module.124', 'Menu Add to Cart', '{}'),
(123, 18, 124, 125, 2, 'com_modules.module.129', 'Bottom  Section', '{}'),
(124, 18, 126, 127, 2, 'com_modules.module.130', 'Footer Payment', '{}'),
(125, 18, 128, 129, 2, 'com_modules.module.131', 'Offcanvas - Logo', '{}'),
(126, 18, 130, 131, 2, 'com_modules.module.132', 'Footer menu', '{}'),
(127, 1, 195, 196, 1, 'com_qsbuilder', 'com_qsbuilder', '{}'),
(128, 1, 197, 198, 1, 'com_guidedtours', 'com_guidedtours', '{}'),
(129, 1, 199, 200, 1, 'com_mails', 'com_mails', '{}'),
(130, 1, 201, 202, 1, 'com_scheduler', 'com_scheduler', '{}'),
(131, 1, 203, 204, 1, 'com_workflow', 'com_workflow', '{}');


-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--


DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '1',
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__extensions`
--


INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES 
(2, 0, 'com_wrapper', 'component', 'com_wrapper', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(3, 0, 'com_admin', 'component', 'com_admin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(4, 0, 'com_banners', 'component', 'com_banners', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, 0, 0, NULL, 1),
(5, 0, 'com_cache', 'component', 'com_cache', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(6, 0, 'com_categories', 'component', 'com_categories', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(7, 0, 'com_checkin', 'component', 'com_checkin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(8, 0, 'com_contact', 'component', 'com_contact', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10, 0, 'com_installer', 'component', 'com_installer', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, 0, 0, NULL, 1),
(11, 0, 'com_languages', 'component', 'com_languages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, 0, 0, NULL, 1),
(12, 0, 'com_login', 'component', 'com_login', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(13, 0, 'com_media', 'component', 'com_media', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,ico,mp3,mp4,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,csv,webp\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,webp\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"doc,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip,webp\"}', '', NULL, NULL, 0, 0, NULL, 1),
(14, 0, 'com_menus', 'component', 'com_menus', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(15, 0, 'com_messages', 'component', 'com_messages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(16, 0, 'com_modules', 'component', 'com_modules', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(18, 0, 'com_plugins', 'component', 'com_plugins', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(19, 10067, 'com_search', 'component', 'com_search', '', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"17.06.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"search_phrases\":\"1\",\"search_areas\":\"1\",\"show_date\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\"}', '', NULL, NULL, 0, 0, NULL, 0),
(20, 0, 'com_templates', 'component', 'com_templates', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"1\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, 0, 0, NULL, 1),
(22, 0, 'com_content', 'component', 'com_content', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":1,\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(23, 0, 'com_config', 'component', 'com_config', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, 0, 0, NULL, 1),
(24, 0, 'com_redirect', 'component', 'com_redirect', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(25, 0, 'com_users', 'component', 'com_users', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"enforce_2fa_options\":0,\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":0,\"minimum_symbols\":0,\"minimum_uppercase\":0,\"minimum_lowercase\":0,\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(27, 0, 'com_finder', 'component', 'com_finder', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\",\"versioncheck\":\"1\",\"backupcheck\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(29, 0, 'com_tags', 'component', 'com_tags', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(31, 0, 'com_ajax', 'component', 'com_ajax', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(33, 0, 'com_fields', 'component', 'com_fields', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(34, 0, 'com_associations', 'component', 'com_associations', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(35, 0, 'com_privacy', 'component', 'com_privacy', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, 0, 0, NULL, 1),
(103, 0, 'lib_joomla', 'library', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"5b48938d5512868fb4ba7a6f12811b7a\"}', '', NULL, NULL, 0, 0, NULL, 1),
(105, 0, 'FOF', 'library', 'fof', NULL, '', 0, 1, 1, 0, 'false', '', '', NULL, NULL, 0, 0, NULL, 0),
(106, 0, 'lib_phpass', 'library', 'phpass', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(203, 0, 'mod_banners', 'module', 'mod_banners', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(205, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(206, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(207, 0, 'mod_footer', 'module', 'mod_footer', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(208, 0, 'mod_login', 'module', 'mod_login', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(209, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(213, 10067, 'mod_search', 'module', 'mod_search', '', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(222, 0, 'mod_languages', 'module', 'mod_languages', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(223, 0, 'mod_finder', 'module', 'mod_finder', NULL, '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(300, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(301, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(302, 0, 'mod_latest', 'module', 'mod_latest', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(303, 0, 'mod_logged', 'module', 'mod_logged', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(304, 0, 'mod_login', 'module', 'mod_login', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(305, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(307, 0, 'mod_popular', 'module', 'mod_popular', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(311, 0, 'mod_title', 'module', 'mod_title', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(314, 0, 'mod_version', 'module', 'mod_version', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 1),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', NULL, 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', NULL, 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, 3, 0, NULL, 1),
(403, 0, 'plg_content_contact', 'plugin', 'contact', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, 1, 0, NULL, 1),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, '2011-09-18 15:22:50', 0, 0, NULL, 1),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, 4, 0, NULL, 1),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, 5, 0, NULL, 1),
(409, 0, 'plg_content_vote', 'plugin', 'vote', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"5.65.15\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, 1, 0, NULL, 1),
(411, 0, 'plg_editors_none', 'plugin', 'none', NULL, 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"5.10.9\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, 3, 0, NULL, 1),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(417, 10067, 'plg_search_categories', 'plugin', 'categories', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(418, 10067, 'plg_search_contacts', 'plugin', 'contacts', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(419, 10067, 'plg_search_content', 'plugin', 'content', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(420, 10067, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":0,\"automatic_change\":1,\"item_associations\":1,\"alternate_meta\":1,\"xdefault\":1,\"xdefault_language\":\"default\",\"remove_default_prefix\":0,\"lang_cookie\":0}', '', NULL, NULL, 1, 0, '', 1),
(424, 0, 'plg_system_cache', 'plugin', 'cache', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, 9, 0, NULL, 1),
(425, 0, 'plg_system_debug', 'plugin', 'debug', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, 4, 0, NULL, 1),
(426, 0, 'plg_system_log', 'plugin', 'log', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(428, 0, 'plg_system_remember', 'plugin', 'remember', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(429, 0, 'plg_system_sef', 'plugin', 'sef', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '', '', NULL, NULL, 8, 0, NULL, 1),
(430, 0, 'plg_system_logout', 'plugin', 'logout', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, 1, 0, NULL, 1),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, 2, 0, NULL, 1),
(433, 0, 'plg_user_profile', 'plugin', 'profile', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, 10, 0, NULL, 1),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', NULL, 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\ReCaptcha\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 1),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(441, 0, 'plg_content_finder', 'plugin', 'finder', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, '', 1),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(444, 0, 'plg_finder_content', 'plugin', 'content', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', NULL, 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(451, 10067, 'plg_search_tags', 'plugin', 'tags', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2015-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1708412464}', '', NULL, NULL, 0, 0, NULL, 1),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(454, 0, 'plg_system_stats', 'plugin', 'stats', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"6d30f13db174eb0c94efb885594275cd80da3e3a\",\"interval\":12}', '', NULL, NULL, 0, 0, NULL, 1),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(456, 0, 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(457, 0, 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(461, 0, 'plg_system_fields', 'plugin', 'fields', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(464, 0, 'plg_fields_color', 'plugin', 'color', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(468, 0, 'plg_fields_list', 'plugin', 'list', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(469, 0, 'plg_fields_media', 'plugin', 'media', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(472, 0, 'plg_fields_text', 'plugin', 'text', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(474, 0, 'plg_fields_url', 'plugin', 'url', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(475, 0, 'plg_fields_user', 'plugin', 'user', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(477, 0, 'plg_content_fields', 'plugin', 'fields', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2018-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\SessionGC\",\"filename\":\"sessiongc\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', NULL, 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(483, 0, 'plg_system_actionlogs', 'plugin', 'actionlogs', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(484, 0, 'plg_actionlog_joomla', 'plugin', 'joomla', NULL, 'actionlog', 0, 1, 1, 0, '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LogRotation\",\"filename\":\"logrotation\"}', '{\"lastrun\":1708337068}', '', NULL, NULL, 0, 0, NULL, 1),
(487, 0, 'plg_privacy_user', 'plugin', 'user', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(489, 0, 'plg_user_terms', 'plugin', 'terms', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(491, 0, 'plg_privacy_content', 'plugin', 'content', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(492, 0, 'plg_privacy_message', 'plugin', 'message', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', NULL, 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\InvisibleReCaptcha\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 1),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(600, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.2\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(601, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.2\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(700, 0, 'files_joomla', 'file', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.2\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.2.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10000, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":0,\"addcontainer\":\"1\",\"gmap_api\":\"\",\"fontawesome\":1,\"disableanimatecss\":0,\"disablecss\":0,\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\",\"ig_token\":\"{\\\"appId\\\":\\\"\\\",\\\"appSecret\\\":\\\"\\\",\\\"accessToken\\\":\\\"\\\",\\\"igId\\\":\\\"\\\"}\",\"disable_google_fonts\":0,\"lazyloadimg\":0,\"lazyplaceholder\":\"\\/components\\/com_sppagebuilder\\/assets\\/images\\/lazyloading-placeholder.svg\",\"disable_og\":0,\"fb_app_id\":\"\",\"disable_tc\":0,\"google_font_api_key\":\"\",\"enable_frontend_editing\":1,\"container_max_width\":1320}', '', NULL, NULL, 0, 0, NULL, 0),
(10001, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10004, 0, 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2023 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0.18\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helixultimate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10006, 0, 'Helix Ultimate based template installer', 'plugin', 'TmplHelixUltimate', NULL, 'system', 0, 0, 1, 0, 'false', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10015, 0, 'plg_behaviour_taggable', 'plugin', 'taggable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10016, 0, 'plg_behaviour_versionable', 'plugin', 'versionable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10017, 0, 'atum', 'template', 'atum', NULL, '', 1, 1, 1, 0, '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10018, 0, 'cassiopeia', 'template', 'cassiopeia', NULL, '', 0, 1, 1, 0, '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10019, 0, 'plg_filesystem_local', 'plugin', 'local', NULL, 'filesystem', 0, 1, 1, 0, '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10020, 0, 'plg_media-action_crop', 'plugin', 'crop', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10021, 0, 'plg_media-action_resize', 'plugin', 'resize', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10022, 0, 'plg_media-action_rotate', 'plugin', 'rotate', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10023, 0, 'plg_system_httpheaders', 'plugin', 'httpheaders', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10024, 0, 'com_workflow', 'component', 'com_workflow', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10025, 0, 'plg_workflow_publishing', 'plugin', 'publishing', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10026, 0, 'plg_workflow_featuring', 'plugin', 'featuring', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10027, 0, 'plg_workflow_notification', 'plugin', 'notification', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10028, 0, 'plg_extension_namespacemap', 'plugin', 'namespacemap', NULL, 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10029, 0, 'plg_installer_override', 'plugin', 'override', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10030, 0, 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10031, 0, 'plg_extension_finder', 'plugin', 'finder', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10032, 0, 'plg_api-authentication_basic', 'plugin', 'basic', NULL, 'api-authentication', 0, 0, 1, 0, '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10033, 0, 'plg_webservices_content', 'plugin', 'content', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10034, 0, 'com_mails', 'component', 'com_mails', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10035, 0, 'plg_system_skipto', 'plugin', 'skipto', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10036, 0, 'plg_sampledata_multilang', 'plugin', 'multilang', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10037, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', NULL, 'installer', 0, 0, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10038, 0, 'plg_fields_subform', 'plugin', 'subform', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10039, 0, 'plg_system_webauthn', 'plugin', 'webauthn', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10040, 0, 'mod_loginsupport', 'module', 'mod_loginsupport', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10041, 0, 'mod_frontend', 'module', 'mod_frontend', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10042, 0, 'mod_messages', 'module', 'mod_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10043, 0, 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10044, 0, 'mod_user', 'module', 'mod_user', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10045, 0, 'mod_submenu', 'module', 'mod_submenu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10046, 0, 'mod_privacy_status', 'module', 'mod_privacy_status', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10047, 0, 'plg_webservices_banners', 'plugin', 'banners', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10048, 0, 'plg_webservices_config', 'plugin', 'config', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10049, 0, 'plg_webservices_contact', 'plugin', 'contact', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10050, 0, 'plg_webservices_languages', 'plugin', 'languages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10051, 0, 'plg_webservices_menus', 'plugin', 'menus', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10052, 0, 'plg_webservices_messages', 'plugin', 'messages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10053, 0, 'plg_webservices_modules', 'plugin', 'modules', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10054, 0, 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10055, 0, 'plg_webservices_plugins', 'plugin', 'plugins', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10056, 0, 'plg_webservices_privacy', 'plugin', 'privacy', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10057, 0, 'plg_webservices_redirect', 'plugin', 'redirect', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10058, 0, 'plg_webservices_tags', 'plugin', 'tags', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10059, 0, 'plg_webservices_templates', 'plugin', 'templates', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10060, 0, 'plg_webservices_users', 'plugin', 'users', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10061, 0, 'plg_webservices_installer', 'plugin', 'installer', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10062, 0, 'plg_user_token', 'plugin', 'token', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10063, 0, 'plg_api-authentication_token', 'plugin', 'token', NULL, 'api-authentication', 0, 1, 1, 0, '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10064, 0, 'plg_system_accessibility', 'plugin', 'accessibility', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10065, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 3, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.2\",\"description\":\"en-GB api language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10066, 0, 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10067, 0, 'pkg_search', 'package', 'pkg_search', NULL, '', 0, 1, 1, 0, '{\"name\":\"pkg_search\",\"type\":\"package\",\"creationDate\":\"2021-08-17\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"pkg_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(10079, 0, 'com_scheduler', 'component', 'com_scheduler', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10080, 0, 'plg_system_schedulerunner', 'plugin', 'schedulerunner', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10081, 0, 'plg_system_task_notification', 'plugin', 'tasknotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, 22, 0, NULL, 1),
(10082, 0, 'plg_task_check_files', 'plugin', 'checkfiles', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10083, 0, 'plg_task_demo_tasks', 'plugin', 'demotasks', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_demo_tasks\",\"type\":\"plugin\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_DEMO_TASKS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DemoTasks\",\"filename\":\"demotasks\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10084, 0, 'plg_task_requests', 'plugin', 'requests', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10085, 0, 'plg_task_site_status', 'plugin', 'sitestatus', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10086, 0, 'plg_system_jooa11y', 'plugin', 'jooa11y', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10087, 0, 'plg_webservices_media', 'plugin', 'media', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10092, 0, 'plg_multifactorauth_totp', 'plugin', 'totp', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(10093, 0, 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(10094, 0, 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(10095, 0, 'plg_multifactorauth_email', 'plugin', 'email', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10096, 0, 'plg_multifactorauth_fixed', 'plugin', 'fixed', NULL, 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(10097, 0, 'plg_system_shortcut', 'plugin', 'shortcut', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10099, 0, 'System - SP Page Builder Lite Updater', 'plugin', 'sppagebuilderliteupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Lite Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2022\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.10\",\"description\":\"SP Page Builder Lite Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderliteupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10101, 0, 'com_guidedtours', 'component', 'com_guidedtours', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10102, 0, 'mod_guidedtours', 'module', 'mod_guidedtours', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10103, 0, 'plg_system_guidedtours', 'plugin', 'guidedtours', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10105, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10106, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10107, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', '', 'search', 0, 0, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10108, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', '', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10109, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', '', 'content', 0, 0, 1, 0, '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10112, 0, 'com_easystore', 'component', 'com_easystore', '', '', 1, 1, 0, 0, '{\"name\":\"com_easystore\",\"type\":\"component\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.9\",\"description\":\"COM_EASYSTORE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Component\\\\EasyStore\",\"filename\":\"easystore\"}', '{\"installed_on\":\"2023-10-04 16:35:01\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10113, 0, 'MOD_EASYSTORE_CART_ICON', 'module', 'mod_easystore_cart_icon', '', '', 0, 1, 0, 0, '{\"name\":\"MOD_EASYSTORE_CART_ICON\",\"type\":\"module\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.7\",\"description\":\"MOD_EASYSTORE_CART_ICON_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_easystore_cart_icon\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10114, 0, 'PLG_EASYSTORE_STRIPE', 'plugin', 'stripe', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_STRIPE\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.1\",\"description\":\"PLG_EASYSTORE_STRIPE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\Stripe\",\"filename\":\"stripe\"}', '{\"title\":\"Stripe\",\"payment_instruction\":\"You will be redirected to the secure Stripe payment portal to complete your purchase. After the payment is processed, you will be redirected back to this website\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10115, 0, 'PLG_EASYSTORE_PAYPAL', 'plugin', 'paypal', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_PAYPAL\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.8\",\"description\":\"PLG_EASYSTORE_PAYPAL_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\Paypal\",\"filename\":\"paypal\"}', '{\"title\":\"PayPal\",\"shop_environment\":\"sandbox\",\"paypal_id\":\"example@example.com\",\"payment_instruction\":\"You will be redirected to the secure PayPal payment portal to complete your purchase. After the payment is processed, you will be redirected back to this website\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10116, 0, 'PLG_EASYSTORE_PADDLE', 'plugin', 'paddle', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_PADDLE\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.1\",\"description\":\"PLG_EASYSTORE_PADDLE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\Paddle\",\"filename\":\"paddle\"}', '{\"title\":\"Paddle\",\"shop_environment\":\"sandbox\",\"payment_instruction\":\"You will be redirected to the secure Paddle payment portal to complete your purchase. After the payment is processed, you will be redirected back to this website\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10117, 10120, 'Arabic Unitag (العربية الموحدة)', 'language', 'ar-AA', '', '', 0, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"Arabic Unitag language files\\/Site \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10118, 10120, 'اللغة العربية بالكود الموحد (ar-AA)', 'language', 'ar-AA', '', '', 1, 1, 0, 0, '{\"name\":\"\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f (ar-AA)\",\"type\":\"language\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"Arabic Unitag language files\\/Administrator \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10119, 10120, 'Arabic Unitag (العربية الموحدة)', 'language', 'ar-AA', '', '', 3, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"June 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2005 - 2021 Open Source Matters.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"4.0.0\",\"description\":\"\\u0648\\u0627\\u062c\\u0647\\u0629 \\u0628\\u0631\\u0645\\u062c\\u0629 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0644\\u063a\\u0629 ar-AA\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10120, 0, 'Arabic ar-AA(العربية الموحدة)', 'package', 'pkg_ar-AA', '', '', 0, 1, 1, 0, '{\"name\":\"Arabic ar-AA(\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"package\",\"creationDate\":\"August 2021\",\"author\":\"Dr. Ashraf Damra\",\"copyright\":\"Copyright (C) 2019 - 2021 Open Source Matters.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"www.dr-ashraf.com\",\"version\":\"\",\"description\":\"\\n        <div class=\\\"alert alert-info\\\">\\n<h4 class=\\\"alert-heading\\\" style=\\\"direction: rtl;\\\">\\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629<\\/h4>\\n<div class=\\\"alert-message\\\" style=\\\"direction: rtl;\\\">\\u062a\\u0645 \\u062a\\u0646\\u0635\\u064a\\u0628 \\u062d\\u0632\\u0645\\u0629 \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0644\\u0646\\u0638\\u0627\\u0645 \\u0627\\u062f\\u0627\\u0631\\u0629 \\u0645\\u062d\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0642\\u0639 \\u062c\\u0648\\u0645\\u0644\\u0627\\u060c \\u0628\\u0627\\u0644\\u0643\\u0648\\u062f \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f.<\\/div>\\n<\\/div>\\n        \",\"group\":\"\",\"filename\":\"pkg_ar-AA\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10121, 10124, 'French (fr-FR)', 'language', 'fr-FR', '', '', 0, 1, 0, 0, '{\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"09-01-2024\",\"author\":\"Joomla! Project - French translation team\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"4.4.2\",\"description\":\"fr-FR site language\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10122, 10124, 'French (fr-FR)', 'language', 'fr-FR', '', '', 1, 1, 0, 0, '{\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"09-01-2024\",\"author\":\"Joomla! Project - French translation team\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"4.4.2\",\"description\":\"fr-FR Administrator language\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10123, 10124, 'French (fr-FR)', 'language', 'fr-FR', '', '', 3, 1, 0, 0, '{\"name\":\"French (fr-FR)\",\"type\":\"language\",\"creationDate\":\"09-01-2024\",\"author\":\"Joomla! Project - French translation team\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"4.4.2\",\"description\":\"fr-FR api language\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10124, 0, 'French (fr-FR) Language pack', 'package', 'pkg_fr-FR', '', '', 0, 1, 1, 0, '{\"name\":\"French (fr-FR) Language pack\",\"type\":\"package\",\"creationDate\":\"09-01-2024\",\"author\":\"Joomla! Project - French translation team\",\"copyright\":\"Copyright (C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"4.4.2.1\",\"description\":\"<div style=\\\"text-align: left;\\\">\\n<h3>Joomla! 4 Full French (fr-FR) Language Package - Version 4.4.2 v1<\\/h3>\\n<h3>Pack de langue Joomla! 4 fran\\u00e7ais (fr-FR) complet - Version 4.4.2 v1<\\/h3>\\n<p><a href=\\\"https:\\/www.joomla.fr\\\" target=\\\"_blank\\\">www.joomla.fr<\\/a> - <a href=\\\"mailto:traduction@joomla.fr\\\">traduction@joomla.fr<\\/a><\\/p>\\n<\\/div>\",\"group\":\"\",\"filename\":\"pkg_fr-FR\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10127, 0, 'PLG_EASYSTORE_UPDATER', 'plugin', 'easystoreupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_UPDATER\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.3\",\"description\":\"PLG_EASYSTORE_UPDATER_DESC\",\"group\":\"\",\"filename\":\"easystoreupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10128, 0, 'SP Simple Portfolio - SP Page Builder', 'plugin', 'sppagebuilder', '', 'spsimpleportfolio', 0, 0, 1, 0, '{\"name\":\"SP Simple Portfolio - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Mar 2019\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.2.6\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10129, 0, 'jewels', 'template', 'jewels', '', '', 0, 1, 1, 0, '{\"name\":\"jewels\",\"type\":\"template\",\"creationDate\":\"Nov 2023\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2023 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"Jewels - A Jewellery And Watch eCommerce Joomla Template\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10130, 0, 'plg_quickicon_eos', 'plugin', 'eos', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(10131, 0, 'plg_behaviour_compat', 'plugin', 'compat', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_compat\",\"type\":\"plugin\",\"creationDate\":\"2023-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_COMPAT_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat\",\"filename\":\"compat\"}', '{}', '', NULL, NULL, -1, 0, NULL, 1),
(10133, 0, 'PLG_EASYSTORE_MAIL', 'plugin', 'easystoremail', '', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_MAIL\",\"type\":\"plugin\",\"creationDate\":\"2023-12\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_EASYSTORE_MAIL_DESC\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\System\\\\EasyStoreMail\",\"filename\":\"easystoremail\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10134, 0, 'plg_finder_easystore', 'plugin', 'easystore', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_easystore\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_FINDER_EASYSTORE_XML_DESCRIPTION\",\"group\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Finder\\\\Easystore\",\"filename\":\"easystore\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0);


-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--


DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__languages`
--


INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES 
(1, 0, 'en-GB', 'English (en-GB)', 'English (United Kingdom)', 'en', 'en_gb', '', '', '', '', 1, 1, 3),
(2, 113, 'ar-AA', 'Arabic (اللغة العربية)', 'Arabic (اللغة العربية)', 'ar', 'ar_aa', '', NULL, '', '', 1, 1, 2),
(3, 114, 'fr-FR', 'French (fr-FR)', 'Français (France)', 'fr', 'fr_fr', '', NULL, '', '', 1, 1, 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--


DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `browserNav` tinyint NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=721 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__menu`
--


INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES 
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, NULL, NULL, 0, 0, '', 0, '', 0, 121, 0, '*', 0, NULL, NULL),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, NULL, NULL, 0, 0, 'class:bookmark', 0, '', 37, 46, 0, '*', 1, NULL, NULL),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners&view=banners', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners', 0, '', 38, 39, 0, '*', 1, NULL, NULL),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&view=categories&extension=com_banners', 'component', 1, 2, 2, 6, NULL, NULL, 0, 0, 'class:banners-cat', 0, '', 40, 41, 0, '*', 1, NULL, NULL),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-clients', 0, '', 42, 43, 0, '*', 1, NULL, NULL),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-tracks', 0, '', 44, 45, 0, '*', 1, NULL, NULL),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, NULL, NULL, 0, 0, 'class:address-book', 0, '', 47, 58, 0, '*', 1, NULL, NULL),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact&view=contacts', 'component', 1, 7, 2, 8, NULL, NULL, 0, 0, 'class:contact', 0, '', 48, 49, 0, '*', 1, NULL, NULL),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&view=categories&extension=com_contact', 'component', 1, 7, 2, 6, NULL, NULL, 0, 0, 'class:contact-cat', 0, '', 50, 51, 0, '*', 1, NULL, NULL),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, NULL, NULL, 0, 0, 'class:rss', 0, '', 59, 64, 0, '*', 1, NULL, NULL),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds&view=newsfeeds', 'component', 1, 13, 2, 17, NULL, NULL, 0, 0, 'class:newsfeeds', 0, '', 60, 61, 0, '*', 1, NULL, NULL),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&view=categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, NULL, NULL, 0, 0, 'class:newsfeeds-cat', 0, '', 62, 63, 0, '*', 1, NULL, NULL),
(18, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, NULL, NULL, 0, 0, 'class:search-plus', 0, '', 65, 76, 0, '*', 1, NULL, NULL),
(20, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags&view=tags', 'component', 1, 1, 1, 29, NULL, NULL, 0, 1, 'class:tags', 0, '', 77, 78, 0, '', 1, NULL, NULL),
(22, 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations&view=associations', 'component', 1, 1, 1, 34, NULL, NULL, 0, 0, 'class:language', 0, '', 79, 80, 0, '*', 1, NULL, NULL),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=9', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 1, 6, 1, '*', 0, NULL, NULL),
(108, 'mainmenu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"badge\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"faicon\\\":\\\"\\\",\\\"megamenu\\\":\\\"0\\\",\\\"menualign\\\":\\\"right\\\",\\\"showtitle\\\":\\\"1\\\",\\\"width\\\":\\\"600\\\"}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 13, 28, 0, '*', 0, NULL, NULL),
(109, 'mainmenu', 'Login', 'login', '', 'pages/login', 'index.php?option=com_users&view=login', 'component', 1, 108, 2, 25, NULL, NULL, 0, 1, ' ', 0, '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"login_image_alt\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"logout_image_alt\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 24, 25, 0, '*', 0, NULL, NULL),
(110, 'mainmenu', 'Registration', 'registration', '', 'pages/registration', 'index.php?option=com_users&view=registration', 'component', 1, 108, 2, 25, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 26, 27, 0, '*', 0, NULL, NULL),
(116, 'company', 'Conditions', 'conditions', '', 'conditions', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 33, 34, 0, '*', 0, NULL, NULL),
(179, 'main', '-', '1629471804-0575', '', 'Contacts/1629471804-0575', '#', 'separator', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 52, 53, 0, '*', 1, NULL, NULL),
(180, 'main', 'mod_menu_fields', 'contact-custom-fields', '', 'Contacts/contact-custom-fields', 'index.php?option=com_fields&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 54, 55, 0, '*', 1, NULL, NULL),
(181, 'main', 'mod_menu_fields_group', 'contact-custom-fields-group', '', 'Contacts/contact-custom-fields-group', 'index.php?option=com_fields&view=groups&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 56, 57, 0, '*', 1, NULL, NULL),
(182, 'main', '-', '1629471804-0617', '', 'Smart Search/1629471804-0617', '#', 'separator', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 66, 67, 0, '*', 1, NULL, NULL),
(183, 'main', 'com_finder_index', 'smart-search-index', '', 'Smart Search/smart-search-index', 'index.php?option=com_finder&view=index', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 68, 69, 0, '*', 1, NULL, NULL),
(184, 'main', 'com_finder_maps', 'smart-search-maps', '', 'Smart Search/smart-search-maps', 'index.php?option=com_finder&view=maps', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 70, 71, 0, '*', 1, NULL, NULL),
(185, 'main', 'com_finder_filters', 'smart-search-filters', '', 'Smart Search/smart-search-filters', 'index.php?option=com_finder&view=filters', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 72, 73, 0, '*', 1, NULL, NULL),
(186, 'main', 'com_finder_searches', 'smart-search-searches', '', 'Smart Search/smart-search-searches', 'index.php?option=com_finder&view=searches', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 74, 75, 0, '*', 1, NULL, NULL),
(246, 'main', 'Search', 'search', '', 'search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, NULL, NULL, 0, 1, 'class:search', 0, '{}', 81, 82, 0, '', 1, NULL, NULL),
(295, 'mainmenu', 'Shop', 'shop', '', 'shop', 'index.php?option=com_easystore&view=products&catid=0', 'component', 1, 1, 1, 10112, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"Shop\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 7, 8, 0, '*', 0, NULL, NULL),
(300, 'mainmenu', 'Customer Profile', 'customer-profile', '', 'pages/customer-profile', 'index.php?option=com_easystore&view=profile', 'component', 1, 108, 2, 10112, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 18, 19, 0, '*', 0, NULL, NULL),
(301, 'mainmenu', 'Contact', 'contact', '', 'pages/contact', 'index.php?option=com_sppagebuilder&view=page&id=32', 'component', 1, 108, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\" \",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 20, 21, 0, '*', 0, NULL, NULL),
(328, 'mainmenu', 'About', 'about', '', 'about', 'index.php?option=com_sppagebuilder&view=page&id=31', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 9, 10, 0, '*', 0, NULL, NULL),
(472, 'mainmenu', 'Wishlist', 'wishlist', '', 'wishlist', 'index.php?option=com_sppagebuilder&view=page&id=22', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":0,\"menu_show\":0,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 29, 30, 0, '*', 0, NULL, NULL),
(632, 'mainmenu', 'Love &amp; Engagement', 'love-amp-engagement', '', 'home/love-amp-engagement', 'index.php?option=com_sppagebuilder&view=page&id=24', 'component', 1, 101, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{}', 2, 3, 0, '*', 0, NULL, NULL),
(633, 'mainmenu', 'Watches', 'watches', '', 'home/watches', 'index.php?option=com_sppagebuilder&view=page&id=25', 'component', 1, 101, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{}', 4, 5, 0, '*', 0, NULL, NULL),
(634, 'mainmenu', 'Stores', 'stores', '', 'stores', 'index.php?option=com_sppagebuilder&view=page&id=26', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 11, 12, 0, '*', 0, NULL, NULL),
(681, 'company', 'Refund policy', 'refund-policy', '', 'refund-policy', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 35, 36, 0, '*', 0, NULL, NULL),
(682, 'company', 'Guaranties', 'guaranties', '', 'guaranties', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 31, 32, 0, '*', 0, NULL, NULL),
(683, 'mainmenu', 'Shipping &amp; Returns', 'shipping-amp-returns', '', 'pages/shipping-amp-returns', 'index.php?option=com_sppagebuilder&view=page&id=33', 'component', 1, 108, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{}', 16, 17, 0, '*', 0, NULL, NULL),
(684, 'mainmenu', 'FAQ', 'faq', '', 'pages/faq', 'index.php?option=com_sppagebuilder&view=page&id=29', 'component', 1, 108, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{}', 22, 23, 0, '*', 0, NULL, NULL),
(685, 'mainmenu', 'Make An Appointment', 'make-an-appointment', '', 'pages/make-an-appointment', 'index.php?option=com_sppagebuilder&view=page&id=28', 'component', 1, 108, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{}', 14, 15, 0, '*', 0, NULL, NULL),
(700, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder&view=editor', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 83, 94, 0, '', 1, NULL, NULL),
(701, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_PAGES', 'com-sppagebuilder-admin-menu-pages', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-pages', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component', 'component', 1, 700, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 84, 85, 0, '', 1, NULL, NULL),
(702, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_MEDIA', 'com-sppagebuilder-admin-menu-media', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-media', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/media-manager', 'component', 1, 700, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 86, 87, 0, '', 1, NULL, NULL),
(703, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_CATEGORIES', 'com-sppagebuilder-admin-menu-categories', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-categories', 'index.php?option=com_categories&extension=com_sppagebuilder', 'component', 1, 700, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 88, 89, 0, '', 1, NULL, NULL),
(704, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_EASYSTOE', 'com-sppagebuilder-admin-menu-easystoe', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-easystoe', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/editor/storefront', 'component', 1, 700, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 90, 91, 0, '', 1, NULL, NULL),
(705, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_SETTINGS', 'com-sppagebuilder-admin-menu-settings', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-settings', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/settings', 'component', 1, 700, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 92, 93, 0, '', 1, NULL, NULL),
(706, 'main', 'COM_EASYSTORE', 'com-easystore', '', 'com-easystore', 'index.php?option=com_easystore', 'component', 1, 1, 1, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 95, 116, 0, '', 1, NULL, NULL),
(707, 'main', 'COM_EASYSTORE_DASHBOARD', 'com-easystore-dashboard', '', 'com-easystore/com-easystore-dashboard', 'index.php?option=com_easystore&view=dashboard', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 96, 97, 0, '', 1, NULL, NULL),
(708, 'main', 'COM_EASYSTORE_PRODUCTS', 'com-easystore-products', '', 'com-easystore/com-easystore-products', 'index.php?option=com_easystore&view=products', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 98, 99, 0, '', 1, NULL, NULL),
(709, 'main', 'COM_EASYSTORE_CATEGORIES', 'com-easystore-categories', '', 'com-easystore/com-easystore-categories', 'index.php?option=com_easystore&view=categories', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 100, 101, 0, '', 1, NULL, NULL),
(710, 'main', 'COM_EASYSTORE_TAGS', 'com-easystore-tags', '', 'com-easystore/com-easystore-tags', 'index.php?option=com_easystore&view=tags', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 102, 103, 0, '', 1, NULL, NULL),
(711, 'main', 'COM_EASYSTORE_ORDERS', 'com-easystore-orders', '', 'com-easystore/com-easystore-orders', 'index.php?option=com_easystore&view=orders', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 104, 105, 0, '', 1, NULL, NULL),
(712, 'main', 'COM_EASYSTORE_COUPONS', 'com-easystore-coupons', '', 'com-easystore/com-easystore-coupons', 'index.php?option=com_easystore&view=coupons', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 106, 107, 0, '', 1, NULL, NULL),
(713, 'main', 'COM_EASYSTORE_REVIEWS', 'com-easystore-reviews', '', 'com-easystore/com-easystore-reviews', 'index.php?option=com_easystore&view=reviews', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 108, 109, 0, '', 1, NULL, NULL),
(714, 'main', 'COM_EASYSTORE_ANALYTICS', 'com-easystore-analytics', '', 'com-easystore/com-easystore-analytics', 'index.php?option=com_easystore&view=analytics', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 110, 111, 0, '', 1, NULL, NULL),
(715, 'main', 'COM_EASYSTORE_CUSTOMERS', 'com-easystore-customers', '', 'com-easystore/com-easystore-customers', 'index.php?option=com_easystore&view=customers', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 112, 113, 0, '', 1, NULL, NULL),
(716, 'main', 'COM_EASYSTORE_SETTINGS', 'com-easystore-settings', '', 'com-easystore/com-easystore-settings', 'index.php?option=com_easystore&view=settings', 'component', 1, 706, 2, 10112, NULL, NULL, 0, 1, 'class:component', 0, '{}', 114, 115, 0, '', 1, NULL, NULL),
(719, 'main', 'COM_QSBUILDER', 'com-qsbuilder', '', 'com-qsbuilder', 'index.php?option=com_qsbuilder', 'component', 1, 1, 1, 10136, NULL, NULL, 0, 1, 'class:component', 0, '{}', 117, 120, 0, '', 1, NULL, NULL),
(720, 'main', 'Build Quick Start Pack', 'build-quick-start-pack', '', 'com-qsbuilder/build-quick-start-pack', 'index.php?option=com_qsbuilder&tmpl=component', 'component', 1, 719, 2, 10136, NULL, NULL, 0, 1, 'class:code', 0, '{}', 118, 119, 0, '', 1, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--


DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__menu_types`
--


INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES 
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 75, 'company', 'Company', '', 0),
(3, 76, 'quick-links', 'Quick Links', '', 0);


-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--


DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint unsigned NOT NULL DEFAULT '1',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__modules`
--


INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES 
(2, 40, 'Login', '', '', 1, 'login', NULL, NULL, NULL, NULL, 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 41, 'Popular Articles', '', '', 3, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(4, 42, 'Recently Added Articles', '', '', 4, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(8, 43, 'Toolbar', '', '', 1, 'toolbar', NULL, NULL, NULL, NULL, 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 44, 'Notifications', '', '', 3, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 3, 1, '{\"context\":\"update_quickicon\",\"header_icon\":\"fas fa-sync\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"0\",\"show_categories\":\"0\",\"show_media\":\"0\",\"show_menuItems\":\"0\",\"show_modules\":\"0\",\"show_plugins\":\"0\",\"show_templates\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(10, 45, 'Logged-in Users', '', '', 2, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(12, 46, 'Admin Menu', '', '', 1, 'menu', NULL, NULL, NULL, NULL, 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 47, 'Admin Submenu', '', '', 1, 'submenu', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 48, 'User Status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 49, 'Title', '', '', 1, 'title', NULL, NULL, NULL, NULL, 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 51, 'Breadcrumbs', '', '', 1, 'breadcrumb', NULL, NULL, NULL, NULL, 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":0,\"showHome\":1,\"homeText\":\"\",\"showLast\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":0,\"cache_time\":0,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(79, 52, 'Multilanguage status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 53, 'Joomla Version', '', '', 1, 'status', NULL, NULL, NULL, NULL, 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(87, 55, 'Sample Data', '', '', 0, 'cpanel', NULL, NULL, NULL, NULL, 0, 'mod_sampledata', 6, 1, '{}', 1, '*'),
(96, 84, 'Joomla Module', 'Mega Menu', '<div><img src=\"images/gallery1-small.jpg\" alt=\"image\" /></div>', 1, '', NULL, NULL, NULL, NULL, 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(98, 88, 'Latest Articles', 'Mega Menu', '', 1, '', NULL, NULL, NULL, NULL, 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"8\"],\"count\":\"2\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 0, 'Login Support', '', '', 1, 'sidebar', NULL, NULL, NULL, NULL, 1, 'mod_loginsupport', 1, 1, '{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 1, '*'),
(101, 0, 'System Dashboard', '', '', 1, 'cpanel-system', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(102, 0, 'Content Dashboard', '', '', 1, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(103, 0, 'Menus Dashboard', '', '', 1, 'cpanel-menus', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(104, 0, 'Components Dashboard', '', '', 1, 'cpanel-components', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(105, 0, 'Users Dashboard', '', '', 1, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(106, 0, 'Popular Articles', '', '', 3, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(107, 0, 'Recently Added Articles', '', '', 4, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(108, 0, 'Logged-in Users', '', '', 2, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(109, 0, 'Frontend Link', '', '', 5, 'status', NULL, NULL, NULL, NULL, 1, 'mod_frontend', 1, 1, '', 1, '*'),
(110, 0, 'Messages', '', '', 4, 'status', NULL, NULL, NULL, NULL, 1, 'mod_messages', 3, 1, '', 1, '*'),
(111, 0, 'Post Install Messages', '', '', 3, 'status', NULL, NULL, NULL, NULL, 1, 'mod_post_installation_messages', 3, 1, '', 1, '*'),
(112, 0, 'User Status', '', '', 6, 'status', NULL, NULL, NULL, NULL, 1, 'mod_user', 3, 1, '', 1, '*'),
(113, 0, 'Site', '', '', 1, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"site_quickicon\",\"header_icon\":\"fas fa-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(114, 0, 'System', '', '', 2, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"system_quickicon\",\"header_icon\":\"fas fa-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(115, 0, '3rd Party', '', '', 4, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"mod_quickicon\",\"header_icon\":\"fas fa-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(116, 0, 'Help Dashboard', '', '', 1, 'cpanel-help', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(117, 0, 'Privacy Requests', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_dashboard', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(118, 0, 'Privacy Status', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_status', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(120, 0, 'Guided Tours', '', '', 1, 'status', NULL, NULL, NULL, NULL, 1, 'mod_guidedtours', 1, 1, '', 1, '*'),
(122, 111, 'Shop Topbar Carousel', '', '', 1, 'top1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 117, 'Menu Add to Cart', '', '', 1, 'menu-right', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 123, 'Bottom  Section', '', '', 1, 'bottom1', NULL, NULL, NULL, NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(132, 126, 'Footer menu', '', NULL, 1, 'footer2', NULL, NULL, NULL, NULL, 1, 'mod_menu', 1, 0, '{\"menutype\":\"company\",\"base\":\"\",\"startLevel\":1,\"endLevel\":0,\"showAllChildren\":1,\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');


-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--


DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int NOT NULL DEFAULT '0',
  `menuid` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__modules_menu`
--


INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES 
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 0),
(79, 0),
(86, 0),
(87, 0),
(96, 0),
(98, 0),
(100, 0),
(101, 0),
(102, 0),
(103, 0),
(104, 0),
(105, 0),
(106, 0),
(107, 0),
(108, 0),
(109, 0),
(110, 0),
(111, 0),
(112, 0),
(113, 0),
(114, 0),
(115, 0),
(116, 0),
(117, 0),
(118, 0),
(120, 0),
(122, 0),
(124, 0),
(129, 0),
(130, 0),
(131, 0),
(132, 0);


-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--


DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int NOT NULL,
  `version_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__schemas`
--


INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES 
(10000, '5.2.6'),
(10112, '1.0.9');


-- --------------------------------------------------------

--
-- Table structure for table `#__tags`
--


DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE `#__tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__tags`
--


INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES 
(1, 0, 0, 15, 0, '', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '', '', '', '', 539, '2021-08-19 09:54:33', '', 539, '2021-08-19 09:54:33', '', '', 0, '*', 1, NULL, NULL),
(2, 1, 1, 2, 1, 'animations', 'Animations', 'animations', '', '', 1, NULL, '2018-02-26 06:42:28', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(3, 1, 3, 4, 1, 'builder', 'Builder', 'builder', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(4, 1, 5, 6, 1, 'dropdown', 'Dropdown', 'dropdown', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(5, 1, 7, 8, 1, 'drag', 'Drag', 'drag', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(6, 1, 9, 10, 1, 'drop', 'Drop', 'drop', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(7, 1, 11, 12, 1, 'mega-menu', 'Mega Menu', 'mega-menu', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(8, 1, 13, 14, 1, 'features', 'Features', 'features', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 0, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33');


-- --------------------------------------------------------

--
-- Table structure for table `#__template_overrides`
--


DROP TABLE IF EXISTS `#__template_overrides`;
CREATE TABLE `#__template_overrides` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int DEFAULT '0',
  `state` tinyint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__template_overrides`
--


INSERT INTO `#__template_overrides` (`id`, `template`, `hash_id`, `extension_id`, `state`, `action`, `client_id`, `created_date`, `modified_date`) VALUES 
(1, 'jewels', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvYmxvZ19jaGlsZHJlbi5waHA=', 10129, 1, 'Joomla Update', 0, '2023-10-20 13:09:10', '2023-10-20 13:09:10'),
(2, 'jewels', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9jaGlsZHJlbi5waHA=', 10129, 1, 'Joomla Update', 0, '2023-10-20 13:09:10', '2023-10-20 13:09:10'),
(3, 'jewels', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9yZXN1bHRzLnBocA==', 10129, 1, 'Joomla Update', 0, '2023-10-20 13:09:11', '2023-10-20 13:09:11'),
(4, 'jewels', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZWRpdC5waHA=', 10129, 1, 'Joomla Update', 0, '2023-10-20 13:09:11', '2023-10-20 13:09:11'),
(5, 'jewels', 'L2h0bWwvbW9kX2ZpbmRlci9kZWZhdWx0LnBocA==', 10129, 1, 'Joomla Update', 0, '2023-10-20 13:09:11', '2023-10-20 13:09:11'),
(6, 'jewels', 'L2h0bWwvY29tX3RhZ3MvdGFnL2RlZmF1bHQucGhw', 10129, 1, 'Joomla Update', 0, '2024-02-19 10:05:47', '2024-02-19 10:05:47'),
(7, 'jewels', 'L2h0bWwvY29tX3RhZ3MvdGFnL2xpc3QucGhw', 10129, 1, 'Joomla Update', 0, '2024-02-19 10:05:47', '2024-02-19 10:05:47');


-- --------------------------------------------------------

--
-- Table structure for table `#__template_styles`
--


DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE `#__template_styles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `home` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint NOT NULL DEFAULT '0',
  `parent` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__template_styles`
--


INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`, `inheritable`, `parent`) VALUES 
(10, 'atum', 1, '1', 'Atum - Default', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}', 1, ''),
(11, 'cassiopeia', 0, '0', 'Cassiopeia - Default', '{}', 1, ''),
(14, 'jewels', 0, '1', 'jewels - Default', '{\"logo_type\":\"image\",\"logo_image\":\"\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"46px\",\"logo_height_sm\":\"26px\",\"logo_height_xs\":\"30px\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"\",\"predefined_header\":\"1\",\"header_style\":\"style-2\",\"header_height\":\"80px\",\"header_height_sm\":\"76px\",\"header_height_xs\":\"70px\",\"enable_login\":\"1\",\"sticky_header\":\"1\",\"sticky_offset\":\"100\",\"loader_type\":\"circle\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"after\",\"facebook\":\"#\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"#\",\"dribbble\":\"\",\"instagram\":\"#\",\"behance\":\"\",\"youtube\":\"#\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+ 1 22 33 444\",\"contact_mobile\":\"+ 333 555 888\",\"contact_email\":\"contact@joomshaper.com\",\"contact_time\":\"Opening Hours: 24\\/7\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-10-10\",\"comingsoon_social_icons\":\"1\",\"comingsoon_title_status\":\"1\",\"comingsoon_content_status\":\"1\",\"comingsoon_countdown\":\"1\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#675949\\\",\\\"bg_color\\\":\\\"#FBF8F5\\\",\\\"link_color\\\":\\\"#675949\\\",\\\"link_hover_color\\\":\\\"#EA9964\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#000000\\\",\\\"topbar_text_color\\\":\\\"#FFFFFF\\\",\\\"logo_text_color\\\":\\\"#000000\\\",\\\"menu_text_color\\\":\\\"#675949\\\",\\\"menu_text_hover_color\\\":\\\"#EA9964\\\",\\\"menu_text_active_color\\\":\\\"#EA9964\\\",\\\"menu_dropdown_bg_color\\\":\\\"#F8F8F8\\\",\\\"menu_dropdown_text_color\\\":\\\"#675949\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#EA9964\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#EA9964\\\",\\\"footer_bg_color\\\":\\\"#FFFFFF\\\",\\\"footer_text_color\\\":\\\"#675949\\\",\\\"footer_link_color\\\":\\\"#675949\\\",\\\"footer_link_hover_color\\\":\\\"#EA9964\\\",\\\"preset\\\":\\\"preset1\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#EA9964\\\",\\\"footer_link_color\\\":\\\"#675949\\\",\\\"footer_text_color\\\":\\\"#675949\\\",\\\"footer_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#EA9964\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#EA9964\\\",\\\"menu_dropdown_text_color\\\":\\\"#675949\\\",\\\"menu_dropdown_bg_color\\\":\\\"#F8F8F8\\\",\\\"menu_text_active_color\\\":\\\"#EA9964\\\",\\\"menu_text_hover_color\\\":\\\"#EA9964\\\",\\\"menu_text_color\\\":\\\"#675949\\\",\\\"logo_text_color\\\":\\\"#000000\\\",\\\"topbar_text_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#000000\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"link_hover_color\\\":\\\"#EA9964\\\",\\\"link_color\\\":\\\"#675949\\\",\\\"bg_color\\\":\\\"#FBF8F5\\\",\\\"text_color\\\":\\\"#675949\\\",\\\"preset\\\":\\\"preset1\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"Page Title\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"Bottom\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+8\\\",\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":8}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"250px\",\"menu_animation\":\"menu-animation-fade-up\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"offcanvas_enable_social\":\"1\",\"offcanvas_enable_contact\":\"1\",\"enable_body_font\":\"1\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Lato\\\",\\\"fontSize\\\":\\\"14px\\\",\\\"fontSize_sm\\\":\\\"14px\\\",\\\"fontSize_xs\\\":\\\"14px\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Cormorant\\\",\\\"fontSize\\\":\\\"48px\\\",\\\"fontSize_sm\\\":\\\"32px\\\",\\\"fontSize_xs\\\":\\\"26px\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Cormorant\\\",\\\"fontSize\\\":\\\"32px\\\",\\\"fontSize_sm\\\":\\\"26px\\\",\\\"fontSize_xs\\\":\\\"24px\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Cormorant\\\",\\\"fontSize\\\":\\\"26px\\\",\\\"fontSize_sm\\\":\\\"24px\\\",\\\"fontSize_xs\\\":\\\"22px\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Cormorant\\\",\\\"fontSize\\\":\\\"24px\\\",\\\"fontSize_sm\\\":\\\"20px\\\",\\\"fontSize_xs\\\":\\\"18px\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Cormorant\\\",\\\"fontSize\\\":\\\"20px\\\",\\\"fontSize_sm\\\":\\\"18px\\\",\\\"fontSize_xs\\\":\\\"16px\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontSubset\\\":\\\"cyrillic\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_navigation_font\":\"1\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Lato\\\",\\\"fontSize\\\":\\\"18px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"180x200\",\"image_small_size\":\"180x200\",\"image_medium_size\":\"180x200\",\"image_large_size\":\"180x200\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"large\",\"leading_blog_list_image\":\"large\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article\":\"1\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"gst\",\"id\":\"14\",\"template\":\"jewels\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"jewels - Default\"}', 0, '');


-- --------------------------------------------------------

--
-- Table structure for table `#__updates`
--


DROP TABLE IF EXISTS `#__updates`;
CREATE TABLE `#__updates` (
  `update_id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `extension_id` int DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint DEFAULT '0',
  `version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';


--
-- Dumping data for table `#__updates`
--


INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `changelogurl`, `extra_query`) VALUES 
(1, 2, 0, 'Afrikaans', '', 'pkg_af-ZA', 'package', '', 0, '4.4.2.2', '', 'https://update.joomla.org/language/details4/af-ZA_details.xml', '', '', ''),
(2, 2, 10120, 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', 0, '4.0.2.1', '', 'https://update.joomla.org/language/details4/ar-AA_details.xml', '', '', ''),
(3, 2, 0, 'Basque', '', 'pkg_eu-ES', 'package', '', 0, '4.4.3.5', '', 'https://update.joomla.org/language/details4/eu-ES_details.xml', '', '', ''),
(4, 2, 0, 'Belarusian', '', 'pkg_be-BY', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/be-BY_details.xml', '', '', ''),
(5, 2, 0, 'Bulgarian', '', 'pkg_bg-BG', 'package', '', 0, '4.3.3.1', '', 'https://update.joomla.org/language/details4/bg-BG_details.xml', '', '', ''),
(6, 2, 0, 'Catalan', '', 'pkg_ca-ES', 'package', '', 0, '4.0.4.2', '', 'https://update.joomla.org/language/details4/ca-ES_details.xml', '', '', ''),
(7, 2, 0, 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', 0, '4.3.0.2', '', 'https://update.joomla.org/language/details4/zh-CN_details.xml', '', '', ''),
(8, 2, 0, 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/zh-TW_details.xml', '', '', ''),
(9, 2, 0, 'Croatian', '', 'pkg_hr-HR', 'package', '', 0, '4.3.1.1', '', 'https://update.joomla.org/language/details4/hr-HR_details.xml', '', '', ''),
(10, 2, 0, 'Czech', '', 'pkg_cs-CZ', 'package', '', 0, '4.4.0.1', '', 'https://update.joomla.org/language/details4/cs-CZ_details.xml', '', '', ''),
(11, 2, 0, 'Danish', '', 'pkg_da-DK', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/da-DK_details.xml', '', '', ''),
(12, 2, 0, 'Dutch', '', 'pkg_nl-NL', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/nl-NL_details.xml', '', '', ''),
(13, 2, 0, 'English, Australia', '', 'pkg_en-AU', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/en-AU_details.xml', '', '', ''),
(14, 2, 0, 'English, Canada', '', 'pkg_en-CA', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/en-CA_details.xml', '', '', ''),
(15, 2, 0, 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/en-NZ_details.xml', '', '', ''),
(16, 2, 0, 'English, USA', '', 'pkg_en-US', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/en-US_details.xml', '', '', ''),
(17, 2, 0, 'Estonian', '', 'pkg_et-EE', 'package', '', 0, '4.4.1.2', '', 'https://update.joomla.org/language/details4/et-EE_details.xml', '', '', ''),
(18, 2, 0, 'Finnish', '', 'pkg_fi-FI', 'package', '', 0, '4.1.1.2', '', 'https://update.joomla.org/language/details4/fi-FI_details.xml', '', '', ''),
(19, 2, 0, 'Flemish', '', 'pkg_nl-BE', 'package', '', 0, '4.4.0.1', '', 'https://update.joomla.org/language/details4/nl-BE_details.xml', '', '', ''),
(20, 2, 0, 'French, Canada', '', 'pkg_fr-CA', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/fr-CA_details.xml', '', '', ''),
(21, 2, 0, 'Georgian', '', 'pkg_ka-GE', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/ka-GE_details.xml', '', '', ''),
(22, 2, 0, 'German', '', 'pkg_de-DE', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/de-DE_details.xml', '', '', ''),
(23, 2, 0, 'German, Austria', '', 'pkg_de-AT', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/de-AT_details.xml', '', '', ''),
(24, 2, 0, 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/de-LI_details.xml', '', '', ''),
(25, 2, 0, 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/de-LU_details.xml', '', '', ''),
(26, 2, 0, 'German, Switzerland', '', 'pkg_de-CH', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/de-CH_details.xml', '', '', ''),
(27, 2, 0, 'Greek', '', 'pkg_el-GR', 'package', '', 0, '4.4.2.2', '', 'https://update.joomla.org/language/details4/el-GR_details.xml', '', '', ''),
(28, 2, 0, 'Hungarian', '', 'pkg_hu-HU', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/hu-HU_details.xml', '', '', ''),
(29, 2, 0, 'Irish', '', 'pkg_ga-IE', 'package', '', 0, '4.2.8.1', '', 'https://update.joomla.org/language/details4/ga-IE_details.xml', '', '', ''),
(30, 2, 0, 'Italian', '', 'pkg_it-IT', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/it-IT_details.xml', '', '', ''),
(31, 2, 0, 'Japanese', '', 'pkg_ja-JP', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/ja-JP_details.xml', '', '', ''),
(32, 2, 0, 'Kazakh', '', 'pkg_kk-KZ', 'package', '', 0, '4.4.0.3', '', 'https://update.joomla.org/language/details4/kk-KZ_details.xml', '', '', ''),
(33, 2, 0, 'Korean', '', 'pkg_ko-KR', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/ko-KR_details.xml', '', '', ''),
(34, 2, 0, 'Latvian', '', 'pkg_lv-LV', 'package', '', 0, '4.4.1.1', '', 'https://update.joomla.org/language/details4/lv-LV_details.xml', '', '', ''),
(35, 2, 0, 'Lithuanian', '', 'pkg_lt-LT', 'package', '', 0, '4.3.4.1', '', 'https://update.joomla.org/language/details4/lt-LT_details.xml', '', '', ''),
(36, 2, 0, 'Macedonian', '', 'pkg_mk-MK', 'package', '', 0, '4.2.4.1', '', 'https://update.joomla.org/language/details4/mk-MK_details.xml', '', '', ''),
(37, 2, 0, 'Norwegian Bokmål', '', 'pkg_nb-NO', 'package', '', 0, '4.0.1.1', '', 'https://update.joomla.org/language/details4/nb-NO_details.xml', '', '', ''),
(38, 2, 0, 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', 0, '4.3.4.1', '', 'https://update.joomla.org/language/details4/ps-AF_details.xml', '', '', ''),
(39, 2, 0, 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/fa-IR_details.xml', '', '', ''),
(40, 2, 0, 'Polish', '', 'pkg_pl-PL', 'package', '', 0, '4.4.0.2', '', 'https://update.joomla.org/language/details4/pl-PL_details.xml', '', '', ''),
(41, 2, 0, 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', 0, '4.0.3.1', '', 'https://update.joomla.org/language/details4/pt-BR_details.xml', '', '', ''),
(42, 2, 0, 'Portuguese, Portugal', '', 'pkg_pt-PT', 'package', '', 0, '4.0.0-rc4.2', '', 'https://update.joomla.org/language/details4/pt-PT_details.xml', '', '', ''),
(43, 2, 0, 'Romanian', '', 'pkg_ro-RO', 'package', '', 0, '4.3.1.1', '', 'https://update.joomla.org/language/details4/ro-RO_details.xml', '', '', ''),
(44, 2, 0, 'Russian', '', 'pkg_ru-RU', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/ru-RU_details.xml', '', '', ''),
(45, 2, 0, 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', 0, '4.3.2.1', '', 'https://update.joomla.org/language/details4/sr-RS_details.xml', '', '', ''),
(46, 2, 0, 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', 0, '4.3.2.2', '', 'https://update.joomla.org/language/details4/sr-YU_details.xml', '', '', ''),
(47, 2, 0, 'Slovak', '', 'pkg_sk-SK', 'package', '', 0, '4.4.1.1', '', 'https://update.joomla.org/language/details4/sk-SK_details.xml', '', '', ''),
(48, 2, 0, 'Slovenian', '', 'pkg_sl-SI', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/sl-SI_details.xml', '', '', ''),
(49, 2, 0, 'Spanish', '', 'pkg_es-ES', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/es-ES_details.xml', '', '', ''),
(50, 2, 0, 'Swedish', '', 'pkg_sv-SE', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/sv-SE_details.xml', '', '', ''),
(51, 2, 0, 'Tamil, India', '', 'pkg_ta-IN', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/ta-IN_details.xml', '', '', ''),
(52, 2, 0, 'Thai', '', 'pkg_th-TH', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/th-TH_details.xml', '', '', ''),
(53, 2, 0, 'Turkish', '', 'pkg_tr-TR', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/tr-TR_details.xml', '', '', ''),
(54, 2, 0, 'Ukrainian', '', 'pkg_uk-UA', 'package', '', 0, '4.4.1.1', '', 'https://update.joomla.org/language/details4/uk-UA_details.xml', '', '', ''),
(55, 2, 0, 'Vietnamese', '', 'pkg_vi-VN', 'package', '', 0, '4.2.2.1', '', 'https://update.joomla.org/language/details4/vi-VN_details.xml', '', '', ''),
(56, 2, 0, 'Welsh', '', 'pkg_cy-GB', 'package', '', 0, '4.4.2.1', '', 'https://update.joomla.org/language/details4/cy-GB_details.xml', '', '', '');


-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites`
--


DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE `#__update_sites` (
  `update_site_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int DEFAULT '0',
  `last_check_timestamp` bigint DEFAULT '0',
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';


--
-- Dumping data for table `#__update_sites`
--


INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`, `checked_out`, `checked_out_time`) VALUES 
(1, 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', 1, 1708412713, '', NULL, NULL),
(2, 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_4.xml', 1, 1708412714, '', NULL, NULL),
(3, 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', 1, 1708412715, '', NULL, NULL),
(169, 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', 1, 1708412715, '', NULL, NULL),
(170, 'jewels', 'extension', 'https://www.joomshaper.com/updates/jewels.xml', 1, 1708412716, '', NULL, NULL),
(171, 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro-next.xml', 1, 1708412716, 'joomshaper_email=mdamjadrana%40gmail.com&amp;joomshaper_license_key=2ac7afb018a7c0e47c6a1066d7f4eb6f', NULL, NULL),
(172, 'EasyStore', 'extension', 'https://www.joomshaper.com/updates/easystore.xml', 1, 1708412717, '', NULL, NULL),
(173, 'Search Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', 1, 1708412717, '', NULL, NULL),
(174, 'Paypal - EasyStore Payment Plugin', 'extension', 'https://www.joomshaper.com/updates/easystore-paypal.xml', 1, 1708412718, '', NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites_extensions`
--


DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int NOT NULL DEFAULT '0',
  `extension_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';


--
-- Dumping data for table `#__update_sites_extensions`
--


INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES 
(1, 700),
(2, 802),
(2, 10120),
(2, 10124),
(3, 28),
(169, 10004),
(170, 10129),
(171, 10000),
(172, 10112),
(173, 10067),
(174, 10115);


-- --------------------------------------------------------

--
-- Table structure for table `#__viewlevels`
--


DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE `#__viewlevels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__viewlevels`
--


INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES 
(1, 'Public', 0, '[1]'),
(2, 'Registered', 2, '[6,2,8]'),
(3, 'Special', 3, '[6,3,8]'),
(5, 'Guest', 1, '[9]'),
(6, 'Super Users', 4, '[8]');


-- --------------------------------------------------------

--
-- Table structure for table `#__workflows`
--


DROP TABLE IF EXISTS `#__workflows`;
CREATE TABLE `#__workflows` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflows`
--


INSERT INTO `#__workflows` (`id`, `asset_id`, `published`, `title`, `description`, `extension`, `default`, `ordering`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`) VALUES 
(1, 56, 1, 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', 1, 1, '2021-08-27 11:24:00', 539, '2021-08-27 11:24:00', 539, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_associations`
--


DROP TABLE IF EXISTS `#__workflow_associations`;
CREATE TABLE `#__workflow_associations` (
  `item_id` int NOT NULL DEFAULT '0' COMMENT 'Extension table id value',
  `stage_id` int NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_associations`
--


INSERT INTO `#__workflow_associations` (`item_id`, `stage_id`, `extension`) VALUES 
(10, 1, 'com_content.article'),
(11, 1, 'com_content.article'),
(12, 1, 'com_content.article'),
(13, 1, 'com_content.article'),
(14, 1, 'com_content.article'),
(15, 1, 'com_content.article'),
(16, 1, 'com_content.article'),
(17, 1, 'com_content.article'),
(18, 1, 'com_content.article');


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_stages`
--


DROP TABLE IF EXISTS `#__workflow_stages`;
CREATE TABLE `#__workflow_stages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_stages`
--


INSERT INTO `#__workflow_stages` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `default`, `checked_out_time`, `checked_out`) VALUES 
(1, 57, 1, 1, 1, 'COM_WORKFLOW_BASIC_STAGE', '', 1, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_transitions`
--


DROP TABLE IF EXISTS `#__workflow_transitions`;
CREATE TABLE `#__workflow_transitions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int NOT NULL,
  `to_stage_id` int NOT NULL,
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_transitions`
--


INSERT INTO `#__workflow_transitions` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `from_stage_id`, `to_stage_id`, `options`, `checked_out_time`, `checked_out`) VALUES 
(1, 58, 1, 1, 1, 'UNPUBLISH', '', -1, 1, '{\"publishing\":\"0\"}', NULL, NULL),
(2, 59, 2, 1, 1, 'PUBLISH', '', -1, 1, '{\"publishing\":\"1\"}', NULL, NULL),
(3, 60, 3, 1, 1, 'TRASH', '', -1, 1, '{\"publishing\":\"-2\"}', NULL, NULL),
(4, 61, 4, 1, 1, 'ARCHIVE', '', -1, 1, '{\"publishing\":\"2\"}', NULL, NULL),
(5, 62, 5, 1, 1, 'FEATURE', '', -1, 1, '{\"featuring\":\"1\"}', NULL, NULL),
(6, 63, 6, 1, 1, 'UNFEATURE', '', -1, 1, '{\"featuring\":\"0\"}', NULL, NULL),
(7, 64, 7, 1, 1, 'PUBLISH_AND_FEATURE', '', -1, 1, '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--


DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__associations`
--


INSERT INTO `#__associations` (`id`, `context`, `key`) VALUES 
(296, 'com_menus.item', 'f3379e6e862f19aad837f894587d167e'),
(297, 'com_menus.item', 'f3379e6e862f19aad837f894587d167e'),
(298, 'com_menus.item', 'f3379e6e862f19aad837f894587d167e');


-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--


DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__categories`
--


INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES 
(1, 0, 0, 0, 13, 0, '', 'system', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '{}', '', '', '{}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(7, 32, 1, 9, 10, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 539, '2021-08-19 09:54:33', 0, '*', 1),
(8, 69, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 539, '2021-08-19 09:54:33', 0, '2021-08-19 09:54:33', 0, '*', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--


DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content_types`
--


INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES 
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(14, 'SP Easy Image Gallery Category', 'com_speasyimagegallery.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');


-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--


DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';



-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--


DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--


DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--


DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--


DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int unsigned NOT NULL,
  `item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_base`
--


DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE `#__ucm_base` (
  `ucm_id` int unsigned NOT NULL,
  `ucm_item_id` int NOT NULL,
  `ucm_type_id` int NOT NULL,
  `ucm_language_id` int NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_content`
--


DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE `#__ucm_content` (
  `core_content_id` int unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int unsigned DEFAULT NULL,
  `core_access` int unsigned NOT NULL DEFAULT '0',
  `core_params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_hits` int unsigned NOT NULL DEFAULT '0',
  `core_version` int unsigned NOT NULL DEFAULT '1',
  `core_ordering` int NOT NULL DEFAULT '0',
  `core_metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_catid` int unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';



-- --------------------------------------------------------

--
-- Table structure for table `#__webauthn_credentials`
--


DROP TABLE IF EXISTS `#__webauthn_credentials`;
CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__mail_templates`
--


DROP TABLE IF EXISTS `#__mail_templates`;
CREATE TABLE `#__mail_templates` (
  `template_id` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__mail_templates`
--


INSERT INTO `#__mail_templates` (`template_id`, `extension`, `language`, `subject`, `body`, `htmlbody`, `attachments`, `params`) VALUES 
('com_actionlogs.notification', 'com_actionlogs', '', 'COM_ACTIONLOGS_EMAIL_SUBJECT', 'COM_ACTIONLOGS_EMAIL_BODY', 'COM_ACTIONLOGS_EMAIL_HTMLBODY', '', '{\"tags\":[\"message\",\"date\",\"extension\",\"username\"]}'),
('com_config.test_mail', 'com_config', '', 'COM_CONFIG_SENDMAIL_SUBJECT', 'COM_CONFIG_SENDMAIL_BODY', '', '', '{\"tags\":[\"sitename\",\"method\"]}'),
('com_contact.mail', 'com_contact', '', 'COM_CONTACT_ENQUIRY_SUBJECT', 'COM_CONTACT_ENQUIRY_TEXT', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}'),
('com_contact.mail.copy', 'com_contact', '', 'COM_CONTACT_COPYSUBJECT_OF', 'COM_CONTACT_COPYTEXT_OF', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\",\"contactname\"]}'),
('com_messages.new_message', 'com_messages', '', 'COM_MESSAGES_NEW_MESSAGE', 'COM_MESSAGES_NEW_MESSAGE_BODY', '', '', '{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}'),
('com_privacy.notification.admin.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.admin.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.userdataexport', 'com_privacy', '', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY', '', '', '{\"tags\":[\"sitename\",\"url\"]}'),
('com_users.massmail.mail', 'com_users', '', 'COM_USERS_MASSMAIL_MAIL_SUBJECT', 'COM_USERS_MASSMAIL_MAIL_BODY', '', '', '{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}'),
('com_users.password_reset', 'com_users', '', 'COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT', 'COM_USERS_EMAIL_PASSWORD_RESET_BODY', '', '', '{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}'),
('com_users.registration.admin.new_notification', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.admin.verification_request', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}'),
('com_users.registration.user.admin_activated', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.registration_mail', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.registration_mail_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.self_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.self_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.reminder', 'com_users', '', 'COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT', 'COM_USERS_EMAIL_USERNAME_REMINDER_BODY', '', '', '{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}'),
('plg_multifactorauth_email.mail', 'plg_multifactorauth_email', '', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_SUBJECT', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_BODY', '', '', '{\"tags\":[\"code\",\"sitename\",\"siteurl\",\"username\",\"email\",\"fullname\"]}'),
('plg_system_privacyconsent.request.reminder', 'plg_system_privacyconsent', '', 'PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT', 'PLG_SYSTEM_PRIVACYCONSENT_EMAIL_REMIND_BODY', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('plg_system_tasknotification.failure_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\", \"exit_code\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_tasknotification.fatal_recovery_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.orphan_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.success_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_BODY', '', '', '{\"tags\":[\"task_id\", \"task_title\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_updatenotification.mail', 'plg_system_updatenotification', '', 'PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_SUBJECT', 'PLG_SYSTEM_UPDATENOTIFICATION_EMAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}'),
('plg_user_joomla.mail', 'plg_user_joomla', '', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}');


-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--


DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--


DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--


DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--


DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__contact_details`
--


INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `publish_up`, `publish_down`, `version`, `hits`) VALUES 
(1, 'Contact', 'contact', '', '', '', '', '', '', '', '', '', '', '', 0, 1, NULL, NULL, 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 228, 4, 1, '', '', '', '', '', '*', '2021-08-19 09:54:33', 874, '', '2021-08-20 09:31:56', 874, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, NULL, NULL, 11, 89);


-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--


DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content`
--


INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES 
(10, 99, 'How Marching for Science Risks Politicizing It', 'how-marching-for-science-risks-politicizing-it', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:42:12', 874, '', '2021-08-27 11:42:23', 874, NULL, NULL, '2021-08-27 11:42:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog1.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 8, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(11, 100, 'After Setbacks and Suits, Miami to Open Science Museum', 'after-setbacks-and-suits-miami-to-open-science-museum', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:43:39', 874, '', '2021-08-27 11:43:39', 874, NULL, NULL, '2021-08-27 11:43:39', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog13.jpg\",\"helix_ultimate_article_format\":\"audio\",\"helix_ultimate_audio\":\"<iframe scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/399014505&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe>\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 7, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(12, 101, 'The New Threat to Wolves in and Around Yellowstone', 'the-new-threat-to-wolves-in-and-around-yellowstone', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:44:20', 874, '', '2021-08-27 11:44:20', 874, NULL, NULL, '2021-08-27 11:44:20', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog2.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 6, '', '', 1, 7, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(13, 102, 'Broke a Glass? Someday You Might 3-D-Print a New One', 'broke-a-glass-someday-you-might-3-d-print-a-new-one', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:45:19', 874, '', '2021-08-27 11:45:19', 874, NULL, NULL, '2021-08-27 11:45:19', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog3.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 5, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(14, 103, 'Jimmy Kimmel Sheds Light on Health Coverage', 'jimmy-kimmel-sheds-light-on-health-coverage', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:46:12', 874, '', '2021-08-27 11:46:12', 874, NULL, NULL, '2021-08-27 11:46:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog4.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(15, 104, 'As Arctic Ice Vanishes, New Shipping Routes Open', 'as-arctic-ice-vanishes-new-shipping-routes-open', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:47:19', 874, '', '2021-08-27 11:47:19', 874, NULL, NULL, '2021-08-27 11:47:19', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog5.jpg\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"https:\\/\\/www.youtube.com\\/watch?v=YZcT74ZqkOA\"}', 1, 3, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(16, 105, 'Want to Make More Baskets? Science Has the Answer', 'want-to-make-more-baskets-science-has-the-answer', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:48:43', 874, '', '2021-08-27 11:48:43', 874, NULL, NULL, '2021-08-27 11:48:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog7.jpg\",\"helix_ultimate_article_format\":\"gallery\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2021\\/08\\/27\\/blog6.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog9.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog10.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog11.jpeg\\\"]}\",\"helix_ultimate_video\":\"\"}', 1, 2, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(17, 106, 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', 'debate-over-paris-climate-deal-could-turn-on-a-single-phrase', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:49:32', 874, '', '2021-08-27 11:49:32', 874, NULL, NULL, '2021-08-27 11:49:32', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog111.jpeg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 1, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(18, 107, 'The Making of a Legacy: First Steps in the Trump Era', 'the-making-of-a-legacy-first-steps-in-the-trump-era', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2021-08-27 11:50:29', 874, '', '2021-08-27 11:50:29', 874, NULL, NULL, '2021-08-27 11:50:29', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2021\\/08\\/27\\/blog12.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 1, 0, '', '', 1, 13, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');


-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--


DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--


DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content_rating`
--


INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES 
(1, 5, 1, '::1'),
(3, 5, 1, '::1'),
(9, 5, 1, '10.0.1.2');


-- --------------------------------------------------------

--
-- Table structure for table `#__scheduler_tasks`
--


DROP TABLE IF EXISTS `#__scheduler_tasks`;
CREATE TABLE `#__scheduler_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint NOT NULL DEFAULT '0',
  `last_exit_code` int NOT NULL DEFAULT '0' COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int DEFAULT '0' COMMENT 'Count of successful triggers',
  `times_failed` int DEFAULT '0' COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0' COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint NOT NULL DEFAULT '0' COMMENT 'If 1, the task is only accessible via CLI',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__guidedtours`
--


DROP TABLE IF EXISTS `#__guidedtours`;
CREATE TABLE `#__guidedtours` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `access` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__guidedtours`
--


INSERT INTO `#__guidedtours` (`id`, `title`, `description`, `ordering`, `extensions`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `published`, `language`, `note`, `access`) VALUES 
(1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_TITLE', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_DESCRIPTION', 1, '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_TITLE', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_DESCRIPTION', 2, '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_TITLE', 'COM_GUIDEDTOURS_TOUR_ARTICLES_DESCRIPTION', 3, '[\"*\"]', 'administrator/index.php?option=com_content&view=articles', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_TITLE', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_DESCRIPTION', 4, '[\"*\"]', 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(5, 'COM_GUIDEDTOURS_TOUR_MENUS_TITLE', 'COM_GUIDEDTOURS_TOUR_MENUS_DESCRIPTION', 5, '[\"*\"]', 'administrator/index.php?option=com_menus&view=menus', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(6, 'COM_GUIDEDTOURS_TOUR_TAGS_TITLE', 'COM_GUIDEDTOURS_TOUR_TAGS_DESCRIPTION', 6, '[\"*\"]', 'administrator/index.php?option=com_tags&view=tags', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(7, 'COM_GUIDEDTOURS_TOUR_BANNERS_TITLE', 'COM_GUIDEDTOURS_TOUR_BANNERS_DESCRIPTION', 7, '[\"*\"]', 'administrator/index.php?option=com_banners&view=banners', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_TITLE', 'COM_GUIDEDTOURS_TOUR_CONTACTS_DESCRIPTION', 8, '[\"*\"]', 'administrator/index.php?option=com_contact&view=contacts', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_TITLE', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_DESCRIPTION', 9, '[\"*\"]', 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_TITLE', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_DESCRIPTION', 10, '[\"*\"]', 'administrator/index.php?option=com_finder&view=filters', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1),
(11, 'COM_GUIDEDTOURS_TOUR_USERS_TITLE', 'COM_GUIDEDTOURS_TOUR_USERS_DESCRIPTION', 11, '[\"*\"]', 'administrator/index.php?option=com_users&view=users', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__guidedtour_steps`
--


DROP TABLE IF EXISTS `#__guidedtour_steps`;
CREATE TABLE `#__guidedtour_steps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tour_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int NOT NULL,
  `interactive_type` int NOT NULL DEFAULT '1',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_tour` (`tour_id`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__guidedtour_steps`
--


INSERT INTO `#__guidedtour_steps` (`id`, `tour_id`, `title`, `published`, `description`, `ordering`, `position`, `target`, `type`, `interactive_type`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `language`, `note`) VALUES 
(1, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_DESCRIPTION', 1, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(2, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_DESCRIPTION', 2, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(3, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_DESCRIPTION', 3, 'top', '#jform_url', 2, 2, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(4, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_DESCRIPTION', 4, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(5, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_DESCRIPTION', 5, 'top', 'joomla-field-fancy-select .choices', 2, 3, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(6, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_DESCRIPTION', 6, 'top', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(7, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_DESCRIPTION', 7, 'bottom', '', 0, 1, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(8, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_DESCRIPTION', 8, 'top', '#toursList tbody tr:nth-last-of-type(1) td:nth-of-type(5) .btn', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(9, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_DESCRIPTION', 9, 'bottom', '.button-new', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(10, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_DESCRIPTION', 10, 'bottom', '#jform_title', 2, 2, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(11, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_DESCRIPTION', 11, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(12, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_DESCRIPTION', 12, 'bottom', '#jform_published', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(13, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_DESCRIPTION', 13, 'top', '#jform_position', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(14, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_DESCRIPTION', 14, 'top', '#jform_target', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(15, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_DESCRIPTION', 15, 'top', '#jform_type', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(16, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_DESCRIPTION', 16, 'bottom', '#save-group-children-save .button-save', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(17, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_DESCRIPTION', 17, 'bottom', '', 0, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(18, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_DESCRIPTION', 18, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_content&view=articles', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(19, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_DESCRIPTION', 19, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(20, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_DESCRIPTION', 20, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(21, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_DESCRIPTION', 21, 'bottom', '#jform_articletext,#jform_articletext_ifr', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(22, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_DESCRIPTION', 22, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(23, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_DESCRIPTION', 23, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(24, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_DESCRIPTION', 24, 'bottom', '#jform_featured0', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(25, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_DESCRIPTION', 25, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(26, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_DESCRIPTION', 26, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(27, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_DESCRIPTION', 27, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(28, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_DESCRIPTION', 28, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(29, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_DESCRIPTION', 29, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(30, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_DESCRIPTION', 30, 'bottom', '', 0, 1, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(31, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_DESCRIPTION', 31, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(32, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_DESCRIPTION', 32, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(33, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_DESCRIPTION', 33, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(34, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_DESCRIPTION', 34, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(35, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_DESCRIPTION', 35, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(36, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_DESCRIPTION', 36, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(37, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_DESCRIPTION', 37, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(38, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_DESCRIPTION', 38, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(39, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_DESCRIPTION', 39, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(40, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_DESCRIPTION', 40, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(41, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_DESCRIPTION', 41, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(42, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_DESCRIPTION', 42, 'bottom', '', 0, 1, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(43, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_DESCRIPTION', 43, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_menus&view=menus', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(44, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_DESCRIPTION', 44, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(45, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_DESCRIPTION', 45, 'top', '#jform_menutype', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(46, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_DESCRIPTION', 46, 'top', '#jform_menudescription', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(47, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_DESCRIPTION', 47, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(48, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_DESCRIPTION', 48, 'bottom', '', 0, 1, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(49, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_DESCRIPTION', 49, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_tags&view=tags', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(50, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_DESCRIPTION', 50, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(51, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_DESCRIPTION', 51, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(52, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_DESCRIPTION', 52, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(53, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_DESCRIPTION', 53, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(54, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_DESCRIPTION', 54, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(55, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_DESCRIPTION', 55, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(56, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_DESCRIPTION', 56, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(57, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_DESCRIPTION', 57, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(58, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_DESCRIPTION', 58, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(59, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_DESCRIPTION', 59, 'bottom', '', 0, 1, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(60, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_DESCRIPTION', 60, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_banners&view=banners', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(61, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_DESCRIPTION', 61, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(62, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_DESCRIPTION', 62, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(63, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_DESCRIPTION', 63, 'bottom', '.col-lg-9', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(64, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_DESCRIPTION', 64, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(65, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_DESCRIPTION', 65, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(66, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_DESCRIPTION', 66, 'bottom', '#jform_sticky1', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(67, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_DESCRIPTION', 67, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(68, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_DESCRIPTION', 68, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(69, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_DESCRIPTION', 69, 'bottom', '', 0, 1, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(70, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_DESCRIPTION', 70, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_contact&view=contacts', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(71, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_DESCRIPTION', 71, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(72, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_DESCRIPTION', 72, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(73, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_DESCRIPTION', 73, 'bottom', '.col-lg-9', 0, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(74, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_DESCRIPTION', 74, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(75, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_DESCRIPTION', 75, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(76, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_DESCRIPTION', 76, 'bottom', '#jform_featured0', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(77, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_DESCRIPTION', 77, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(78, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_DESCRIPTION', 78, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(79, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_DESCRIPTION', 79, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(80, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_DESCRIPTION', 80, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(81, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_DESCRIPTION', 81, 'bottom', '', 0, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(82, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_DESCRIPTION', 82, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(83, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_DESCRIPTION', 83, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(84, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_DESCRIPTION', 84, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(85, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_DESCRIPTION', 85, 'bottom', '#jform_link', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(86, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_DESCRIPTION', 86, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(87, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_DESCRIPTION', 87, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(88, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_DESCRIPTION', 88, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(89, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_DESCRIPTION', 89, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(90, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_DESCRIPTION', 90, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(91, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_DESCRIPTION', 91, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(92, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_DESCRIPTION', 92, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(93, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_DESCRIPTION', 93, 'bottom', '', 0, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(94, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_DESCRIPTION', 94, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_finder&view=filters', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(95, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_DESCRIPTION', 95, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(96, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_DESCRIPTION', 96, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(97, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_DESCRIPTION', 97, 'bottom', '.col-lg-9', 0, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(98, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_DESCRIPTION', 98, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(99, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_DESCRIPTION', 99, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(100, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_DESCRIPTION', 100, 'bottom', '', 0, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(101, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_DESCRIPTION', 101, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(102, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_DESCRIPTION', 102, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(103, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_DESCRIPTION', 103, 'bottom', '#jform_username', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(104, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_DESCRIPTION', 104, 'bottom', '#jform_password', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(105, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_DESCRIPTION', 105, 'bottom', '#jform_password2', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(106, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_DESCRIPTION', 106, 'bottom', '#jform_email', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(107, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_DESCRIPTION', 107, 'top', '#jform_sendEmail0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(108, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_DESCRIPTION', 108, 'top', '#jform_block0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(109, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_DESCRIPTION', 109, 'top', '#jform_requireReset0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(110, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_DESCRIPTION', 110, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', ''),
(111, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_DESCRIPTION', 111, 'bottom', '', 0, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '');


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_categories`
--


DROP TABLE IF EXISTS `#__easystore_categories`;
CREATE TABLE `#__easystore_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `is_gift_card` tinyint NOT NULL DEFAULT '0',
  `is_uncategorised` tinyint NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`),
  KEY `idx_title_description` (`title`,`description`(100)),
  KEY `idx_publish_access` (`published`,`access`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_image` (`image`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_categories`
--


INSERT INTO `#__easystore_categories` (`id`, `title`, `alias`, `description`, `parent_id`, `is_gift_card`, `is_uncategorised`, `lft`, `rgt`, `level`, `image`, `path`, `published`, `access`, `ordering`, `language`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 'ROOT', 'root', NULL, 0, 0, 0, 0, 5, 0, NULL, '', 1, 0, 0, '*', NULL, NULL, '2023-09-26 04:48:59', NULL, '2023-09-26 04:48:59', NULL),
(20, 'Watches', 'watches', '', 1, 0, 0, 1, 2, 1, '', 'watches', 1, 1, 0, '*', NULL, NULL, '2023-10-19 07:07:12', 104, '2023-10-19 07:07:12', 104),
(21, 'Jewellery', 'jewellery', '', 1, 0, 0, 3, 4, 1, '', 'jewellery', 1, 1, 0, '*', NULL, NULL, '2023-10-19 07:14:41', 104, '2023-10-19 07:14:41', 104);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_tags`
--


DROP TABLE IF EXISTS `#__easystore_tags`;
CREATE TABLE `#__easystore_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title_description` (`title`,`description`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_products`
--


DROP TABLE IF EXISTS `#__easystore_products`;
CREATE TABLE `#__easystore_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `catid` bigint unsigned NOT NULL DEFAULT '0',
  `weight` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dimension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `regular_price` decimal(13,2) DEFAULT NULL,
  `has_sale` tinyint NOT NULL DEFAULT '0',
  `has_variants` tinyint NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_tracking_inventory` tinyint NOT NULL DEFAULT '0',
  `inventory_status` tinyint NOT NULL DEFAULT '0',
  `enable_out_of_stock_sell` tinyint NOT NULL DEFAULT '0',
  `quantity` int NOT NULL DEFAULT '0',
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `additional_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title_description` (`title`,`description`(100)),
  KEY `idx_published` (`published`),
  KEY `idx_has_sale` (`has_sale`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_products`
--


INSERT INTO `#__easystore_products` (`id`, `title`, `alias`, `description`, `catid`, `weight`, `dimension`, `regular_price`, `has_sale`, `has_variants`, `featured`, `is_tracking_inventory`, `inventory_status`, `enable_out_of_stock_sell`, `quantity`, `sku`, `additional_data`, `discount_type`, `discount_value`, `published`, `access`, `ordering`, `language`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 'Regal Rose Gold Watch', 'regal-rose-gold-watch', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '20.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:37:27', 104),
(29, 'Imperial Elegance Watch', 'imperial-elegance-watch', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '200.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:37:44', 104),
(30, 'Silia Earrings Gold', 'silia-earrings-gold', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '20.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:29:35', 104),
(31, 'Emperor\'s Moonphase Watch', 'emperors-moonphase-watch', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '450.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:28:03', 104),
(32, 'Magnificent Gemstone Ring', 'magnificent-gemstone-ring', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '5.96', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '1.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:34:25', 104),
(33, 'Platinum Navigator Watch', 'platinum-navigator-watch', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '500.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:35:51', 104),
(34, 'Nameplate Necklace', 'nameplate-necklace', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '12.00', 0, 0, 1, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 11:53:28', 104),
(35, 'Timex Weekender', 'timex-weekender', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '500.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:36:40', 104),
(36, 'Renaissance Cameo', 'renaissance-cameo', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '113.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:38:07', 104),
(37, 'Nubia Earrings Gold', 'nubia-earrings-gold', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '400.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:38:27', 104),
(38, 'NOMOS Glashütte - Tangente', 'nomos-glashuette-tangente', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '700.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:38:44', 104),
(39, 'Sovereign Cuff Bracelet', 'sovereign-cuff-bracelet', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '600.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:39:00', 104),
(40, 'Girard-Perregaux - Laureato', 'girard-perregaux-laureato', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '250.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:39:16', 104),
(41, 'Radiant Stud Earrings', 'radiant-stud-earrings', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '800.00', 1, 0, 1, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 11:53:23', 104),
(42, 'Tudor Black Bay', 'tudor-black-bay', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '250.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:36:56', 104),
(43, 'Chopard - Happy Diamonds', 'chopard-happy-diamonds', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '550.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:39:31', 104),
(44, 'Ornate Chandelier Earrings', 'ornate-chandelier-earrings', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '650.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:39:47', 104),
(45, 'Richard Mille - RM 011', 'richard-mille-rm-011', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '850.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:34:59', 104),
(46, 'Elara Ellipse Ring Gold', 'elara-ellipse-ring-gold', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '450.00', 0, 0, 1, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 11:53:25', 104),
(47, 'Junghans - Max Bill', 'junghans-max-bill', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '440.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:32:54', 104),
(48, 'Regal Radiance Earrings', 'regal-radiance-earrings', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 21, '', '', '220.00', 1, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:34:02', 104),
(49, 'Timeless Tourbillon Elegance', 'timeless-tourbillon-elegance', '<p>This beautiful Exquisit silver diamond is the perfect choice for your special someone. Crafted in either 18K gold or 18K white gold, the ring features a stunning oval diamond, expertly cut and set to sparkle and shine from all angles. Whether you are proposing, celebrating an anniversary or just wanting to show someone how much you care, this ring is an ideal choice. It will be treasured for a lifetime, and will always tell the story of your love stunning oval diamond</p>', 20, '', '', '540.00', 0, 0, 0, 0, 1, 0, 0, 'EASY-W-B', '[{\"title\":\"Outer shell\",\"values\":[{\"key\":\"97\",\"value\":\"polyester \"},{\"key\":\"3% \",\"value\":\"elastane\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"lining\",\"values\":[{\"key\":\"100%\",\"value\":\"polyester\"}],\"isCollapsed\":true,\"isLatest\":false},{\"title\":\"Caring\",\"values\":[{\"key\":\"\",\"value\":\"To keep your jackets and coats clean, you only need to freshen them up and go over them with a cloth or a clothes brush. This process is more gentle on fabrics and also reduces water and energy consumption when washing.  Machine wash at 30oC\\/86oF maximum with a brief spin cycle. Dry cleaning is not recommended. Tumble dry is not recommended.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '10.00', 1, 1, 0, '*', NULL, NULL, '2023-09-26 06:41:10', 104, '2023-10-20 09:37:14', 104);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_tag_map`
--


DROP TABLE IF EXISTS `#__easystore_product_tag_map`;
CREATE TABLE `#__easystore_product_tag_map` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  KEY `idx_product_tag` (`product_id`,`tag_id`),
  KEY `tag_id` (`tag_id`),
  CONSTRAINT `#__easystore_product_tag_map_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_tag_map_ibfk_2` FOREIGN KEY (`tag_id`) REFERENCES `#__easystore_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_media`
--


DROP TABLE IF EXISTS `#__easystore_media`;
CREATE TABLE `#__easystore_media` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `is_featured` tinyint DEFAULT '0',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `src` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_product_id` (`product_id`),
  CONSTRAINT `fk_product` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=383 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_media`
--


INSERT INTO `#__easystore_media` (`id`, `product_id`, `name`, `type`, `is_featured`, `width`, `height`, `src`, `alt_text`, `ordering`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(174, 1, 'jewels-tmpl-product-img-31.webp', 'image', 1, 638, 700, 'images/easystore/product-1/jewels-tmpl-product-img-31.webp', 'jewels-tmpl-product-img-31.webp', 1, '2023-10-20 06:40:04', 104, '2023-10-20 12:40:04', 104),
(175, 1, 'jewels-tmpl-product-img-0.webp', 'image', 0, 638, 700, 'images/easystore/product-1/jewels-tmpl-product-img-0.webp', 'jewels-tmpl-product-img-0.webp', 2, '2023-10-20 06:40:28', 104, '2023-10-20 12:40:28', 104),
(176, 1, 'jewels-tmpl-product-img-1.webp', 'image', 0, 638, 700, 'images/easystore/product-1/jewels-tmpl-product-img-1.webp', 'jewels-tmpl-product-img-1.webp', 3, '2023-10-20 06:40:28', 104, '2023-10-20 12:40:28', 104),
(177, 1, 'jewels-tmpl-product-img-2.webp', 'image', 0, 638, 700, 'images/easystore/product-1/jewels-tmpl-product-img-2.webp', 'jewels-tmpl-product-img-2.webp', 4, '2023-10-20 06:40:28', 104, '2023-10-20 12:40:28', 104),
(182, 29, 'jewels-tmpl-product-img-9.webp', 'image', 1, 638, 700, 'images/easystore/product-29/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 1, '2023-10-20 06:43:41', 104, '2023-10-20 12:43:41', 104),
(183, 29, 'jewels-tmpl-product-img-5.webp', 'image', 0, 638, 700, 'images/easystore/product-29/jewels-tmpl-product-img-5.webp', 'jewels-tmpl-product-img-5.webp', 2, '2023-10-20 06:43:53', 104, '2023-10-20 12:43:53', 104),
(184, 29, 'jewels-tmpl-product-img-6.webp', 'image', 0, 638, 700, 'images/easystore/product-29/jewels-tmpl-product-img-6.webp', 'jewels-tmpl-product-img-6.webp', 3, '2023-10-20 06:43:53', 104, '2023-10-20 12:43:53', 104),
(185, 29, 'jewels-tmpl-product-img-11.webp', 'image', 0, 638, 700, 'images/easystore/product-29/jewels-tmpl-product-img-11.webp', 'jewels-tmpl-product-img-11.webp', 4, '2023-10-20 06:43:59', 104, '2023-10-20 12:43:59', 104),
(186, 29, 'jewels-tmpl-product-img-12.webp', 'image', 0, 638, 700, 'images/easystore/product-29/jewels-tmpl-product-img-12.webp', 'jewels-tmpl-product-img-12.webp', 5, '2023-10-20 06:43:59', 104, '2023-10-20 12:43:59', 104),
(192, 30, 'jewels-tmpl-product-img-23.webp', 'image', 1, 638, 700, 'images/easystore/product-30/jewels-tmpl-product-img-23.webp', 'jewels-tmpl-product-img-23.webp', 1, '2023-10-20 06:47:08', 104, '2023-10-20 12:47:09', 104),
(193, 30, 'jewels-tmpl-product-img-14.webp', 'image', 0, 638, 700, 'images/easystore/product-30/jewels-tmpl-product-img-14.webp', 'jewels-tmpl-product-img-14.webp', 2, '2023-10-20 06:47:18', 104, '2023-10-20 12:47:18', 104),
(194, 30, 'jewels-tmpl-product-img-15.webp', 'image', 0, 638, 700, 'images/easystore/product-30/jewels-tmpl-product-img-15.webp', 'jewels-tmpl-product-img-15.webp', 3, '2023-10-20 06:47:18', 104, '2023-10-20 12:47:18', 104),
(195, 30, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-30/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 4, '2023-10-20 06:47:18', 104, '2023-10-20 12:47:18', 104),
(200, 31, 'jewels-tmpl-product-img-3.webp', 'image', 1, 638, 700, 'images/easystore/product-31/jewels-tmpl-product-img-3.webp', 'jewels-tmpl-product-img-3.webp', 1, '2023-10-20 06:49:40', 104, '2023-10-20 12:49:40', 104),
(201, 31, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-31/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 2, '2023-10-20 06:49:40', 104, '2023-10-20 12:49:40', 104),
(202, 31, 'jewels-tmpl-product-img-10.webp', 'image', 0, 638, 700, 'images/easystore/product-31/jewels-tmpl-product-img-10.webp', 'jewels-tmpl-product-img-10.webp', 3, '2023-10-20 06:49:40', 104, '2023-10-20 12:49:40', 104),
(203, 31, 'jewels-tmpl-product-img-11.webp', 'image', 0, 638, 700, 'images/easystore/product-31/jewels-tmpl-product-img-11.webp', 'jewels-tmpl-product-img-11.webp', 4, '2023-10-20 06:49:40', 104, '2023-10-20 12:49:40', 104),
(208, 32, 'jewels-tmpl-product-img-7.webp', 'image', 1, 638, 700, 'images/easystore/product-32/jewels-tmpl-product-img-7.webp', 'jewels-tmpl-product-img-7.webp', 1, '2023-10-20 06:51:59', 104, '2023-10-20 12:51:59', 104),
(209, 32, 'jewels-tmpl-product-img-8.webp', 'image', 0, 638, 700, 'images/easystore/product-32/jewels-tmpl-product-img-8.webp', 'jewels-tmpl-product-img-8.webp', 2, '2023-10-20 06:51:59', 104, '2023-10-20 12:51:59', 104),
(210, 32, 'jewels-tmpl-product-img-23.webp', 'image', 0, 638, 700, 'images/easystore/product-32/jewels-tmpl-product-img-23.webp', 'jewels-tmpl-product-img-23.webp', 3, '2023-10-20 06:51:59', 104, '2023-10-20 12:51:59', 104),
(211, 32, 'jewels-tmpl-product-img-24.webp', 'image', 0, 638, 700, 'images/easystore/product-32/jewels-tmpl-product-img-24.webp', 'jewels-tmpl-product-img-24.webp', 4, '2023-10-20 06:51:59', 104, '2023-10-20 12:51:59', 104),
(212, 32, 'jewels-tmpl-product-img-29.webp', 'image', 0, 638, 700, 'images/easystore/product-32/jewels-tmpl-product-img-29.webp', 'jewels-tmpl-product-img-29.webp', 5, '2023-10-20 06:51:59', 104, '2023-10-20 12:51:59', 104),
(218, 33, 'jewels-tmpl-product-img-20.webp', 'image', 1, 638, 700, 'images/easystore/product-33/jewels-tmpl-product-img-20.webp', 'jewels-tmpl-product-img-20.webp', 1, '2023-10-20 06:53:16', 104, '2023-10-20 12:53:16', 104),
(219, 33, 'jewels-tmpl-product-img-21.webp', 'image', 0, 638, 700, 'images/easystore/product-33/jewels-tmpl-product-img-21.webp', 'jewels-tmpl-product-img-21.webp', 2, '2023-10-20 06:53:16', 104, '2023-10-20 12:53:16', 104),
(220, 33, 'jewels-tmpl-product-img-22.webp', 'image', 0, 638, 700, 'images/easystore/product-33/jewels-tmpl-product-img-22.webp', 'jewels-tmpl-product-img-22.webp', 3, '2023-10-20 06:53:16', 104, '2023-10-20 12:53:16', 104),
(221, 33, 'jewels-tmpl-product-img-25.webp', 'image', 0, 638, 700, 'images/easystore/product-33/jewels-tmpl-product-img-25.webp', 'jewels-tmpl-product-img-25.webp', 4, '2023-10-20 06:53:16', 104, '2023-10-20 12:53:16', 104),
(222, 33, 'jewels-tmpl-product-img-26.webp', 'image', 0, 638, 700, 'images/easystore/product-33/jewels-tmpl-product-img-26.webp', 'jewels-tmpl-product-img-26.webp', 5, '2023-10-20 06:53:16', 104, '2023-10-20 12:53:16', 104),
(228, 34, 'jewels-tmpl-product-img-17.webp', 'image', 1, 638, 700, 'images/easystore/product-34/jewels-tmpl-product-img-17.webp', 'jewels-tmpl-product-img-17.webp', 1, '2023-10-20 06:54:46', 104, '2023-10-20 12:54:46', 104),
(229, 34, 'jewels-tmpl-product-img-18.webp', 'image', 0, 638, 700, 'images/easystore/product-34/jewels-tmpl-product-img-18.webp', 'jewels-tmpl-product-img-18.webp', 2, '2023-10-20 06:54:46', 104, '2023-10-20 12:54:46', 104),
(230, 34, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-34/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 3, '2023-10-20 06:54:46', 104, '2023-10-20 12:54:46', 104),
(231, 34, 'jewels-tmpl-product-img-15.webp', 'image', 0, 638, 700, 'images/easystore/product-34/jewels-tmpl-product-img-15.webp', 'jewels-tmpl-product-img-15.webp', 4, '2023-10-20 06:54:46', 104, '2023-10-20 12:54:46', 104),
(232, 34, 'jewels-tmpl-product-img-14.webp', 'image', 0, 638, 700, 'images/easystore/product-34/jewels-tmpl-product-img-14.webp', 'jewels-tmpl-product-img-14.webp', 5, '2023-10-20 06:54:46', 104, '2023-10-20 12:54:46', 104),
(238, 35, 'jewels-tmpl-product-img-27.webp', 'image', 1, 638, 700, 'images/easystore/product-35/jewels-tmpl-product-img-27.webp', 'jewels-tmpl-product-img-27.webp', 1, '2023-10-20 06:56:47', 104, '2023-10-20 12:56:47', 104),
(239, 35, 'jewels-tmpl-product-img-28.webp', 'image', 0, 638, 700, 'images/easystore/product-35/jewels-tmpl-product-img-28.webp', 'jewels-tmpl-product-img-28.webp', 2, '2023-10-20 06:56:47', 104, '2023-10-20 12:56:47', 104),
(240, 35, 'jewels-tmpl-product-img-26.webp', 'image', 0, 638, 700, 'images/easystore/product-35/jewels-tmpl-product-img-26.webp', 'jewels-tmpl-product-img-26.webp', 3, '2023-10-20 06:56:47', 104, '2023-10-20 12:56:47', 104),
(241, 35, 'jewels-tmpl-product-img-20.webp', 'image', 0, 638, 700, 'images/easystore/product-35/jewels-tmpl-product-img-20.webp', 'jewels-tmpl-product-img-20.webp', 4, '2023-10-20 06:56:47', 104, '2023-10-20 12:56:47', 104),
(242, 35, 'jewels-tmpl-product-img-22.webp', 'image', 0, 638, 700, 'images/easystore/product-35/jewels-tmpl-product-img-22.webp', 'jewels-tmpl-product-img-22.webp', 5, '2023-10-20 06:56:47', 104, '2023-10-20 12:56:47', 104),
(248, 36, 'jewels-tmpl-product-img-1.webp', 'image', 1, 638, 700, 'images/easystore/product-36/jewels-tmpl-product-img-1.webp', 'jewels-tmpl-product-img-1.webp', 1, '2023-10-20 06:59:45', 104, '2023-10-20 12:59:45', 104),
(249, 36, 'jewels-tmpl-product-img-2.webp', 'image', 0, 638, 700, 'images/easystore/product-36/jewels-tmpl-product-img-2.webp', 'jewels-tmpl-product-img-2.webp', 2, '2023-10-20 06:59:45', 104, '2023-10-20 12:59:45', 104),
(250, 36, 'jewels-tmpl-product-img-0.webp', 'image', 0, 638, 700, 'images/easystore/product-36/jewels-tmpl-product-img-0.webp', 'jewels-tmpl-product-img-0.webp', 3, '2023-10-20 06:59:45', 104, '2023-10-20 12:59:45', 104),
(251, 36, 'jewels-tmpl-product-img-7.webp', 'image', 0, 638, 700, 'images/easystore/product-36/jewels-tmpl-product-img-7.webp', 'jewels-tmpl-product-img-7.webp', 4, '2023-10-20 06:59:45', 104, '2023-10-20 12:59:45', 104),
(252, 36, 'jewels-tmpl-product-img-8.webp', 'image', 0, 638, 700, 'images/easystore/product-36/jewels-tmpl-product-img-8.webp', 'jewels-tmpl-product-img-8.webp', 5, '2023-10-20 06:59:45', 104, '2023-10-20 12:59:45', 104),
(263, 37, 'jewels-tmpl-product-img-30.webp', 'image', 1, 638, 700, 'images/easystore/product-37/jewels-tmpl-product-img-30.webp', 'jewels-tmpl-product-img-30.webp', 1, '2023-10-20 07:11:53', 104, '2023-10-20 13:11:53', 104),
(264, 37, 'jewels-tmpl-product-img-31.webp', 'image', 0, 638, 700, 'images/easystore/product-37/jewels-tmpl-product-img-31.webp', 'jewels-tmpl-product-img-31.webp', 2, '2023-10-20 07:11:53', 104, '2023-10-20 13:11:53', 104),
(265, 37, 'jewels-tmpl-product-img-29.webp', 'image', 0, 638, 700, 'images/easystore/product-37/jewels-tmpl-product-img-29.webp', 'jewels-tmpl-product-img-29.webp', 3, '2023-10-20 07:11:53', 104, '2023-10-20 13:11:53', 104),
(266, 37, 'jewels-tmpl-product-img-17.webp', 'image', 0, 638, 700, 'images/easystore/product-37/jewels-tmpl-product-img-17.webp', 'jewels-tmpl-product-img-17.webp', 4, '2023-10-20 07:11:53', 104, '2023-10-20 13:11:53', 104),
(267, 37, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-37/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 5, '2023-10-20 07:11:53', 104, '2023-10-20 13:11:53', 104),
(273, 38, 'jewels-tmpl-product-img-6.webp', 'image', 1, 638, 700, 'images/easystore/product-38/jewels-tmpl-product-img-6.webp', 'jewels-tmpl-product-img-6.webp', 1, '2023-10-20 07:13:15', 104, '2023-10-20 13:13:15', 104),
(274, 38, 'jewels-tmpl-product-img-5.webp', 'image', 0, 638, 700, 'images/easystore/product-38/jewels-tmpl-product-img-5.webp', 'jewels-tmpl-product-img-5.webp', 2, '2023-10-20 07:13:34', 104, '2023-10-20 13:13:34', 104),
(275, 38, 'jewels-tmpl-product-img-6.webp', 'image', 0, 638, 700, 'images/easystore/product-38/jewels-tmpl-product-img-6.webp', 'jewels-tmpl-product-img-6.webp', 3, '2023-10-20 07:13:34', 104, '2023-10-20 13:13:34', 104),
(276, 38, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-38/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 4, '2023-10-20 07:13:34', 104, '2023-10-20 13:13:34', 104),
(277, 38, 'jewels-tmpl-product-img-10.webp', 'image', 0, 638, 700, 'images/easystore/product-38/jewels-tmpl-product-img-10.webp', 'jewels-tmpl-product-img-10.webp', 5, '2023-10-20 07:13:34', 104, '2023-10-20 13:13:34', 104),
(283, 39, 'jewels-tmpl-product-img-14.webp', 'image', 1, 638, 700, 'images/easystore/product-39/jewels-tmpl-product-img-14.webp', 'jewels-tmpl-product-img-14.webp', 1, '2023-10-20 07:14:37', 104, '2023-10-20 13:14:37', 104),
(284, 39, 'jewels-tmpl-product-img-15.webp', 'image', 0, 638, 700, 'images/easystore/product-39/jewels-tmpl-product-img-15.webp', 'jewels-tmpl-product-img-15.webp', 2, '2023-10-20 07:14:37', 104, '2023-10-20 13:14:37', 104),
(285, 39, 'jewels-tmpl-product-img-17.webp', 'image', 0, 638, 700, 'images/easystore/product-39/jewels-tmpl-product-img-17.webp', 'jewels-tmpl-product-img-17.webp', 3, '2023-10-20 07:14:37', 104, '2023-10-20 13:14:37', 104),
(286, 39, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-39/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 4, '2023-10-20 07:14:37', 104, '2023-10-20 13:14:37', 104),
(287, 39, 'jewels-tmpl-product-img-18.webp', 'image', 0, 638, 700, 'images/easystore/product-39/jewels-tmpl-product-img-18.webp', 'jewels-tmpl-product-img-18.webp', 5, '2023-10-20 07:14:37', 104, '2023-10-20 13:14:37', 104),
(293, 40, 'jewels-tmpl-product-img-12.webp', 'image', 1, 638, 700, 'images/easystore/product-40/jewels-tmpl-product-img-12.webp', 'jewels-tmpl-product-img-12.webp', 1, '2023-10-20 07:16:37', 104, '2023-10-20 13:16:37', 104),
(294, 40, 'jewels-tmpl-product-img-10.webp', 'image', 0, 638, 700, 'images/easystore/product-40/jewels-tmpl-product-img-10.webp', 'jewels-tmpl-product-img-10.webp', 2, '2023-10-20 07:16:37', 104, '2023-10-20 13:16:37', 104),
(295, 40, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-40/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 3, '2023-10-20 07:16:37', 104, '2023-10-20 13:16:37', 104),
(296, 40, 'jewels-tmpl-product-img-11.webp', 'image', 0, 638, 700, 'images/easystore/product-40/jewels-tmpl-product-img-11.webp', 'jewels-tmpl-product-img-11.webp', 4, '2023-10-20 07:16:37', 104, '2023-10-20 13:16:37', 104),
(297, 40, 'jewels-tmpl-product-img-25.webp', 'image', 0, 638, 700, 'images/easystore/product-40/jewels-tmpl-product-img-25.webp', 'jewels-tmpl-product-img-25.webp', 5, '2023-10-20 07:16:37', 104, '2023-10-20 13:16:37', 104),
(303, 42, 'jewels-tmpl-product-img-12.webp', 'image', 1, 638, 700, 'images/easystore/product-42/jewels-tmpl-product-img-12.webp', 'jewels-tmpl-product-img-12.webp', 1, '2023-10-20 07:17:05', 104, '2023-10-20 13:17:05', 104),
(304, 42, 'jewels-tmpl-product-img-10.webp', 'image', 0, 638, 700, 'images/easystore/product-42/jewels-tmpl-product-img-10.webp', 'jewels-tmpl-product-img-10.webp', 2, '2023-10-20 07:17:05', 104, '2023-10-20 13:17:05', 104),
(305, 42, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-42/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 3, '2023-10-20 07:17:05', 104, '2023-10-20 13:17:05', 104),
(306, 42, 'jewels-tmpl-product-img-11.webp', 'image', 0, 638, 700, 'images/easystore/product-42/jewels-tmpl-product-img-11.webp', 'jewels-tmpl-product-img-11.webp', 4, '2023-10-20 07:17:05', 104, '2023-10-20 13:17:05', 104),
(307, 42, 'jewels-tmpl-product-img-25.webp', 'image', 0, 638, 700, 'images/easystore/product-42/jewels-tmpl-product-img-25.webp', 'jewels-tmpl-product-img-25.webp', 5, '2023-10-20 07:17:05', 104, '2023-10-20 13:17:05', 104),
(308, 41, 'jewels-tmpl-product-img-16.webp', 'image', 1, 638, 700, 'images/easystore/product-41/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 1, '2023-10-20 07:19:02', 104, '2023-10-20 13:19:02', 104),
(309, 41, 'jewels-tmpl-product-img-18.webp', 'image', 0, 638, 700, 'images/easystore/product-41/jewels-tmpl-product-img-18.webp', 'jewels-tmpl-product-img-18.webp', 2, '2023-10-20 07:19:02', 104, '2023-10-20 13:19:02', 104),
(310, 41, 'jewels-tmpl-product-img-7.webp', 'image', 0, 638, 700, 'images/easystore/product-41/jewels-tmpl-product-img-7.webp', 'jewels-tmpl-product-img-7.webp', 3, '2023-10-20 07:19:02', 104, '2023-10-20 13:19:02', 104),
(311, 41, 'jewels-tmpl-product-img-8.webp', 'image', 0, 638, 700, 'images/easystore/product-41/jewels-tmpl-product-img-8.webp', 'jewels-tmpl-product-img-8.webp', 4, '2023-10-20 07:19:02', 104, '2023-10-20 13:19:02', 104),
(312, 41, 'jewels-tmpl-product-img-23.webp', 'image', 0, 638, 700, 'images/easystore/product-41/jewels-tmpl-product-img-23.webp', 'jewels-tmpl-product-img-23.webp', 5, '2023-10-20 07:19:02', 104, '2023-10-20 13:19:02', 104),
(318, 43, 'jewels-tmpl-product-img-27.webp', 'image', 1, 638, 700, 'images/easystore/product-43/jewels-tmpl-product-img-27.webp', 'jewels-tmpl-product-img-27.webp', 1, '2023-10-20 07:21:44', 104, '2023-10-20 13:21:44', 104),
(319, 43, 'jewels-tmpl-product-img-28.webp', 'image', 0, 638, 700, 'images/easystore/product-43/jewels-tmpl-product-img-28.webp', 'jewels-tmpl-product-img-28.webp', 2, '2023-10-20 07:21:44', 104, '2023-10-20 13:21:44', 104),
(320, 43, 'jewels-tmpl-product-img-26.webp', 'image', 0, 638, 700, 'images/easystore/product-43/jewels-tmpl-product-img-26.webp', 'jewels-tmpl-product-img-26.webp', 3, '2023-10-20 07:21:44', 104, '2023-10-20 13:21:44', 104),
(321, 43, 'jewels-tmpl-product-img-5.webp', 'image', 0, 638, 700, 'images/easystore/product-43/jewels-tmpl-product-img-5.webp', 'jewels-tmpl-product-img-5.webp', 4, '2023-10-20 07:21:44', 104, '2023-10-20 13:21:44', 104),
(322, 43, 'jewels-tmpl-product-img-6.webp', 'image', 0, 638, 700, 'images/easystore/product-43/jewels-tmpl-product-img-6.webp', 'jewels-tmpl-product-img-6.webp', 5, '2023-10-20 07:21:44', 104, '2023-10-20 13:21:44', 104),
(328, 44, 'jewels-tmpl-product-img-0.webp', 'image', 1, 638, 700, 'images/easystore/product-44/jewels-tmpl-product-img-0.webp', 'jewels-tmpl-product-img-0.webp', 1, '2023-10-20 07:23:11', 104, '2023-10-20 13:23:11', 104),
(329, 44, 'jewels-tmpl-product-img-1.webp', 'image', 0, 638, 700, 'images/easystore/product-44/jewels-tmpl-product-img-1.webp', 'jewels-tmpl-product-img-1.webp', 2, '2023-10-20 07:23:11', 104, '2023-10-20 13:23:11', 104),
(330, 44, 'jewels-tmpl-product-img-2.webp', 'image', 0, 638, 700, 'images/easystore/product-44/jewels-tmpl-product-img-2.webp', 'jewels-tmpl-product-img-2.webp', 3, '2023-10-20 07:23:11', 104, '2023-10-20 13:23:11', 104),
(331, 44, 'jewels-tmpl-product-img-17.webp', 'image', 0, 638, 700, 'images/easystore/product-44/jewels-tmpl-product-img-17.webp', 'jewels-tmpl-product-img-17.webp', 4, '2023-10-20 07:23:11', 104, '2023-10-20 13:23:11', 104),
(332, 44, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-44/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 5, '2023-10-20 07:23:11', 104, '2023-10-20 13:23:11', 104),
(338, 45, 'jewels-tmpl-product-img-5.webp', 'image', 1, 638, 700, 'images/easystore/product-45/jewels-tmpl-product-img-5.webp', 'jewels-tmpl-product-img-5.webp', 1, '2023-10-20 07:27:17', 104, '2023-10-20 13:27:17', 104),
(339, 45, 'jewels-tmpl-product-img-6.webp', 'image', 0, 638, 700, 'images/easystore/product-45/jewels-tmpl-product-img-6.webp', 'jewels-tmpl-product-img-6.webp', 2, '2023-10-20 07:27:17', 104, '2023-10-20 13:27:17', 104),
(340, 45, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-45/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 3, '2023-10-20 07:27:17', 104, '2023-10-20 13:27:17', 104),
(341, 45, 'jewels-tmpl-product-img-10.webp', 'image', 0, 638, 700, 'images/easystore/product-45/jewels-tmpl-product-img-10.webp', 'jewels-tmpl-product-img-10.webp', 4, '2023-10-20 07:27:17', 104, '2023-10-20 13:27:17', 104),
(342, 45, 'jewels-tmpl-product-img-11.webp', 'image', 0, 638, 700, 'images/easystore/product-45/jewels-tmpl-product-img-11.webp', 'jewels-tmpl-product-img-11.webp', 5, '2023-10-20 07:27:17', 104, '2023-10-20 13:27:17', 104),
(348, 46, 'jewels-tmpl-product-img-15.webp', 'image', 1, 638, 700, 'images/easystore/product-46/jewels-tmpl-product-img-15.webp', 'jewels-tmpl-product-img-15.webp', 1, '2023-10-20 07:31:28', 104, '2023-10-20 13:31:28', 104),
(349, 46, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-46/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 2, '2023-10-20 07:31:28', 104, '2023-10-20 13:31:28', 104),
(350, 46, 'jewels-tmpl-product-img-17.webp', 'image', 0, 638, 700, 'images/easystore/product-46/jewels-tmpl-product-img-17.webp', 'jewels-tmpl-product-img-17.webp', 3, '2023-10-20 07:31:28', 104, '2023-10-20 13:31:28', 104),
(351, 46, 'jewels-tmpl-product-img-2.webp', 'image', 0, 638, 700, 'images/easystore/product-46/jewels-tmpl-product-img-2.webp', 'jewels-tmpl-product-img-2.webp', 4, '2023-10-20 07:31:28', 104, '2023-10-20 13:31:28', 104),
(352, 46, 'jewels-tmpl-product-img-0.webp', 'image', 0, 638, 700, 'images/easystore/product-46/jewels-tmpl-product-img-0.webp', 'jewels-tmpl-product-img-0.webp', 5, '2023-10-20 07:31:28', 104, '2023-10-20 13:31:28', 104),
(358, 47, 'jewels-tmpl-product-img-9.webp', 'image', 0, 638, 700, 'images/easystore/product-47/jewels-tmpl-product-img-9.webp', 'jewels-tmpl-product-img-9.webp', 2, '2023-10-20 07:38:00', 104, '2023-10-20 13:38:00', 104),
(359, 47, 'jewels-tmpl-product-img-28.webp', 'image', 1, 638, 700, 'images/easystore/product-47/jewels-tmpl-product-img-28.webp', 'jewels-tmpl-product-img-28.webp', 1, '2023-10-20 07:38:21', 104, '2023-10-20 13:38:21', 104),
(360, 47, 'jewels-tmpl-product-img-27.webp', 'image', 0, 638, 700, 'images/easystore/product-47/jewels-tmpl-product-img-27.webp', 'jewels-tmpl-product-img-27.webp', 3, '2023-10-20 07:38:21', 104, '2023-10-20 13:38:21', 104),
(361, 47, 'jewels-tmpl-product-img-26.webp', 'image', 0, 638, 700, 'images/easystore/product-47/jewels-tmpl-product-img-26.webp', 'jewels-tmpl-product-img-26.webp', 4, '2023-10-20 07:38:21', 104, '2023-10-20 13:38:21', 104),
(362, 47, 'jewels-tmpl-product-img-3.webp', 'image', 0, 638, 700, 'images/easystore/product-47/jewels-tmpl-product-img-3.webp', 'jewels-tmpl-product-img-3.webp', 5, '2023-10-20 07:38:21', 104, '2023-10-20 13:38:21', 104),
(368, 48, 'jewels-tmpl-product-img-13.webp', 'image', 1, 638, 700, 'images/easystore/product-48/jewels-tmpl-product-img-13.webp', 'jewels-tmpl-product-img-13.webp', 1, '2023-10-20 09:16:29', 104, '2023-10-20 15:16:29', 104),
(369, 48, 'jewels-tmpl-product-img-14.webp', 'image', 0, 638, 700, 'images/easystore/product-48/jewels-tmpl-product-img-14.webp', 'jewels-tmpl-product-img-14.webp', 2, '2023-10-20 09:16:29', 104, '2023-10-20 15:16:29', 104),
(370, 48, 'jewels-tmpl-product-img-1.webp', 'image', 0, 638, 700, 'images/easystore/product-48/jewels-tmpl-product-img-1.webp', 'jewels-tmpl-product-img-1.webp', 3, '2023-10-20 09:16:29', 104, '2023-10-20 15:16:29', 104),
(371, 48, 'jewels-tmpl-product-img-16.webp', 'image', 0, 638, 700, 'images/easystore/product-48/jewels-tmpl-product-img-16.webp', 'jewels-tmpl-product-img-16.webp', 4, '2023-10-20 09:16:29', 104, '2023-10-20 15:16:29', 104),
(372, 48, 'jewels-tmpl-product-img-7.webp', 'image', 0, 638, 700, 'images/easystore/product-48/jewels-tmpl-product-img-7.webp', 'jewels-tmpl-product-img-7.webp', 5, '2023-10-20 09:16:29', 104, '2023-10-20 15:16:29', 104),
(378, 49, 'jewels-tmpl-product-img-21.webp', 'image', 1, 638, 700, 'images/easystore/product-49/jewels-tmpl-product-img-21.webp', 'jewels-tmpl-product-img-21.webp', 1, '2023-10-20 09:18:01', 104, '2023-10-20 15:18:01', 104),
(379, 49, 'jewels-tmpl-product-img-28.webp', 'image', 0, 638, 700, 'images/easystore/product-49/jewels-tmpl-product-img-28.webp', 'jewels-tmpl-product-img-28.webp', 2, '2023-10-20 09:18:12', 104, '2023-10-20 15:18:12', 104),
(380, 49, 'jewels-tmpl-product-img-27.webp', 'image', 0, 638, 700, 'images/easystore/product-49/jewels-tmpl-product-img-27.webp', 'jewels-tmpl-product-img-27.webp', 3, '2023-10-20 09:18:12', 104, '2023-10-20 15:18:12', 104),
(381, 49, 'jewels-tmpl-product-img-26.webp', 'image', 0, 638, 700, 'images/easystore/product-49/jewels-tmpl-product-img-26.webp', 'jewels-tmpl-product-img-26.webp', 4, '2023-10-20 09:18:12', 104, '2023-10-20 15:18:12', 104),
(382, 49, 'jewels-tmpl-product-img-19.webp', 'image', 0, 638, 700, 'images/easystore/product-49/jewels-tmpl-product-img-19.webp', 'jewels-tmpl-product-img-19.webp', 5, '2023-10-20 09:18:12', 104, '2023-10-20 15:18:12', 104);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_temp_media`
--


DROP TABLE IF EXISTS `#__easystore_temp_media`;
CREATE TABLE `#__easystore_temp_media` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `is_featured` tinyint DEFAULT '0',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `src` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_is_featured` (`client_id`,`is_featured`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupons`
--


DROP TABLE IF EXISTS `#__easystore_coupons`;
CREATE TABLE `#__easystore_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) NOT NULL DEFAULT '0.00',
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `has_date` tinyint NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `idx_title` (`title`),
  KEY `idx_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_coupons`
--


INSERT INTO `#__easystore_coupons` (`id`, `title`, `alias`, `code`, `discount_type`, `discount_value`, `start_date`, `end_date`, `has_date`, `published`, `access`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 'Big Discount', 'big-discount', 'BIG2023', 'percent', '50.00', '2023-10-02 19:25:28', NULL, 0, 1, 1, NULL, NULL, '2023-10-02 13:25:40', 527, '2023-10-02 13:25:40', 527);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_wishlist`
--


DROP TABLE IF EXISTS `#__easystore_wishlist`;
CREATE TABLE `#__easystore_wishlist` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_product_wish` (`user_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_wishlist_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `#__users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_wishlist_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_reviews`
--


DROP TABLE IF EXISTS `#__easystore_reviews`;
CREATE TABLE `#__easystore_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `access` int unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_reviews_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_options`
--


DROP TABLE IF EXISTS `#__easystore_product_options`;
CREATE TABLE `#__easystore_product_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'color',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`name`),
  KEY `idx_product_id` (`product_id`),
  KEY `idx_name` (`name`),
  CONSTRAINT `#__easystore_product_options_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb3;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_option_values`
--


DROP TABLE IF EXISTS `#__easystore_product_option_values`;
CREATE TABLE `#__easystore_product_option_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `option_id` bigint unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `color` varchar(255) DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`option_id`,`name`),
  KEY `idx_product_id` (`product_id`),
  KEY `idx_name` (`name`),
  KEY `option_id` (`option_id`),
  CONSTRAINT `#__easystore_product_option_values_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_option_values_ibfk_2` FOREIGN KEY (`option_id`) REFERENCES `#__easystore_product_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=195 DEFAULT CHARSET=utf8mb3;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_skus`
--


DROP TABLE IF EXISTS `#__easystore_product_skus`;
CREATE TABLE `#__easystore_product_skus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `image_id` bigint unsigned DEFAULT NULL,
  `combination_name` varchar(500) NOT NULL,
  `combination_value` varchar(500) NOT NULL,
  `price` decimal(13,2) DEFAULT NULL,
  `inventory_status` tinyint NOT NULL DEFAULT '0',
  `inventory_amount` int DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `sku` varchar(100) NOT NULL DEFAULT '',
  `weight` varchar(100) NOT NULL DEFAULT '',
  `visibility` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`combination_value`),
  KEY `price` (`price`),
  CONSTRAINT `#__easystore_product_skus_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=456 DEFAULT CHARSET=utf8mb3;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupon_product_sku_map`
--


DROP TABLE IF EXISTS `#__easystore_coupon_product_sku_map`;
CREATE TABLE `#__easystore_coupon_product_sku_map` (
  `coupon_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `sku_id` bigint unsigned NOT NULL,
  KEY `idx_coupon_product_sku` (`coupon_id`,`product_id`,`sku_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_orders`
--


DROP TABLE IF EXISTS `#__easystore_orders`;
CREATE TABLE `#__easystore_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `creation_date` datetime DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `customer_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `billing_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unpaid',
  `fulfilment` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unfulfilled',
  `order_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'draft',
  `is_guest_order` tinyint NOT NULL DEFAULT '0',
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `discount_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_error_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tracking_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_carrier` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `coupon_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_amount` decimal(13,2) DEFAULT '0.00',
  `sale_tax` decimal(13,2) DEFAULT '0.00',
  `shipping_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_value` decimal(13,2) DEFAULT '0.00',
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_send_shipping_confirmation_email` tinyint NOT NULL DEFAULT '1',
  `published` tinyint NOT NULL DEFAULT '1',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_payment_status` (`payment_status`),
  KEY `idx_order_fulfillment` (`fulfilment`),
  KEY `idx_order_order_status` (`order_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_product_map`
--


DROP TABLE IF EXISTS `#__easystore_order_product_map`;
CREATE TABLE `#__easystore_order_product_map` (
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variant_id` bigint unsigned DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `discount_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `price` decimal(13,2) NOT NULL DEFAULT '0.00',
  KEY `idx_order_product_variant` (`order_id`,`product_id`,`variant_id`),
  CONSTRAINT `#__easystore_order_product_map_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_activities`
--


DROP TABLE IF EXISTS `#__easystore_order_activities`;
CREATE TABLE `#__easystore_order_activities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `activity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'order_created',
  `activity_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `#__easystore_order_activities_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_refunds`
--


DROP TABLE IF EXISTS `#__easystore_order_refunds`;
CREATE TABLE `#__easystore_order_refunds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `refund_value` decimal(13,2) NOT NULL,
  `refund_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `#__easystore_order_refunds_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_users`
--


DROP TABLE IF EXISTS `#__easystore_users`;
CREATE TABLE `#__easystore_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `user_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'customer',
  `phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_billing_and_shipping_address_same` tinyint NOT NULL DEFAULT '0',
  `billing_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_phone` (`phone`),
  CONSTRAINT `#__easystore_users_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `#__users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_cart`
--


DROP TABLE IF EXISTS `#__easystore_cart`;
CREATE TABLE `#__easystore_cart` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Possible values (cart, information, shipping, payment)',
  `token` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_method` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_amount` decimal(13,2) NOT NULL DEFAULT '0.00',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_cart`
--


INSERT INTO `#__easystore_cart` (`id`, `customer_id`, `status`, `token`, `shipping_method`, `payment_method`, `coupon_code`, `coupon_type`, `coupon_amount`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(16, 1, NULL, '0ecd3b9c-a5b6-4435-bde0-75068ea143b3', NULL, NULL, NULL, NULL, '0.00', '2023-10-04 13:32:29', 527, '2023-10-04 19:32:29', NULL),
(17, 1, NULL, 'e3f6c2ce-0425-46c7-88af-93eb9470c976', NULL, NULL, NULL, NULL, '0.00', '2023-10-04 13:32:29', 527, '2023-10-04 19:32:29', NULL),
(19, NULL, NULL, '64e9afad-83cf-411a-8f88-2c06d9d5c6ec', NULL, NULL, NULL, NULL, '0.00', '2023-10-04 16:38:09', 0, '2023-10-04 22:38:09', NULL),
(20, NULL, NULL, '4ef10238-5d69-4f7e-bdc5-ecb11bb1b579', NULL, NULL, NULL, NULL, '0.00', '2023-10-20 09:38:22', 0, '2023-10-20 15:38:22', NULL),
(21, NULL, NULL, 'f6250c38-0229-4007-9a9b-f11e607b6ad1', NULL, NULL, NULL, NULL, '0.00', '2023-10-20 12:39:13', 0, '2023-10-20 18:39:13', NULL),
(22, NULL, NULL, '45cce715-471a-4dbf-b965-be2a7ac09530', NULL, NULL, NULL, NULL, '0.00', '2023-10-20 13:22:08', 0, '2023-10-20 19:22:08', NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_cart_items`
--


DROP TABLE IF EXISTS `#__easystore_cart_items`;
CREATE TABLE `#__easystore_cart_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `sku_id` bigint unsigned DEFAULT NULL,
  `quantity` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_id` (`cart_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_cart_items_ibfk_1` FOREIGN KEY (`cart_id`) REFERENCES `#__easystore_cart` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_cart_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_settings`
--


DROP TABLE IF EXISTS `#__easystore_settings`;
CREATE TABLE `#__easystore_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_settings`
--


INSERT INTO `#__easystore_settings` (`id`, `key`, `value`) VALUES 
(1, 'email_templates', '{\"order\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_ORDER\",\"templates\":[{\"type\":\"order_confirmation\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_SUBTITLE\",\"subject\":\"Your Order Confirmation - Order #{order_id}\",\"body\":\"<p>Dear Customer,<\\/p><p>We\'ve received your <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> and are thrilled to confirm your recent purchase with us! Your order details are as follows:<\\/p><p><strong>Order ID:<\\/strong> {order_id}<br><strong>Order Date:<\\/strong> {order_date}<\\/p><p><strong>Shipping Address:<\\/strong><br>{shipping_address}<\\/p><p><strong>Order Summary:<\\/strong><br>{order_summary}<\\/p><p>Please take a moment to review your order details to ensure that everything is accurate. If you have any questions or need assistance, please do not hesitate to reach out to our customer support team at  <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}.<\\/p><p>Thank you for choosing {store_name}. <br><br>{store_name}<br>{store_phone}<br>{store_email}<br>{store_address}<br><\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Payment Status\",\"code\":\"{payment_status}\"},{\"title\":\"Payment Method\",\"code\":\"{payment_method}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Order Summary\",\"code\":\"{order_summary}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]},{\"type\":\"order_refund\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_REFUND_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_REFUND_SUBTITLE\",\"subject\":\"Refund Confirmation - Order #{order_id}\",\"body\":\"<p>Dear Customer,<\\/p><p>We are pleased to confirm that your refund request for Order #{order_id} has been processed. Below are the details of your refund:<\\/p><p><strong>Order ID:<\\/strong> {order_id}<br><strong>Order Date:<\\/strong> {order_date}<\\/p><p><\\/p><p><strong>Refund Amount:<\\/strong> {refund_amount}<br><\\/p><p>Please allow a few business days for the refund to reflect in your account, depending on your bank or payment provider. If you have any questions or concerns regarding your refund, please do not hesitate to reach out to our customer support team at {store_email} or call us at {store_phone}. We are here to assist you with any further inquiries.<br><\\/p><p>Thank you for choosing {store_name}.<\\/p><p><br>{store_address}<\\/p><p><\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Order Id\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Refund Amount\",\"code\":\"{refund_amount}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]}]},\"payment\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_PAYMENT\",\"templates\":[{\"type\":\"payment_success\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_SUBTITLE\",\"subject\":\"Payment Successful for Your Recent Order\",\"body\":\"<p>Dear Customer,<\\/p><p>We are excited to inform you that your recent payment has been successfully processed. Your <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> is now confirmed, and we are preparing it for shipment. Below are the details of your purchase:<\\/p><p><b>Order ID:<\\/b> {order_id}<br><b>Order Date:<\\/b> {order_date}<\\/p><p><b>Shipping Address:<\\/b><br>{shipping_address}<\\/p><p><b>Order Summary:<\\/b><br>{order_summary}<p><p>Please allow us some time to prepare your order for shipment. You will receive a shipping confirmation email with tracking information once your order is on its way.<\\/p><p>If you have any questions or require assistance with your order, please do not hesitate to reach out to our customer support team at  <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}.<\\/p><p>Thank you for choosing {store_name}. <br><br>{store_name}<br>{store_phone}<br>{store_email}<br>{store_address}<br><\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Order Summary\",\"code\":\"{order_summary}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]},{\"type\":\"payment_error\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_ERROR_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_ERROR_SUBTITLE\",\"subject\":\"Payment Error for Order #{order_id}\",\"body\":\"<p>Dear Customer,<\\/p><p>We regret to inform you that there was an issue with the payment for your recent <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> with us. Unfortunately, we were unable to process your payment successfully. The details of your order are as follows:<\\/p><p><b>Order ID:<\\/b> {order_id}<br><b>Order Date:<\\/b> {order_date}<\\/p><p>If you believe this is an error, we recommend the following steps:<ol><li>Double-check your payment information for accuracy, including the card number, expiration date, and CVV code.<\\/li><li>Ensure that the billing address provided matches the one associated with your payment method.<\\/li><li>If you are using a credit or debit card, confirm that your card is valid and has available credit.<\\/li><li>If you continue to experience issues, we recommend trying an alternative payment method, such as a different card or payment option.<\\/li><\\/ol><p>If you still encounter difficulties or have questions about this payment error, please do not hesitate to reach out to our customer support team at  <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}. We are here to assist you in resolving this issue and completing your order.<\\/p><p>We apologize for any inconvenience this may have caused and appreciate your patience and understanding.<\\/p><p>Thank you for considering {store_name}. We value your business and hope to provide you with a seamless shopping experience.<\\/p><p>Sincerely,<\\/p><p>{store_name}<br>{store_address}<br>{store_email}<br>{store_phone}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]}]},\"shipping\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_SHIPPING\",\"templates\":[{\"type\":\"add_tracking\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_TRACKING_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_TRACKING_SUBTITLE\",\"subject\":\"Shipping Carrier Added - Order #{order_id}\",\"body\":\"<p>Dear Customer,<br><\\/p><p>We are excited to inform you that a shipping carrier has been added to your order. <br>Here are the details:<\\/p><ul><li><p><strong>Order Number:<\\/strong> {order_id}<\\/p><\\/li><li><p><strong>Shipping Carrier: <\\/strong>{shipping_carrier}<\\/p><\\/li><\\/ul><p>You can track your order\'s status by clicking the following link:<\\/p><p><strong>Track Your Order:<\\/strong> <a target=\\\"_blank\\\" rel=\\\"noreferrer noopener\\\" href=\\\"{tracking_url}\\\">{tracking_url}<\\/a><br><\\/p><p>If you have any questions or need assistance, please feel free to contact our customer support team at <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Order Number\",\"code\":\"{order_id}\"},{\"title\":\"Shipping Carrier\",\"code\":\"{shipping_carrier}\"},{\"title\":\"Tracking Url\",\"code\":\"{tracking_url}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"}]}]},\"customer\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_CUSTOMER\",\"templates\":[{\"type\":\"new_account\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_NEW_ACCOUNT_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_NEW_ACCOUNT_SUBTITLE\",\"subject\":\"Welcome to {store_name} - Your New Account\",\"body\":\"<p>Dear {customer_name},<\\/p><p>We are excited to welcome you to {store_name}! Thank you for creating your account with us. Your journey with us has just begun, and we can\'t wait to provide you with a seamless and enjoyable experience.<\\/p><p>Here are a few things you can do with your {store_name} account:<\\/p><ol><li><p><strong>Explore Our Products:<\\/strong> Browse our wide range of high-quality products and discover the perfect items for your needs.<\\/p><\\/li><li><p><strong>Save Your Favorites:<\\/strong> Save your favorite products to your wishlist for easy access later.<\\/p><\\/li><li><p><strong>Streamlined Checkout:<\\/strong> Enjoy a faster and more convenient checkout process when you make a purchase.<\\/p><\\/li><li><p><strong>Order Tracking:<\\/strong> Keep an eye on the progress of your orders and access tracking information easily.<\\/p><\\/li><li><p><strong>Exclusive Offers:<\\/strong> As a valued member, you\'ll receive exclusive promotions, discounts, and updates.<\\/p><\\/li><\\/ol><p>To get started, simply log in to your account <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{account_login_link}\\\">Password Reset Link<\\/a> and start exploring the exciting features we have to offer.<\\/p><p>Thank you for choosing {store_name}. We value your trust and look forward to serving you. Welcome aboard!<\\/p><p><\\/p><p>{store_name}<br>{store_phone}<br>{store_address}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Account Login Link\",\"code\":\"{account_login_link}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"}]}]}}');


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_guests`
--


DROP TABLE IF EXISTS `#__easystore_guests`;
CREATE TABLE `#__easystore_guests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder`
--


DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `content` mediumtext,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '1',
  `catid` int NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `created_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` bigint NOT NULL DEFAULT '0',
  `checked_out` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  `version` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb3;


--
-- Dumping data for table `#__sppagebuilder`
--


INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `content`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`, `version`) VALUES 
(9, 98, 'Home - Default', '[{\"id\":1629272628186,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"60px 0px 0px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"gradient\",\"background_gradient\":{\"color\":\"#E1E8FD\",\"color2\":\"rgba(241, 216, 180, 0.47)\",\"deg\":\"165\",\"type\":\"linear\",\"pos\":\"0\",\"pos2\":\"128\"},\"background_image\":{\"src\":\"images/2021/08/18/hero-bg.jpg\",\"height\":1920,\"width\":3840},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628186,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\",\"background_video\":0},\"layout\":\"6,6\",\"columns\":[{\"id\":1629272628185,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628185},\"addons\":[{\"id\":1629274448274,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Helix Framework\",\"heading_selector\":\"h1\",\"title_fontsize\":{\"md\":\"100\",\"sm\":\"68\",\"xs\":\"35\"},\"title_lineheight\":{\"md\":\"120\",\"sm\":\"78\",\"xs\":\"45\"},\"title_letterspace\":\"0\",\"text\":\"Helix Ultimate framework packed with tons of exciting features that increase Joomla website development dramatically.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"27\",\"sm\":\"26\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px -8% 48px 0px\",\"sm\":\"0px -10% 30px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629274448274,\"title_text_color\":\"#000000\",\"title_font_style\":{\"weight\":700},\"font_family\":\"IBM Plex Sans\",\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"44\",\"sm\":\"25\",\"xs\":\"12\"},\"global_use_background\":0,\"global_text_color\":\"\"}},{\"id\":1629296134324,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":1,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296134324},\"layout\":\"4,5\",\"visibility\":true,\"columns\":[{\"id\":1629296134325,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-5\",\"xs_col\":\"col-xs-5\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629296134374,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Download\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"hover\",\"background_color\":\"#000000\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#ffffff\",\"background_color_hover\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#000000\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 16px 0px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296134374,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500},\"global_use_background\":0}}]},{\"id\":1629296134328,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-6\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134},\"addons\":[{\"id\":1629283736987,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"normal\",\"background_color\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#000000\",\"background_color_hover\":\"#000000\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 16px 0px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629283736987,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500},\"global_use_background\":0}}]}]}]},{\"id\":1629272628195,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628195},\"addons\":[{\"id\":1629274504575,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/hero-img.png\",\"height\":913,\"width\":1227},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px -95% 0px -17%\",\"sm\":\"0px -240px 0px -8%\",\"xs\":\"0px -120px 0px 15px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (max-width:1200px) and (min-width:992px) {\\n  #addonWrapper {\\n  \\tmargin-left: -8%;\\n  \\tmargin-right: -30%;\\n  }\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629274504575,\"global_section_z_index\":\"2\",\"global_use_background\":0}}]}]},{\"id\":1629272628193,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"130px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"60px 0px 0px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628193,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\",\"container_width\":\"1018\",\"columns_gap\":{\"md\":\"54\",\"sm\":\"50\",\"xs\":\"30\",\"unit\":\"px\"}},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1629272628194,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628194},\"addons\":[{\"id\":1629272630711,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Passion\",\"heading_selector\":\"h5\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"20\",\"xs\":\"18\"},\"title_lineheight\":{\"md\":\"32\",\"sm\":\"30\",\"xs\":\"28\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18//icon-passion.svg\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Free standard shipping on all domestic orders.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 40px 30px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629272630711,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 14px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"4\"}}}]},{\"id\":1629272628242,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628242},\"addons\":[{\"id\":1629272629807,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Purpose\",\"heading_selector\":\"h5\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"20\",\"xs\":\"18\"},\"title_lineheight\":{\"md\":\"32\",\"sm\":\"30\",\"xs\":\"28\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-purpose.svg\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Free standard shipping on all domestic orders.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 20px 30px 20px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629272629807,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 14px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"4\"}}}]},{\"id\":1629272628302,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628302},\"addons\":[{\"id\":1629274810488,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Team\",\"heading_selector\":\"h5\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"22\",\"sm\":\"20\",\"xs\":\"18\"},\"title_lineheight\":{\"md\":\"32\",\"sm\":\"30\",\"xs\":\"28\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-team.svg\"},\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Free standard shipping on all domestic orders.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 40px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629274810488,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 14px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"4\"}}}]}]},{\"id\":1629272628191,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"60px 0px 285px 0px\",\"sm\":\"70px 0px 220px 0px\",\"xs\":\"20px 0px 150px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628191,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\",\"background_video\":0},\"layout\":\"12\",\"columns\":[{\"id\":1629272628192,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"gradient\",\"background_gradient\":{\"color\":\" #E1E8FD\",\"color2\":\"rgba(241, 216, 180, 0.47)\",\"deg\":\"165\",\"type\":\"linear\",\"pos2\":\"128\"},\"background_image\":{\"src\":\"images/2021/08/18/bg-pattern.jpg\",\"height\":910,\"width\":2220},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628192,\"padding\":{\"md\":\"102px 98px 0px 98px\",\"sm\":\"100px 50px 0px 50px\",\"xs\":\"40px 25px 0px 25px\"},\"margin\":{\"md\":\"0px 0px 215px 0px\",\"sm\":\"0px 0px 150px 0px\",\"xs\":\"0px 0px 120px 0px\"}},\"addons\":[{\"id\":1629296134175,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Enjoy the mood\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"Village did removed enjoyed explain nor ham saw calling talking. Securing as informed declared or margaret. Joy horrible moreover man feelings own shy. Request norland neither mistake for yet. Between the for morning assured country believe.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px auto 45px auto\",\"sm\":\"0px auto 30px auto\",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296134175,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"80\",\"sm\":\"92\",\"xs\":\"100\"},\"global_use_background\":0}},{\"id\":1629298069550,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fas fa-play\",\"link\":\"https://www.youtube.com/watch?v=LPaRXxmrTxU\",\"size\":{\"md\":\"18\",\"xs\":\"16\"},\"width\":{\"md\":\"64\",\"xs\":\"50\"},\"height\":{\"md\":\"64\",\"xs\":\"50\"},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-right\",\"class\":\"\",\"instFormId\":1629298069550,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#ffffff\",\"background\":\"rgba(0, 0, 0, 0.3)\",\"border_radius\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":1,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px auto -215px auto\",\"sm\":\"0px auto -150px auto\",\"xs\":\"0px 0px -120px 0px\"},\"global_padding\":{\"md\":\"300px 18px 18px 18px\",\"sm\":\"220px 18px 18px 18px\",\"xs\":\"160px 15px 15px 15px\"},\"global_use_animation\":0,\"global_background_image\":{\"src\":\"images/2021/08/18/vedio-thumb-home.jpg\",\"height\":764,\"width\":1460},\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_border_radius\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"global_width\":{\"md\":\"80\",\"sm\":\"90\",\"xs\":\"100\"}}}]}]},{\"id\":1629272628189,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"70px 0px 35px 0px\",\"sm\":\"   \",\"xs\":\"10px 0px 0px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628189,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1629272628190,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628190},\"addons\":[{\"id\":1629281455328,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Born from creativity, <br>Shaped our values.\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629281455328,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"},\"global_use_background\":0}},{\"id\":1629296135240,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"Helix Ultimate is a 100% responsive mobile first Joomla template frontend visual layout builder and options framework.\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 48px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296135240,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"}}},{\"id\":1629296134322,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"normal\",\"background_color\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#000000\",\"background_color_hover\":\"#000000\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296134322,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500}}}]},{\"id\":1629272630702,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272630702,\"padding\":{\"md\":\"10px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629272629804,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Trust leads to trust\",\"heading_selector\":\"h6\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"25\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-creativity1.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Helix Ultimate framework packed with tons of exciting features that increase Joomla website development.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 33px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-media-body {\\n\\tborder-bottom: 1px solid rgba(48, 47, 64, 0.16);\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629272629804,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"0px 0px 32px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 20px 0px\"},\"feature_image_margin\":{\"md\":\"2px 32px 0px 0px\",\"sm\":\"0px 25px 0px 0px\",\"xs\":\"0px 15px 0px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"}}},{\"id\":1629284567491,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Impact is everything\",\"heading_selector\":\"h6\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"25\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-creativity2.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Helix Ultimate framework packed with tons of exciting features that increase Joomla website development.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 33px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-media-body {\\n\\tborder-bottom: 1px solid rgba(48, 47, 64, 0.16);\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629284567491,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"0px 0px 32px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 20px 0px\"},\"feature_image_margin\":{\"md\":\"2px 32px 0px 0px\",\"sm\":\"0px 25px 0px 0px\",\"xs\":\"0px 15px 0px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"}}},{\"id\":1629284567488,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"One team, one goal\",\"heading_selector\":\"h6\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"25\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-creativity3.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Helix Ultimate framework packed with tons of exciting features that increase Joomla website development.\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 33px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629284567488,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"2px 32px 0px 0px\",\"sm\":\"0px 25px 0px 0px\",\"xs\":\"0px 15px 0px 0px\"},\"title_font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"}}}]}]},{\"id\":1629296135389,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"60px 15px 70px 15px\",\"sm\":\"   \",\"xs\":\"20px 15px 30px 15px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629272628187,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\",\"background_video\":0},\"layout\":\"12\",\"columns\":[{\"id\":1629296135390,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1629296135391,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\",\"md\":\"1480\",\"sm\":\"690\",\"xs\":\"510\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"102px 17% 125px 17%\",\"sm\":\"80px 60px 80px 60px\",\"xs\":\"40px 25px 40px 25px\"},\"margin\":{\"md\":\"0px -17% 0px -17%\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":{\"md\":\"32\",\"sm\":\"\",\"xs\":\"\"},\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296135391,\"background_color\":\"#F4F6FB\",\"background_video\":0},\"layout\":\"7,5,7,2,3\",\"visibility\":true,\"columns\":[{\"id\":1629296135392,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567536},\"addons\":[{\"id\":1629296135393,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/simple-img1.png\",\"height\":442,\"width\":602},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px -35px auto\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"0px 33px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (min-width:992px) {\\n\\t#addonWrapper {\\n\\t\\tmax-width: 635px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296135393,\"global_use_background\":0}}]},{\"id\":1629296135394,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567593},\"addons\":[{\"id\":1629296135395,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Supreme style for your business\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"Helix Ultimate is a 100% responsive mobile first Joomla template frontend visual layout builder and options framework.\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 46px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (min-width:992px) {\\n\\t#addonWrapper {\\n\\t\\t\\tmax-width: 445px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296135395,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"},\"global_use_background\":0}},{\"id\":1629296135396,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_vertical\":0,\"divider_height_vertical\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"divider_position\":\"\",\"container_div_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"rgba(48, 47, 64, 0.1)\",\"margin_top\":{\"md\":\"10\",\"sm\":\"10\",\"xs\":10},\"margin_bottom\":{\"md\":\"10\",\"sm\":\"10\",\"xs\":10},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 8px 0px\",\"sm\":\"0px 0px 5px 0px\",\"xs\":\"0px 0px 2px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (min-width:992px) {\\n\\t#addonWrapper {\\n\\t\\t\\tmax-width: 445px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629285669127}}]},{\"id\":1629296135423,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134},\"addons\":[]},{\"id\":1629296135424,\"class_name\":\"col-md-2\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-6\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629296135405,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"56%\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"30\",\"sm\":\"22\",\"xs\":\"20\"},\"title_lineheight\":{\"md\":\"36\",\"sm\":\"32\",\"xs\":\"30\"},\"title_letterspace\":\"\",\"text\":\"Increase in performance\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"-44px -40px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (min-width:992px) {\\n\\t#addonWrapper {\\n\\t\\t\\tmax-width: 445px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296135405,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"},\"global_use_background\":0}}]},{\"id\":1629296135425,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-6\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629296135605,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"99%\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"30\",\"sm\":\"22\",\"xs\":\"20\"},\"title_lineheight\":{\"md\":\"36\",\"sm\":\"32\",\"xs\":\"30\"},\"title_letterspace\":\"\",\"text\":\"Increase in performance\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"-44px 0px 0px 50px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (min-width:992px) {\\n\\t#addonWrapper {\\n\\t\\t\\tmax-width: 445px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296135605,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"},\"global_use_background\":0}}]}]}]}]},{\"id\":1629284567529,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"52px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"10px 0px 10px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567529,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1629284567530,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-3\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567530,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629301450043,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/client1.png\",\"height\":84,\"width\":160},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"#\",\"class\":\"\",\"instFormId\":1629301450043,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1629296136005,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-3\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296136005,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629301450046,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/client2.png\"},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"#\",\"class\":\"\",\"instFormId\":1629301450046,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1629296136006,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-3\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296136006,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629301450049,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/client3.png\"},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"#\",\"class\":\"\",\"instFormId\":1629301450049,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1629296136007,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-3\",\"xs_col\":\"col-xs-3\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296136007,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629301221769,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"images/2021/08/18/client4.png\"},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"#\",\"class\":\"\",\"instFormId\":1629301221769,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1629284567527,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"55px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 30px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567527,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1629284567528,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567528},\"addons\":[{\"id\":1629286994940,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Supreme style for your business connect from anywhere\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286994940,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"},\"global_use_background\":0}}]},{\"id\":1629286995079,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286995079},\"addons\":[{\"id\":1629301538120,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"Village did removed enjoyed explain nor ham saw calling talking. Securing as informed declared or margaret. Joy horrible moreover man feelings own shy. Request norland neither mistake for yet. Between the for morning assured country believe.\",\"alignment\":\"sppb-text-left\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"10px 0px 40px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629301538120,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"17\",\"sm\":\"\",\"xs\":\"10\"},\"global_width\":{\"md\":\"65\",\"sm\":\"90\",\"xs\":\"90\"}}},{\"id\":1629286994941,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"normal\",\"background_color\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#000000\",\"background_color_hover\":\"#000000\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286994941,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500}}}]}]},{\"id\":1629284567525,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"0px 0px 70px 0px\",\"sm\":\"0px 0px 40px 0px\",\"xs\":\"20px 0px 10px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567525,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1629284567526,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629284567526},\"addons\":[{\"id\":1629286995810,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"We are goal driven\",\"heading_selector\":\"h6\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-supreme-style1.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":{\"md\":\"200\",\"sm\":\"160\",\"xs\":\"140\"},\"text_fontweight\":\"\",\"text_lineheight\":{\"md\":\"130\",\"sm\":\"100\",\"xs\":\"90\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"gradient\",\"global_background_gradient\":{\"color\":\"rgba(225, 232, 253, 0.3)\",\"color2\":\"rgba(241, 216, 180, 0.3)\",\"deg\":\"160\",\"type\":\"linear\",\"pos2\":\"128\"},\"global_background_image\":{\"src\":\"images/2021/08/18/bg-pattern2.jpg\",\"height\":412,\"width\":510},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"35px 73px 45px 32px\",\"sm\":\"28px 50px 35px 28px\",\"xs\":\"25px 25px 30px 25px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId {\\n  position: relative;\\n\\toverflow: hidden;\\n}\\n#addonId .sppb-addon-text strong {\\n\\tposition: absolute;\\n  right: -4px;\\n  bottom: 0px;\\n  font-weight: 800;\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286995810,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 24px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"Noto Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"},\"global_text_color\":\"rgba(0, 0, 0, 0.03)\",\"global_use_background\":1}}]},{\"id\":1629286995149,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286995149},\"addons\":[{\"id\":1629286995521,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Autonomy to succeed\",\"heading_selector\":\"h6\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-supreme-style2.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":{\"md\":\"200\",\"sm\":\"160\",\"xs\":\"140\"},\"text_fontweight\":\"\",\"text_lineheight\":{\"md\":\"130\",\"sm\":\"100\",\"xs\":\"90\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"gradient\",\"global_background_gradient\":{\"color\":\"rgba(225, 232, 253, 0.3)\",\"color2\":\"rgba(241, 216, 180, 0.3)\",\"deg\":\"160\",\"type\":\"linear\",\"pos2\":\"128\"},\"global_background_image\":{\"src\":\"images/2021/08/18/bg-pattern2.jpg\",\"height\":412,\"width\":510},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"35px 73px 45px 32px\",\"sm\":\"28px 50px 35px 28px\",\"xs\":\"25px 25px 30px 25px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId {\\n  position: relative;\\n\\toverflow: hidden;\\n}\\n#addonId .sppb-addon-text strong {\\n\\tposition: absolute;\\n  right: -4px;\\n  bottom: 0px;\\n  font-weight: 800;\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286995521,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 24px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"Noto Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"},\"global_text_color\":\"rgba(0, 0, 0, 0.03)\",\"global_use_background\":1}}]},{\"id\":1629286995150,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286995150},\"addons\":[{\"id\":1629286995807,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Authentic culture\",\"heading_selector\":\"h6\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-supreme-style3.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":{\"md\":\"200\",\"sm\":\"160\",\"xs\":\"140\"},\"text_fontweight\":\"\",\"text_lineheight\":{\"md\":\"130\",\"sm\":\"100\",\"xs\":\"90\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"gradient\",\"global_background_gradient\":{\"color\":\"rgba(225, 232, 253, 0.3)\",\"color2\":\"rgba(241, 216, 180, 0.3)\",\"deg\":\"160\",\"type\":\"linear\",\"pos2\":\"128\"},\"global_background_image\":{\"src\":\"images/2021/08/18/bg-pattern2.jpg\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"35px 73px 45px 32px\",\"sm\":\"28px 50px 35px 28px\",\"xs\":\"25px 25px 30px 25px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId {\\n  position: relative;\\n\\toverflow: hidden;\\n}\\n#addonId .sppb-addon-text strong {\\n\\tposition: absolute;\\n  right: -4px;\\n  bottom: 0px;\\n  font-weight: 800;\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286995807,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 24px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"Noto Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"},\"global_text_color\":\"rgba(0, 0, 0, 0.03)\",\"global_use_background\":1}}]},{\"id\":1629286995265,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286995265},\"addons\":[{\"id\":1629286995804,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Design focused\",\"heading_selector\":\"h6\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"16\",\"xs\":\"16\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"26\",\"xs\":\"26\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#302F40\",\"title_url\":\"\",\"link_open_new_window\":0,\"url_appear\":\"title\",\"feature_type\":\"image\",\"feature_image\":{\"src\":\"images/2021/08/18/icon-supreme-style4.svg\"},\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":{\"md\":\"200\",\"sm\":\"160\",\"xs\":\"140\"},\"text_fontweight\":\"\",\"text_lineheight\":{\"md\":\"130\",\"sm\":\"100\",\"xs\":\"90\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#0080FE\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":\"25px 0px 0px 0px\",\"button_padding\":\"8px 22px 10px 22px\",\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"gradient\",\"global_background_gradient\":{\"color\":\"rgba(225, 232, 253, 0.3)\",\"color2\":\"rgba(241, 216, 180, 0.3)\",\"deg\":\"160\",\"type\":\"linear\",\"pos2\":\"128\"},\"global_background_image\":{\"src\":\"images/2021/08/18/bg-pattern2.jpg\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":{\"md\":\"8\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"35px 33px 69px 32px\",\"sm\":\"28px 60px 61px 28px\",\"xs\":\"25px 25px 30px 25px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId {\\n  position: relative;\\n\\toverflow: hidden;\\n}\\n#addonId .sppb-addon-text strong {\\n\\tposition: absolute;\\n  right: -4px;\\n  bottom: 0px;\\n  font-weight: 800;\\n}\\n\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286995804,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"feature_image_margin\":{\"md\":\"0px 0px 24px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"title_font_family\":\"Noto Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"6\",\"sm\":\"\",\"xs\":\"4\"},\"global_text_color\":\"rgba(0, 0, 0, 0.03)\",\"global_use_background\":1}}]}]},{\"id\":1629286995896,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"md\":\"60px 0px 120px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 50px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286995896,\"color\":\"#5C5C69\",\"background_color\":\"#ffffff\",\"background_video\":0},\"layout\":\"12\",\"columns\":[{\"id\":1629286994963,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"gradient\",\"background_gradient\":{\"color\":\" #E1E8FD\",\"color2\":\"rgba(241, 216, 180, 0.47)\",\"deg\":\"165\",\"type\":\"linear\",\"pos2\":\"128\"},\"background_image\":{\"src\":\"images/2021/08/18/bg-pattern.jpg\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629286994963,\"padding\":{\"md\":\"80px 80px 80px 80px\",\"sm\":\"80px 50px 80px 50px\",\"xs\":\"40px 25px 40px 25px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629286994966,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"connect from anywhere\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"45\",\"sm\":\"34\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"52\",\"sm\":\"44\",\"xs\":\"32\"},\"title_letterspace\":\"-1px\",\"text\":\"Helix Ultimate framework packed with tons of development dramatically. Helix Ultimate is a responsive mobile first Joomla template framework focused on frontend.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px auto 40px auto\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629286994966,\"title_text_color\":\"#302F40\",\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":700},\"text_font_family\":\"Inter\",\"title_margin_bottom\":{\"md\":\"16\",\"sm\":\"14\",\"xs\":\"10\"},\"global_width\":{\"md\":\"80\",\"sm\":\"100\",\"xs\":\"100\"}}},{\"id\":1629296134618,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":1,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1629296134618},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1629296134619,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-6\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1629296134620,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Download\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"hover\",\"background_color\":\"#000000\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#ffffff\",\"background_color_hover\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#000000\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 8px 0px 0px\",\"sm\":\"   \",\"xs\":\"0px 5px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296134620,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500},\"global_use_background\":0}}]},{\"id\":1629296134621,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"col-xs-6\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1223123124142134},\"addons\":[{\"id\":1629296134622,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"md\":16,\"xs\":\"14\"},\"button_status\":\"normal\",\"background_color\":\"rgba(0, 0, 0, 0.1)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#000000\",\"background_color_hover\":\"#000000\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"md\":\"12px 30px 12px 30px\",\"sm\":\"10px 25px 10px 25px\",\"xs\":\"10px 20px 10px 20px\"},\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 8px\",\"sm\":\"   \",\"xs\":\"0px 0px 0px 5px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-btn {\\n\\tborder-radius: 6px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1629296134622,\"url\":\"#\",\"font_family\":\"IBM Plex Sans\",\"font_style\":{\"weight\":500},\"global_use_background\":0}}]}]}]}]}]', '[{\"id\":1607693149513,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/hero-bg.jpg\",\"height\":1840,\"width\":3500},\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1607693149513,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1607693149512,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1607693149512,\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1607950582169,\"name\":\"divider\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_vertical\":1,\"divider_height_vertical\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"divider_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"divider_position\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"container_div_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"solid\",\"border_width\":\"1\",\"border_radius\":\"\",\"border_color\":\"rgba(103, 89, 73, 0.3)\",\"margin_top\":{\"xl\":\"1\",\"lg\":\"1\",\"md\":\"1\",\"sm\":\"1\",\"xs\":\"1\"},\"margin_bottom\":{\"xl\":\"1\",\"lg\":\"1\",\"md\":\"1\",\"sm\":\"1\",\"xs\":\"1\"},\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 0px auto\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xl\":\"76% 0px 76% 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonWrapper {\\n  max-width: 170px;\\n  height: 100%;\\n  right:0;\\n}\\n#addonWrapper #addonId {\\n  position: absolute;\\n  width: 100%;\\n  height: 100%;\\n}\\n#addonWrapper #addonId .sppb-addon-divider-wrap,\\n#addonWrapper #addonId .sppb-divider {\\n\\theight: 100%;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1607950582169,\"global_background_color\":\"#ffffff\",\"global_width\":{\"xl\":\"12\",\"lg\":\"15\",\"md\":\"15\",\"sm\":\"17\",\"xs\":\"17\"},\"hidden_xl\":0,\"hidden_lg\":0}},{\"id\":1607926620484,\"name\":\"icons_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"size\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"margin\":{\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"10\",\"xs\":\"10\"},\"item_display\":\"block\",\"icon_alignment\":\"sppb-text-center\",\"sp_icons_group_item\":[{\"title\":\"facebook\",\"icon_name\":\"fab fa-facebook-f\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"none\",\"padding\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":1,\"icon_class\":\"\",\"color\":\"#675949\",\"hover_color\":\"#EA9964\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"title\":\"twitter\",\"icon_name\":\"fab fa-twitter\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"none\",\"padding\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":1,\"icon_class\":\"\",\"color\":\"#675949\",\"hover_color\":\"#EA9964\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"title\":\"instagram\",\"icon_name\":\"fab fa-instagram\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"none\",\"padding\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":1,\"icon_class\":\"\",\"color\":\"#675949\",\"hover_color\":\"#EA9964\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"title\":\"pinterest\",\"icon_name\":\"fab fa-pinterest-p\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"none\",\"padding\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":1,\"icon_class\":\"\",\"color\":\"#675949\",\"hover_color\":\"#EA9964\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"title\":\"linkedin\",\"icon_name\":\"fab fa-linkedin-in\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"none\",\"padding\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":1,\"icon_class\":\"\",\"color\":\"#675949\",\"hover_color\":\"#EA9964\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}],\"title\":\"\",\"title_position\":\"top\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_margin\":\"0px 0px 0px 0px\",\"title_padding\":\"0px 0px 0px 0px\",\"title_icon_position\":\"before\",\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xl\":\"31% 0px 31% 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonWrapper {\\n\\tright:0;\\n  max-width: 170px;\\n\\ttransform: translateY(-50%);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1607926620484,\"global_addon_z_index\":\"\",\"global_section_z_index\":\"4\",\"global_background_color\":\"#ffffff\",\"global_width\":{\"xl\":\"12\",\"lg\":\"15\",\"md\":\"15\",\"sm\":\"17\",\"xs\":\"17\"},\"hidden_xl\":0,\"hidden_lg\":0,\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1607924889260}],\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1607924892660,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"200px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"100px 0px 20px 0px\",\"xs\":\"100px 0px 20px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1607924892660,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"columns_gap\":{\"xl\":\"40\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\",\"unit\":\"px\"},\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":true,\"lg\":true,\"md\":true,\"sm\":false,\"xs\":false}},\"layout\":\"5,6\",\"columns\":[{\"id\":1607924889287,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1607924889287,\"width\":{\"xl\":\"41.666666666667%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608026976259,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/home-img1.jpg\",\"height\":1268,\"width\":824},\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 113px -100px 0px\",\"lg\":\"0px 10px -100px 0px\",\"md\":\"0px 10px -100px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 15px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"300\",\"global_animationdelay\":\"300\",\"global_custom_css\":\"@media (max-width: 1400px) and (min-width: 992px) {\\n  #addonWrapper {\\n  \\tmargin-right: 10px;\\n  }\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608026976259,\"global_section_z_index\":\"3\",\"global_addon_z_index\":\"\",\"global_animation\":\"fadeInUp\",\"hidden_xl\":0,\"hidden_lg\":0,\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}}],\"width\":{\"xl\":\"41.666666666667%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608023753353,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608023753353,\"padding\":{\"xl\":\"\",\"lg\":\"0px 0px 40px 0px\",\"md\":\"0px 0px 40px 0px\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608027029941,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"loved with our engravable pieces\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xl\":\"60\",\"lg\":\"44\",\"md\":\"44\",\"sm\":\"35\",\"xs\":\"35\"},\"title_lineheight\":{\"xl\":\"70\",\"lg\":\"54\",\"md\":\"54\",\"sm\":\"45\",\"xs\":\"45\"},\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"capitalize\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":1,\"global_animationduration\":\"400\",\"global_animationdelay\":\"400\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608027029941,\"title_font_style\":{\"weight\":700},\"title_font_family\":\"Cormorant\",\"global_text_color\":\"#675949\",\"global_animation\":\"fadeInRight\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"44\",\"unit\":\"px\"},\"md\":{\"value\":\"44\",\"unit\":\"px\"},\"sm\":{\"value\":\"35\",\"unit\":\"px\"},\"xs\":{\"value\":\"35\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"54\",\"unit\":\"px\"},\"md\":{\"value\":\"54\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"45\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"}}},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1608023753522}],\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1607924889489,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"138px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"40px 0px 0px 0px\",\"xs\":\"40px 0px 0px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"gradient\",\"background_gradient\":{\"color\":\"#FAF0EC\",\"color2\":\"#fbf8f4\",\"deg\":\"90\",\"type\":\"linear\",\"pos\":\"72.7\",\"pos2\":\"27.3\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1607924889489,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"columns_gap\":{\"xl\":\"40\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\",\"unit\":\"px\"},\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":true,\"lg\":true,\"md\":true,\"sm\":false,\"xs\":false}},\"layout\":\"6,6\",\"columns\":[{\"id\":1607924889490,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1607924889490,\"padding\":{\"xl\":\"0px 0px 80px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608023754366,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"share your ideas you always dreamed\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xl\":\"60\",\"lg\":\"44\",\"md\":\"44\",\"sm\":\"35\",\"xs\":\"35\"},\"title_lineheight\":{\"xl\":\"70\",\"lg\":\"54\",\"md\":\"54\",\"sm\":\"45\",\"xs\":\"45\"},\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"capitalize\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"132px 0px 30px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"-100\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608023754366,\"title_font_style\":{\"weight\":700},\"title_font_family\":\"Cormorant\",\"global_text_color\":\"#675949\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"44\",\"unit\":\"px\"},\"md\":{\"value\":\"44\",\"unit\":\"px\"},\"sm\":{\"value\":\"35\",\"unit\":\"px\"},\"xs\":{\"value\":\"35\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"54\",\"unit\":\"px\"},\"md\":{\"value\":\"54\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"45\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"}}},{\"type\":\"nested_row\",\"name\":\"row\",\"id\":1608023754368}],\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608023754354,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"items_align_center\":1,\"items_content_alignment\":\"bottom\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608023754354,\"padding\":{\"xl\":\"0px 0px 0px 113px\",\"lg\":\"0px 0px 0px 20px\",\"md\":\"0px 0px 0px 20px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608031291210,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"34\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"xl\":\"100\",\"lg\":\"62\",\"md\":\"62\",\"sm\":\"45\",\"xs\":\"45\"},\"line_height\":{\"xl\":\"110\",\"lg\":\"72\",\"md\":\"72\",\"sm\":\"55\",\"xs\":\"55\"},\"counter_title\":\"Years of <br> experience\",\"title_font_size\":{\"xl\":\"20\",\"lg\":\"16\",\"md\":\"16\",\"sm\":\"14\",\"xs\":\"14\"},\"title_line_height\":{\"xl\":\"30\",\"lg\":\"26\",\"md\":\"26\",\"sm\":\"24\",\"xs\":\"24\"},\"title_margin\":{\"xl\":\"-2px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 186px -13px\",\"lg\":\"0px 0px 90px 0px\",\"md\":\"0px 0px 90px 0px\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-animated-number-title {\\n\\tletter-spacing: .3em;\\n}\\n@media (max-width: 1400px) and (min-width: 992px) {\\n  #addonWrapper {\\n  \\tmargin-left: -50px;\\n  }\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"100\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608031291210,\"global_text_color\":\"rgba(103, 89, 73, 0.2)\",\"number_font_family\":\"Lato\",\"number_font_wight\":\"300\",\"title_font_family\":\"Lato\",\"title_fontstyle\":{\"weight\":700,\"uppercase\":true},\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"number_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"62\",\"unit\":\"px\"},\"md\":{\"value\":\"62\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"45\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"110\",\"unit\":\"px\"},\"lg\":{\"value\":\"72\",\"unit\":\"px\"},\"md\":{\"value\":\"72\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"55\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"300\",\"type\":\"google\"},\"title_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"16\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"14\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"30\",\"unit\":\"px\"},\"lg\":{\"value\":\"26\",\"unit\":\"px\"},\"md\":{\"value\":\"26\",\"unit\":\"px\"},\"sm\":{\"value\":\"24\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":true,\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"}}},{\"id\":1608023754370,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"They always worth it\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"xl\":\"32\",\"lg\":\"28\",\"md\":\"28\",\"sm\":\"24\",\"xs\":\"24\"},\"title_lineheight\":{\"xl\":\"40\",\"lg\":\"38\",\"md\":\"38\",\"sm\":\"34\",\"xs\":\"34\"},\"title_letterspace\":\"0\",\"text\":\"Onsectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.\",\"alignment\":\"\",\"text_fontsize\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"text_lineheight\":{\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"28\",\"xs\":\"28\"},\"text_fontweight\":\"400\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 48px 0px\",\"lg\":\"0px 0px 30px 0px\",\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"@media (max-width: 1400px) and (min-width: 992px) {\\n  #addonWrapper {\\n  \\tmargin-left: -40px;\\n  }\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608023754370,\"text_font_family\":\"Lato\",\"global_text_color\":\"rgba(103, 89, 73, 0.7)\",\"global_width\":{\"xl\":\"90\",\"lg\":\"100\",\"md\":\"100\",\"sm\":\"100\",\"xs\":\"100\"},\"title_text_color\":\"#675949\",\"font_family\":\"Cormorant\",\"title_font_style\":{\"weight\":700},\"title_margin_bottom\":{\"xl\":\"8\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"\"},\"hidden_xl\":0,\"hidden_lg\":0,\"text_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"16\",\"unit\":\"px\"},\"xs\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"28\",\"unit\":\"px\"},\"xs\":{\"value\":\"28\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"type\":\"google\"},\"title_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"28\",\"unit\":\"px\"},\"md\":{\"value\":\"28\",\"unit\":\"px\"},\"sm\":{\"value\":\"24\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"40\",\"unit\":\"px\"},\"lg\":{\"value\":\"38\",\"unit\":\"px\"},\"md\":{\"value\":\"38\",\"unit\":\"px\"},\"sm\":{\"value\":\"34\",\"unit\":\"px\"},\"xs\":{\"value\":\"34\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"}}},{\"id\":1608031335200,\"name\":\"image_carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"carousel_options\":\"elements\",\"image_carousel_layout\":\"layout1\",\"carousel_fade\":0,\"carousel_height\":{\"xl\":\"430\",\"lg\":\"260\",\"md\":\"260\",\"sm\":\"\",\"xs\":\"\"},\"carousel_margin\":15,\"carousel_center_padding\":{\"xl\":180,\"lg\":90,\"md\":90,\"sm\":50,\"xs\":50},\"carousel_autoplay\":1,\"carousel_speed\":\"1500\",\"carousel_interval\":4500,\"carousel_overlay\":0,\"overlay_gradient\":{\"color\":\"rgba(59, 25, 208, 0.5)\",\"color2\":\"rgba(255, 79, 226, 0.5)\",\"deg\":\"125\",\"type\":\"linear\"},\"item_content_verti_align\":\"middle\",\"item_content_hori_align\":\"center\",\"content_style\":\"title_style\",\"content_title_fontsize\":\"\",\"content_title_lineheight\":\"\",\"content_title_letterspace\":\"0px\",\"content_subtitle_fontsize\":\"\",\"content_subtitle_lineheight\":\"\",\"content_subtitle_letterspace\":\"0px\",\"description_fontsize\":\"\",\"description_lineheight\":\"\",\"description_letterspace\":\"0px\",\"sp_image_carousel_item\":[{\"image_carousel_img\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/idea-slide1.jpg\",\"height\":860,\"width\":1050}},{\"image_carousel_img\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/idea-slide2.jpg\"}},{\"image_carousel_img\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/idea-slide3.jpg\"}}],\"carousel_navigation\":\"arrow_controller\",\"carousel_bullet\":0,\"bullet_style\":\"normal_bullet\",\"bullet_height\":4,\"bullet_width\":25,\"bullet_background\":\"\",\"bullet_border_width\":0,\"bullet_border_color\":\"\",\"bullet_border_radius\":\"\",\"bullet_active_background\":\"\",\"carousel_arrow\":1,\"arrow_icon\":\"angle\",\"arrow_style\":\"normal_arrow\",\"arrow_height\":\"\",\"arrow_width\":\"\",\"arrow_background\":\"\",\"arrow_color\":\"#EA9964\",\"arrow_font_size\":\"30\",\"arrow_border_width\":0,\"arrow_border_color\":\"rgba(234, 153, 100, 0)\",\"arrow_border_radius\":\"0\",\"arrow_hover_background\":\"\",\"arrow_hover_color\":\"rgba(234, 153, 100, 0.5)\",\"arrow_hover_border_color\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px -100px 0px\",\"lg\":\"0px 0px -60px 0px\",\"md\":\"0px 0px -60px 0px\",\"sm\":\"0px 0px -60px 0px\",\"xs\":\"0px 0px -60px 0px\"},\"global_padding\":{\"xl\":\"48px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"35px 0px 0px 0px\",\"xs\":\"35px 0px 0px 0px\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-carousel-extended-item img {\\n\\tborder-radius: 0px;\\n}\\n#addonId .sppb-carousel-extended-nav-control {\\n\\twidth: 100px;\\n  height: auto;\\n  bottom: unset;\\n}\\n@media (max-width: 1400px) and (min-width: 992px) {\\n  #addonWrapper {\\n  \\tmargin-left: -40px;\\n  }\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608031335200,\"arrow_position_verti\":{\"xl\":\"-25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"-12\",\"xs\":\"-12\"},\"arrow_position_hori\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_section_z_index\":\"2\",\"hidden_xl\":0,\"hidden_lg\":0,\"content_title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"content_subtitle_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"description_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}}],\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608023755739,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"260px 0px 65px 0px\",\"lg\":\"200px 0px 65px 0px\",\"md\":\"200px 0px 65px 0px\",\"sm\":\"115px 0px 30px 0px\",\"xs\":\"115px 0px 30px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608023755739,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"columns_gap\":{\"xl\":\"40\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\",\"unit\":\"px\"},\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":true,\"lg\":true,\"md\":true,\"sm\":true,\"xs\":true}},\"layout\":\"12\",\"columns\":[{\"id\":1608023755740,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1608183051635,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"card\",\"image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/ring.png\",\"height\":517,\"width\":735},\"image_alt_text\":\"This image for Image Layouts addon\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"image_desktop_order\":\"\",\"image_tab_order\":\"\",\"image_mob_order\":\"\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(41, 14, 98, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"link_apear_in_title\":1,\"url_in_new_window\":0,\"popup_video_on_image\":0,\"popup_video_src\":\"https:\\/\\/www.youtube.com\\/watch?v=BWLRMBrKH_c\",\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_desktop_order\":\"\",\"content_tab_order\":\"\",\"content_mob_order\":\"\",\"content_text_align\":\"left\",\"content_vertical_align\":\"center\",\"content_options\":\"title\",\"title\":\"Get Inspired\",\"heading_selector\":\"h2\",\"title_background\":\"#fff\",\"title_fontsize\":{\"xl\":\"60\",\"lg\":\"46\",\"md\":\"46\",\"sm\":\"35\",\"xs\":\"35\"},\"title_lineheight\":{\"xl\":\"70\",\"lg\":\"56\",\"md\":\"56\",\"sm\":\"45\",\"xs\":\"45\"},\"title_letterspace\":\"0px\",\"title_margin\":{\"xl\":\"0px 0px 20px 0px\",\"lg\":\"0px 0px 15px 0px\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"Consectetur adipiscing elit, sed do eiusmod tempor incidunt ut labore et dolore magna aliqua enim minim.\",\"text_content_fontsize\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"text_content_lineheight\":{\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"26\",\"xs\":\"26\"},\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"xl\":\"0px 0px 50px 0px\",\"lg\":\"0px 0px 40px 0px\",\"md\":\"0px 0px 40px 0px\",\"sm\":\"0px 0px 25px 0px\",\"xs\":\"0px 0px 25px 0px\"},\"text_content_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"Order Now\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"14\",\"xs\":\"14\"},\"button_status\":\"normal\",\"btn_background_color\":\"#EA9964\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#c87139\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#ffffff\",\"button_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xl\":\"16px 33px 16px 33px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"10px 20px 10px 20px\",\"xs\":\"10px 20px 10px 20px\"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_color_type\":\"color\",\"wrapper_background\":\"\",\"wrapper_gradient\":{\"color\":\"rgba(38, 51, 159, 0.95)\",\"color2\":\"rgba(61, 59, 136, 0.95)\",\"deg\":\"225\",\"type\":\"linear\"},\"wrapper_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_padding\":{\"xl\":\"66px 82px 87px 90px\",\"lg\":\"40px 40px 40px 15px\",\"md\":\"40px 40px 40px 15px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"25px 25px 25px 25px\"},\"wrapper_box_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"35px 0px 71px 0px\",\"lg\":\"0px 0px 0px 0px\",\"md\":\"0px 0px 0px 0px\",\"sm\":\"30px 0px 0px 0px\",\"xs\":\"30px 0px 0px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-image-layout-image img {\\n\\tmargin-top: -35px;\\n  margin-bottom: -71px;\\n  height: auto;\\n}\\n#addonId .sppb-addon-image-layout-image {\\n\\tmargin-right: 70px;\\n  margin-left: -147px;\\n}\\n@media (max-width:992px) {\\n\\t#addonId .sppb-addon-image-layout-image {\\n\\t\\tmargin-right: 15px;\\n  \\tmargin-left: -90px;\\n\\t}\\n}\\n@media (max-width:767px) {\\n  #addonId .sppb-addon-image-layout-image img {\\n \\t margin-bottom: -30px;\\n\\t}\\n\\t#addonId .sppb-addon-image-layout-image {\\n\\t\\tmargin-right: 25px;\\n  \\tmargin-left: -90px;\\n\\t}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608183051635,\"wrapper_border\":\"   \",\"global_background_color\":\"#ffffff\",\"title_text_color\":\"#675949\",\"title_font_family\":\"Cormorant\",\"title_font_style\":{\"weight\":700},\"text_content_font_family\":\"Lato\",\"text_content_font_style\":{\"weight\":400},\"global_text_color\":\"rgba(103, 89, 73, 0.7)\",\"btn_font_family\":\"Lato\",\"btn_url\":\"https:\\/\\/sppagebuilder.com\\/jewellery-other-pages\\/jewellery-product-details\",\"btn_font_style\":{\"weight\":600},\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"button_text\":\"Order Now\",\"button_type\":\"custom\",\"button_shape\":\"square\",\"button_size\":\"\",\"button_color\":\"#FFFFFF\",\"button_color_hover\":\"#ffffff\",\"button_appearance\":\"\",\"button_background_color\":\"#EA9964\",\"button_background_color_hover\":\"#c87139\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"text_content_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"16\",\"unit\":\"px\"},\"xs\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"26\",\"unit\":\"px\"},\"xs\":{\"value\":\"26\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":400,\"type\":\"google\"},\"title_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"46\",\"unit\":\"px\"},\"md\":{\"value\":\"46\",\"unit\":\"px\"},\"sm\":{\"value\":\"35\",\"unit\":\"px\"},\"xs\":{\"value\":\"35\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"56\",\"unit\":\"px\"},\"md\":{\"value\":\"56\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"45\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"},\"button_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"14\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":600,\"type\":\"google\"},\"caption_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"button_url\":{\"type\":\"url\",\"url\":\"index.php\\/shop\\/jewellery\\/elara-ellipse-ring-gold\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_style_tab\":\"hover\"}}],\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1607924889491,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"65px 0px 75px 0px\",\"lg\":\"60px 0px 60px 0px\",\"md\":\"60px 0px 60px 0px\",\"sm\":\"20px 0px 30px 0px\",\"xs\":\"20px 0px 30px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1607924889491,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"columns_gap\":{\"xl\":\"40\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\",\"unit\":\"px\"},\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"4,4,4,12\",\"columns\":[{\"id\":1607924889492,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1607924889492,\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608194554332,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"poster\",\"image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/collection-ring.jpg\",\"height\":460,\"width\":800},\"image_alt_text\":\"This image for Image Layouts addon\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"image_desktop_order\":\"\",\"image_tab_order\":\"\",\"image_mob_order\":\"\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(41, 14, 98, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":{\"url\":\"index.php\\/shop?filter_categories=jewellery\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"link_apear_in_title\":1,\"url_in_new_window\":0,\"popup_video_on_image\":0,\"popup_video_src\":\"https:\\/\\/www.youtube.com\\/watch?v=BWLRMBrKH_c\",\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_desktop_order\":\"\",\"content_tab_order\":\"\",\"content_mob_order\":\"\",\"content_text_align\":\"left\",\"content_vertical_align\":\"center\",\"content_options\":\"title\",\"title\":\"Ring <br>Collection\",\"heading_selector\":\"h4\",\"title_background\":\"#fff\",\"title_fontsize\":{\"xl\":\"32\",\"lg\":\"28\",\"md\":\"28\",\"sm\":\"24\",\"xs\":\"24\"},\"title_lineheight\":{\"xl\":\"40\",\"lg\":\"38\",\"md\":\"38\",\"sm\":\"34\",\"xs\":\"34\"},\"title_letterspace\":\"0px\",\"title_margin\":{\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"124 Items\",\"text_content_fontsize\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"text_content_lineheight\":{\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"26\",\"xs\":\"26\"},\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"btn_background_color\":\"#EF6D00\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_color_type\":\"color\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_gradient\":{\"color\":\"rgba(38, 51, 159, 0.95)\",\"color2\":\"rgba(61, 59, 136, 0.95)\",\"deg\":\"225\",\"type\":\"linear\"},\"wrapper_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"30px 30px 30px 30px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"25px 25px 25px 25px\"},\"wrapper_box_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 12px 0px 0px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-image-layout-content {\\n\\ttext-align:left;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608194554332,\"wrapper_border\":\"   \",\"text_content_font_family\":\"Lato\",\"text_content_font_style\":{\"weight\":400},\"global_text_color\":\"rgba(103, 89, 73, 0.7)\",\"title_text_color\":\"#675949\",\"title_font_family\":\"Cormorant\",\"title_font_style\":{\"weight\":700},\"global_link_color\":\"#675949\",\"global_link_hover_color\":\"#EA9964\",\"hidden_xl\":0,\"hidden_lg\":0,\"button_text\":\"\",\"button_type\":\"custom\",\"button_shape\":\"square\",\"button_size\":\"\",\"button_color\":\"#FFFFFF\",\"button_color_hover\":\"#FFFFFF\",\"button_appearance\":\"\",\"button_background_color\":\"#EF6D00\",\"button_background_color_hover\":\"#de6906\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"text_content_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"16\",\"unit\":\"px\"},\"xs\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"26\",\"unit\":\"px\"},\"xs\":{\"value\":\"26\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":400,\"type\":\"google\"},\"title_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"28\",\"unit\":\"px\"},\"md\":{\"value\":\"28\",\"unit\":\"px\"},\"sm\":{\"value\":\"24\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"40\",\"unit\":\"px\"},\"lg\":{\"value\":\"38\",\"unit\":\"px\"},\"md\":{\"value\":\"38\",\"unit\":\"px\"},\"sm\":{\"value\":\"34\",\"unit\":\"px\"},\"xs\":{\"value\":\"34\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"caption_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"button_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_style_tab\":\"hover\",\"url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}}}],\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608194554043,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608194554043,\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608194554335,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"poster\",\"image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/collection-neekless.jpg\",\"height\":460,\"width\":800},\"image_alt_text\":\"This image for Image Layouts addon\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"image_desktop_order\":\"\",\"image_tab_order\":\"\",\"image_mob_order\":\"\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(41, 14, 98, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":{\"url\":\"index.php\\/shop?filter_categories=jewellery\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"link_apear_in_title\":1,\"url_in_new_window\":0,\"popup_video_on_image\":0,\"popup_video_src\":\"https:\\/\\/www.youtube.com\\/watch?v=BWLRMBrKH_c\",\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_desktop_order\":\"\",\"content_tab_order\":\"\",\"content_mob_order\":\"\",\"content_text_align\":\"left\",\"content_vertical_align\":\"center\",\"content_options\":\"title\",\"title\":\"Neckless <br>Collection\",\"heading_selector\":\"h4\",\"title_background\":\"#fff\",\"title_fontsize\":{\"xl\":\"32\",\"lg\":\"28\",\"md\":\"28\",\"sm\":\"24\",\"xs\":\"24\"},\"title_lineheight\":{\"xl\":\"40\",\"lg\":\"38\",\"md\":\"38\",\"sm\":\"34\",\"xs\":\"34\"},\"title_letterspace\":\"0px\",\"title_margin\":{\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"124 Items\",\"text_content_fontsize\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"text_content_lineheight\":{\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"26\",\"xs\":\"26\"},\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"btn_background_color\":\"#EF6D00\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_color_type\":\"color\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_gradient\":{\"color\":\"rgba(38, 51, 159, 0.95)\",\"color2\":\"rgba(61, 59, 136, 0.95)\",\"deg\":\"225\",\"type\":\"linear\"},\"wrapper_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"30px 30px 30px 30px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"25px 25px 25px 25px\"},\"wrapper_box_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 6px 0px 6px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-image-layout-content {\\n\\ttext-align:left;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608194554335,\"wrapper_border\":\"   \",\"text_content_font_family\":\"Lato\",\"text_content_font_style\":{\"weight\":400},\"global_text_color\":\"rgba(103, 89, 73, 0.7)\",\"title_text_color\":\"#675949\",\"title_font_family\":\"Cormorant\",\"title_font_style\":{\"weight\":700},\"global_link_color\":\"#675949\",\"global_link_hover_color\":\"#EA9964\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"button_text\":\"\",\"button_type\":\"custom\",\"button_shape\":\"square\",\"button_size\":\"\",\"button_color\":\"#FFFFFF\",\"button_color_hover\":\"#FFFFFF\",\"button_appearance\":\"\",\"button_background_color\":\"#EF6D00\",\"button_background_color_hover\":\"#de6906\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"text_content_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"16\",\"unit\":\"px\"},\"xs\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"26\",\"unit\":\"px\"},\"xs\":{\"value\":\"26\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":400,\"type\":\"google\"},\"title_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"28\",\"unit\":\"px\"},\"md\":{\"value\":\"28\",\"unit\":\"px\"},\"sm\":{\"value\":\"24\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"40\",\"unit\":\"px\"},\"lg\":{\"value\":\"38\",\"unit\":\"px\"},\"md\":{\"value\":\"38\",\"unit\":\"px\"},\"sm\":{\"value\":\"34\",\"unit\":\"px\"},\"xs\":{\"value\":\"34\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"caption_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"button_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_style_tab\":\"hover\"}}],\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608194554044,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608194554044,\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":0,\"hidden_lg\":0},\"addons\":[{\"id\":1608195522675,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"poster\",\"image\":{\"src\":\"https:\\/\\/sppagebuilder.com\\/images\\/2020\\/jewellery\\/collection-earing.jpg\",\"height\":460,\"width\":800},\"image_alt_text\":\"This image for Image Layouts addon\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"image_desktop_order\":\"\",\"image_tab_order\":\"\",\"image_mob_order\":\"\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(41, 14, 98, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":{\"url\":\"index.php\\/shop?filter_categories=jewellery\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"link_apear_in_title\":1,\"url_in_new_window\":0,\"popup_video_on_image\":0,\"popup_video_src\":\"https:\\/\\/www.youtube.com\\/watch?v=BWLRMBrKH_c\",\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_desktop_order\":\"\",\"content_tab_order\":\"\",\"content_mob_order\":\"\",\"content_text_align\":\"left\",\"content_vertical_align\":\"center\",\"content_options\":\"title\",\"title\":\"Earing <br>Collection\",\"heading_selector\":\"h4\",\"title_background\":\"#fff\",\"title_fontsize\":{\"xl\":\"32\",\"lg\":\"28\",\"md\":\"28\",\"sm\":\"24\",\"xs\":\"24\"},\"title_lineheight\":{\"xl\":\"40\",\"lg\":\"38\",\"md\":\"38\",\"sm\":\"34\",\"xs\":\"34\"},\"title_letterspace\":\"0px\",\"title_margin\":{\"xl\":\"0px 0px 5px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"124 Items\",\"text_content_fontsize\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"16\",\"xs\":\"16\"},\"text_content_lineheight\":{\"xl\":\"32\",\"lg\":\"\",\"md\":\"\",\"sm\":\"26\",\"xs\":\"26\"},\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"\",\"btn_letterspace\":\"0px\",\"btn_type\":\"custom\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"xl\":16,\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_status\":\"normal\",\"btn_background_color\":\"#EF6D00\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#de6906\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"xl\":\"25px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_color_type\":\"color\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_gradient\":{\"color\":\"rgba(38, 51, 159, 0.95)\",\"color2\":\"rgba(61, 59, 136, 0.95)\",\"deg\":\"225\",\"type\":\"linear\"},\"wrapper_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"30px 30px 30px 30px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"25px 25px 25px 25px\"},\"wrapper_box_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#fff\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 0px 12px\",\"lg\":\"0px 0px 20px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-image-layout-content {\\n\\ttext-align:left;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":1,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":\"50\",\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608195522675,\"wrapper_border\":\"   \",\"text_content_font_family\":\"Lato\",\"text_content_font_style\":{\"weight\":400},\"global_text_color\":\"rgba(103, 89, 73, 0.7)\",\"title_text_color\":\"#675949\",\"title_font_family\":\"Cormorant\",\"title_font_style\":{\"weight\":700},\"global_link_color\":\"#675949\",\"global_link_hover_color\":\"#EA9964\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"button_text\":\"\",\"button_type\":\"custom\",\"button_shape\":\"square\",\"button_size\":\"\",\"button_color\":\"#FFFFFF\",\"button_color_hover\":\"#FFFFFF\",\"button_appearance\":\"\",\"button_background_color\":\"#EF6D00\",\"button_background_color_hover\":\"#de6906\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"text_content_typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"16\",\"unit\":\"px\"},\"xs\":{\"value\":\"16\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"26\",\"unit\":\"px\"},\"xs\":{\"value\":\"26\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":400,\"type\":\"google\"},\"title_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"28\",\"unit\":\"px\"},\"md\":{\"value\":\"28\",\"unit\":\"px\"},\"sm\":{\"value\":\"24\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"40\",\"unit\":\"px\"},\"lg\":{\"value\":\"38\",\"unit\":\"px\"},\"md\":{\"value\":\"38\",\"unit\":\"px\"},\"sm\":{\"value\":\"34\",\"unit\":\"px\"},\"xs\":{\"value\":\"34\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"},\"button_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"caption_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"button_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_style_tab\":\"hover\"}}],\"width\":{\"xl\":\"33.333333333333%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1608194554451,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1608194554044,\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1608194554457,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Browse All\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"5px\",\"type\":\"custom\",\"appearance\":\"\",\"fontsize\":{\"xl\":\"18\",\"lg\":\"16\",\"md\":\"16\",\"sm\":\"14\",\"xs\":\"14\"},\"button_status\":\"normal\",\"background_color\":\"rgba(251, 248, 244, 0)\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#675949\",\"background_color_hover\":\"rgba(251, 248, 244, 0)\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#675949\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":{\"xl\":\"12px 20px 12px 20px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"8px 20px 8px 20px\",\"xs\":\"8px 20px 8px 20px\"},\"icon_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"60px auto 0px auto\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId {\\n  max-width: 186px;\\n  margin: 0px auto;\\n\\tborder-top: 1px solid #EA9964;\\n}\\n#addonId .sppb-btn.sppb-btn-custom:hover {\\n\\tletter-spacing: 0px!important;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608194554457,\"font_family\":\"Lato\",\"url\":{\"url\":\"index.php\\/shop?filter_categories=jewellery\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"font_style\":{\"weight\":600},\"shape\":\"square\",\"global_width\":{\"xl\":\"50\",\"lg\":\"65\",\"md\":\"65\",\"sm\":\"52\",\"xs\":\"52\"},\"hidden_xl\":0,\"hidden_lg\":0,\"typography\":{\"font\":\"Lato\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"16\",\"unit\":\"px\"},\"md\":{\"value\":\"16\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"14\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"5\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":600,\"type\":\"google\"},\"wrapper_box_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"click_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"button_style_tab\":\"hover\",\"wrapper_color_type\":\"color\"}}],\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}]},{\"id\":1608194554041,\"visibility\":true,\"collapse\":false,\"settings\":{\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"padding\":{\"xl\":\"80px 0px 50px 0px\",\"lg\":\"60px 0px 50px 0px\",\"md\":\"60px 0px 50px 0px\",\"sm\":\"0px 0px 15px 0px\",\"xs\":\"0px 0px 15px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":\"0\",\"background_video_mp4\":{\"src\":\"\"},\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"row_border\":0,\"row_border_style\":\"solid\",\"row_border_radius\":0,\"row_boxshadow\":\"0 0 0 0 #ffffff\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"instFormId\":1608194554041,\"container_width\":\"1346\",\"background_color\":\"#FBF8F4\",\"color\":\"#675949\",\"columns_gap\":{\"xl\":\"40\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\",\"unit\":\"px\"},\"hidden_xl\":0,\"hidden_lg\":0,\"fit_columns\":{\"xl\":false,\"lg\":false,\"md\":false,\"sm\":false,\"xs\":false}},\"layout\":\"12\",\"columns\":[{\"id\":1608194554042,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"items_align_center\":0,\"items_content_alignment\":\"center\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"},\"hidden_xl\":\"\",\"hidden_lg\":\"\"},\"addons\":[{\"id\":1608194554548,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Jewellery Shop\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"xl\":\"60\",\"lg\":\"44\",\"md\":\"44\",\"sm\":\"35\",\"xs\":\"35\"},\"title_lineheight\":{\"xl\":\"70\",\"lg\":\"54\",\"md\":\"54\",\"sm\":\"45\",\"xs\":\"45\"},\"title_letterspace\":\"0\",\"custom_letterspacing\":\"\",\"title_text_transform\":\"capitalize\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-center\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"xl\":\"0px 0px 60px 0px\",\"lg\":\"0px 0px 40px 0px\",\"md\":\"0px 0px 40px 0px\",\"sm\":\"0px 0px 25px 0px\",\"xs\":\"0px 0px 25px 0px\"},\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1608194554548,\"title_font_style\":{\"weight\":700},\"title_font_family\":\"Cormorant\",\"global_text_color\":\"#675949\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"heading_typography\":{\"font\":\"Cormorant\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"44\",\"unit\":\"px\"},\"md\":{\"value\":\"44\",\"unit\":\"px\"},\"sm\":{\"value\":\"35\",\"unit\":\"px\"},\"xs\":{\"value\":\"35\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"54\",\"unit\":\"px\"},\"md\":{\"value\":\"54\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"45\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":700,\"type\":\"google\"}}},{\"id\":\"f24fd98d-8e6b-4c0d-972d-0c1dc3630d1e\",\"type\":\"structure\",\"name\":\"easystore_common_productlist\",\"visibility\":true,\"title\":\"Product List\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId .pagination {\\n  margin-top: 80px;\\n}\\n#addonId ul.pagination >li a,\\n#addonId ul.pagination >li > span {\\n    border-radius: 0px;\\n    border: 0px;\\n    padding: 4px 12px;\\n    margin-right: 5px;\\n}\\n#addonId .pagination > .active > a, \\n#addonId .pagination > .active > span {\\n\\t    background: #fff;\\n    color: var(--link-color);\\n    border: 1px solid var(--link-hover-color);\\n}\\n\\n#addonId ul.pagination >li:first-child,\\n#addonId ul.pagination >li:last-child {\\n  display:none;\\n}\\n\\n#addonId ul.pagination > li .fas.fa-angle-left:before {\\n  content: \\\"\\\\f104\\\";\\n}\\n\\n#addonId ul.pagination > li .fas.fa-angle-right:before {\\n  content: \\\"\\\\f105\\\";\\n}\\n#addonId ul.pagination{\\n  justify-content: center;\\n}\\n#addonId .addon-root-easystore-list-addtocart{\\n\\tborder-top: 1px solid var(--link-hover-color);\\n  margin-top: 15px;\\n  transition: .35s;\\n  opacity: 0;\\n}\\n#addonId .sppb-collection-item:hover >.addon-root-easystore-list-addtocart {\\n\\topacity: 1;\\n}\\n#addonId .easystore-btn-add-to-cart {\\n\\ttext-align: left;\\n}\\n@media(max-width: 575px) {\\n\\t#addonId .sppb-collection-item >.addon-root-easystore-list-addtocart{\\n  opacity: 1;\\n  }\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"presets\":\"\",\"grid_columns\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"2\",\"sm\":\"2\",\"xs\":\"1\"},\"grid_gap\":{\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"limit\":\"8\",\"source\":\"latest\",\"category\":\"21\",\"enable_scroller\":0,\"active_slide\":\"1\",\"gap_x\":{\"xl\":\"35\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"gap_y\":{\"xl\":\"30\",\"lg\":\"\",\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"item_options\":\"normal\",\"pagination\":0,\"instFormId\":\"32d1e678-51e5-4fd0-b978-ae89a18721ab\",\"box_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"items\":[[{\"id\":\"21c5fa91-40fd-424e-b579-2eaf9ad8e716\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"574f1655-14ff-4abd-a3c7-a794af6477c0\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"589b4d25-3002-4fa0-810f-34932f385b22\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"68352c1e-bfe9-482e-a24d-143bee75c606\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"9f7d12d5-07a8-482d-87e4-b30b3260ed2f\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"3febe848-fc93-463f-8227-34a72c02987b\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"5de439ea-5afe-4133-9d48-171b65356c89\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"798e0a17-a15f-4083-b5e6-40bc2ff404d7\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"bb859b96-955c-4d24-ae3d-5e05c72bae27\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"4c74c91c-094b-49bd-8a8c-4c8ffa1997c5\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"c541bf1b-6d95-42f8-91ea-c427c7e7311c\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"a681e53f-2a44-4e22-9dd1-5788b54869e7\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"b828fb11-ba2d-40d0-bcd6-6675bae3dfe6\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"86c15b6c-db6b-49f9-93c7-18eb50607d7d\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"1d9815ab-9394-4e35-8ecb-af603dec0338\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"d4bca0f3-9b55-46bd-a590-456edfd1db60\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"a9c67928-127f-480c-9fa1-7ababfba4903\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"51605491-82a4-44f8-a916-227e4f016b0f\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"010e86b8-ee55-45a6-a0e4-9b9e73870805\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"0d7984e5-5f00-486d-a01a-727d6ebe65aa\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"7e1cc9ba-a61a-488c-9344-a02bb4a00b1f\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"toggle_image\":0,\"border\":{\"border_width\":\"px\",\"border_style\":\"\",\"border_color\":\"\"},\"radius\":{\"xl\":\"4\"},\"instFormId\":\"faf62060-8b34-4b2d-9cdb-a2b6b6f03a38\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},\"assets\":{\"css\":\"#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{\\r\\nmargin-top: 0px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 15px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .sppb-addon-title{\\r\\n}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{\\r\\nborder-radius: 4px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image{}}#sppb-addon-faf62060-8b34-4b2d-9cdb-a2b6b6f03a38 .easystore-product-image {border: px  ;}\"}},{\"id\":\"b48b545b-50a6-4c77-b37a-ef140d2858ae\",\"type\":\"productList\",\"name\":\"easystore_list_price\",\"visibility\":true,\"title\":\"Price\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path fill=\\\"currentColor\\\" d=\\\"M22.314 2.26a.881.881 0 0 0-.842-.231l-4.736 1.203a.876.876 0 0 0-.406.23L2.26 17.53a.887.887 0 0 0 0 1.248l10.636 10.636c.182.183.438.445.614.519a.882.882 0 0 0 .96-.192l14.07-14.07a.876.876 0 0 0 .231-.407l1.2-4.736a.881.881 0 0 0-.23-.842L22.314 2.26ZM9.204 19.471a.882.882 0 0 1-.625-1.504l6.234-6.234a.88.88 0 0 1 1.248 0 .877.877 0 0 1 0 1.245l-6.234 6.234a.877.877 0 0 1-.624.259Zm2.105 2.102a.882.882 0 0 1-.624-1.504l6.233-6.233a.887.887 0 0 1 1.248 0 .887.887 0 0 1 0 1.248l-6.236 6.23a.87.87 0 0 1-.621.26Zm8.96-4.39-6.237 6.237a.877.877 0 0 1-1.248 0 .88.88 0 0 1 0-1.248l6.234-6.234a.887.887 0 0 1 1.248 0 .88.88 0 0 1 .003 1.245Zm3.856-5.206a2.886 2.886 0 0 1-2.051.85 2.88 2.88 0 0 1-2.055-.85 2.91 2.91 0 0 1 0-4.106 2.89 2.89 0 0 1 2.055-.848c.774 0 1.504.3 2.05.848a2.905 2.905 0 0 1 0 4.106Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"spacing\":{\"xl\":8},\"original_stroke_color\":\"#a2998e\",\"original_stroke_thickness\":\"1\",\"original_stroke_angle\":\"0\",\"align_items\":\"\",\"price_color\":\"var(--link-hover-color)\",\"price_typography\":{\"font\":\"PT Sans\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"symbol_align_self\":\"\",\"decimal_align_self\":\"\",\"original_price_color\":\"#a2998e\",\"original_price_typography\":{\"font\":\"PT Sans\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_symbol_align_self\":\"\",\"original_decimal_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"original_decimal_align_self\":\"\",\"instFormId\":\"8d1a5db3-e521-407f-9830-61b29251b6e9\",\"original_symbol_typography\":{\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"assets\":{\"css\":\"#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\nbox-shadow: 0 0 0 0 #FFFFFF;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9{}}#sppb-addon-wrapper-8d1a5db3-e521-407f-9830-61b29251b6e9{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .sppb-addon-title{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{\\r\\ngap: 8px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-product-price{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{\\r\\nfont-family: PT Sans;\\r\\nfont-weight: 700;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-current{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\ncolor: #a2998e;\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{\\r\\nfont-family: PT Sans;\\r\\nfont-size: 16px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-symbol{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original .easystore-price-decimal{}}#sppb-addon-8d1a5db3-e521-407f-9830-61b29251b6e9 .easystore-price-original:before{\\r\\nborder-bottom-color: #a2998e;\\r\\nborder-bottom-width: 1;\\r\\nrotate: 0;\\r\\n}\"}},{\"id\":\"9ab9ef8c-a1c5-4319-b72e-5f8d929c3f60\",\"type\":\"productList\",\"name\":\"easystore_list_title\",\"visibility\":true,\"title\":\"Title\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.733 9.167H8.267M7.867 7.433v3.4M24.133 7.433v3.4M16 9.167v15.4M17.733 24.567h-3.466\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"5px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"selector\":\"h2\",\"color\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"700\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"20\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"140\",\"unit\":\"%\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"instFormId\":\"76421468-f845-4b33-90fe-f2dfbdd11573\",\"button_state\":\"normal\"},\"assets\":{\"css\":\"#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{\\r\\nmargin-top: 5px;\\r\\nmargin-right: 0px;\\r\\nmargin-bottom: 0px;\\r\\nmargin-left: 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-76421468-f845-4b33-90fe-f2dfbdd11573{}}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .sppb-addon-title{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title,#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title a{\\r\\n}#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{\\r\\nfont-weight: 700;\\r\\nfont-size: 24px;\\r\\nline-height: 140%;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{font-size: 20px;}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-76421468-f845-4b33-90fe-f2dfbdd11573 .easystore-product-title{}}\"}},{\"id\":\"5e092edc-3e4e-469a-9476-e5e6a33f2d21\",\"type\":\"productList\",\"name\":\"easystore_list_addtocart\",\"visibility\":true,\"title\":\"Add to Cart\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M7.467 5.3v11.067c0 1.266.933 2.266 2.066 2.266h13.2c1.134 0 2.067-.733 2.4-1.8l3.534-11.4\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-linejoin=\\\"round\\\" stroke-width=\\\"2\\\" d=\\\"M23.267 22.3H9.533c-1.133 0-2.066-1-2.066-2.267V5.3H3.333\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M11.6 26.7c1.141 0 2.067-.985 2.067-2.2 0-1.215-.926-2.2-2.067-2.2s-2.067.985-2.067 2.2c0 1.215.926 2.2 2.067 2.2ZM23.267 26.7c1.141 0 2.066-.985 2.066-2.2 0-1.215-.925-2.2-2.066-2.2-1.142 0-2.067.985-2.067 2.2 0 1.215.925 2.2 2.067 2.2ZM18.067 6.1v7.867M22.133 10.033H14\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"layout\":\"text\",\"button_state\":\"hover\",\"gap\":{\"xl\":4},\"icon_state\":\"normal\",\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"var(--link-color)\",\"background\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"background_hover\":{\"type\":\"solid\",\"color\":\"transparent\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"instFormId\":\"de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe\",\"typography\":{\"font\":\"\",\"weight\":\"600\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"14\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"border\":{\"border_width\":\"0px\",\"border_style\":\"\",\"border_color\":\"\"},\"color_hover\":\"var(--link-hover-color)\"},\"assets\":{\"css\":\"#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-wrapper-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .sppb-addon-title{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-color);\\r\\npadding: 0px 0px 0px 0px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart {border: 0px  ;}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{\\r\\nfont-weight: 600;\\r\\nfont-size: 18px;\\r\\n}\\r\\n@media (max-width: 1199.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 991.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}\\r\\n@media (max-width: 767.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{font-size: 14px;}}\\r\\n@media (max-width: 575.98px) {#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart{}}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-icon{\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover{\\r\\nbackground: transparent;\\r\\ncolor: var(--link-hover-color);\\r\\n}#sppb-addon-de9f4368-b2e4-46b5-8ceb-7fb3bf48a2fe .easystore-btn-add-to-cart:hover .easystore-btn-icon{\\r\\n}\"}}],[{\"id\":\"0afeb99d-04a5-402a-ab27-96ad5904304d\",\"type\":\"productList\",\"name\":\"easystore_list_thumbnail\",\"visibility\":true,\"title\":\"Thumbnail\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" fill=\\\"none\\\" viewBox=\\\"0 0 32 32\\\"><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M23.2 24H8.8A2.817 2.817 0 0 1 6 21.2V10.8C6 9.267 7.267 8 8.8 8h14.4c1.533 0 2.8 1.267 2.8 2.8v10.4c0 1.533-1.267 2.8-2.8 2.8Z\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"square\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M6.667 22 9.2 18.733c.2-.266.533-.266.8-.066L13.2 22c.267.2.667.2.867-.133l5.2-5.867c.2-.267.533-.267.8-.067L25.4 22.6\\\"\\/><path stroke=\\\"currentColor\\\" stroke-linecap=\\\"round\\\" stroke-miterlimit=\\\"10\\\" stroke-width=\\\"2\\\" d=\\\"M12.733 16a2.067 2.067 0 1 0 0-4.133 2.067 2.067 0 0 0 0 4.133Z\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",