<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

 // phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

$item = $this->item;
?>

<div easystore-invoice-content x-data="easystore_invoice">
    <button @click="easystorePrintInvoice" class="btn btn-primary mb-4" easystore-print-invoice>
        <?php echo Text::_('COM_EASYSTORE_ORDER_INVOICE_PRINT'); ?>
    </button>

    <div class="easystore-invoice-order-info border-bottom pb-3 mb-4">
        <div class="mb-1"><strong><?php echo Text::_('COM_EASYSTORE_ORDERS_ORDER_PLACED'); ?>:</strong> <?php echo HTMLHelper::_('date', $item->created, 'DATE_FORMAT_LC2'); ?></div>
        <div class="mb-1"><strong><?php echo Text::_('COM_EASYSTORE_ORDERS_ORDER_ID'); ?>:</strong> #<?php echo $item->id; ?></div>
        <div class="mb-1"><strong><?php echo Text::_('COM_EASYSTORE_ORDER_PAYMENT_METHOD'); ?>:</strong> <?php echo EasyStoreHelper::getPaymentMethodString($item->payment_method); ?></div>
        <div><strong><?php echo Text::_('COM_EASYSTORE_ORDERS_ORDER_TOTAL'); ?>:</strong> <?php echo $item->total_price_with_currency; ?></div>
    </div>

    <?php echo LayoutHelper::render('invoice.products', ['products' => $item->products]); ?>
    <?php echo LayoutHelper::render('invoice.summary', ['item' => $item]); ?>
    <?php echo LayoutHelper::render('invoice.customer-note', ['customer_note' => $item->customer_note]); ?>
    <?php echo LayoutHelper::render('invoice.address', ['item' => $item]); ?>    
</div>