<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;
use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

EasyStoreHelper::wa()
    ->useStyle('com_easystore.site')
    ->useStyle('com_easystore.cart.site');

$page_title = $this->escape($this->params->get('page_heading', Text::_('COM_EASYSTORE_CART')));
$settings   = SettingsHelper::getSettings();
$shopPage   = $settings->get('products.shopPage', 'index.php');
?>

<div class="easystore-cart my-4" x-data="easystore_cart">
    <?php if (empty($this->item->items)) : ?>
        <div class="text-center easystore-empty-cart">
            <h3 class="mb-3 easystore-h3"><?php echo Text::_('COM_EASYSTORE_CART_EMPTY') ?></h3>
            <a href="<?php echo Route::_($shopPage, false); ?>" class="btn btn-outline-primary"><?php echo Text::_('COM_EASYSTORE_CART_CONTINUE_SHOPPING') ?></a>
        </div>
    <?php else : ?>
        <?php if ($this->params->get('show_page_heading')) : ?>
            <div class="page-header">
                <h1><?php echo $page_title; ?></h1>
            </div>
        <?php endif;?>
        <table class="easystore-cart-table" x-show="!!item?.items?.length">
            <thead>
                <tr>
                    <th colspan="2" scope="col"><?php echo Text::_('COM_EASYSTORE_CART_PRODUCT'); ?></th>
                    <th scope="col"><?php echo Text::_('COM_EASYSTORE_CART_PRICE'); ?></th>
                    <th class="d-none d-lg-table-cell" scope="col"><?php echo Text::_('COM_EASYSTORE_CART_QUANTITY'); ?></th>
                    <th class="d-none d-lg-table-cell" scope="col"><?php echo Text::_('COM_EASYSTORE_CART_TOTAL'); ?></th>
                </tr>
            </thead>

            <?php if (!empty($this->item->items)) : ?>
            <tbody>
                <template x-for="(cartItem, index) in item.items" :key="index">
                <tr class="easystore-cart-item">
                    <td class="easystore-cart-item-thumbnail">
                        <video x-show="cartItem.isVideo" :src="cartItem.image?.src ?? ''" :alt="cartItem.title" loading="lazy" width="72"></video>
                        <img x-show="!cartItem.isVideo" :src="cartItem.image?.src ?? ''" :alt="cartItem.title" loading="lazy" />
                    </td>
                    <td class="easystore-cart-item-info">
                        <h3 class="easystore-cart-item-title" x-text="cartItem.title"></h3>
                        <div class="easystore-metadata-h">
                            <template x-for="option in cartItem.options" :key="option.key">
                                <div class="easystore-metadata-item">
                                    <span class="easystore-metadata-key" x-text="option.key + ':'"></span>
                                    <span class="easystore-metadata-value" x-text="option.name"></span>
                                </div>
                            </template>
                        </div>
                    </td>
                    <td class="easystore-cart-item-price">
                        <template x-if="cartItem.discounted_price > 0">
                            <div class="easystore-cart-item-subtotal">
                                <span x-text="cartItem.discounted_price_with_currency"></span>
                                <del x-text="cartItem.price_with_currency"></del>
                            </div>
                        </template>
                        <template x-if="cartItem.discounted_price == 0">
                            <div class="easystore-cart-item-subtotal" x-text="cartItem.price_with_currency"></div>
                        </template>
                    </td>
                    <td class="easystore-cart-item-quantity">
                        <div class="easystore-cart-quantity-selector">
                            <div class="mb-1 easystore-quantity-selector">
                                <button type="button" @click="decrementQuantity(index)" class="easystore-quantity-selector-btn easystore-button-reset">-</button>
                                <input type="number" class="form-control form-control-sm easystore-product-quantity" :value="cartItem.quantity" @change="handleQuantityChange($event, index)" min="1" placeholder="0">
                                <button type="button"  @click="incrementQuantity(index)" class="easystore-quantity-selector-btn easystore-button-reset">+</button>
                            </div>

                            <div class="easystore-cart-remove-item">
                                <a href="#" @click.prevent="removeCartItem(index)">
                                    <?php echo Text::_('COM_EASYSTORE_CART_REMOVE'); ?>
                                </a>
                            </div>
                        </div>
                    </td>
                    <td class="easystore-cart-item-total d-none d-lg-table-cell">
                        <div class="mb-1 easystore-cart-item-subtotal fw-bold" x-text="cartItem.total_price_with_currency"></div>
                    </td>
                </tr>
                </template>
            </tbody>
            <?php endif;?>
        </table>

        <div class="my-4 row">
            <div class="col-lg-4 ms-auto">
                <div class="easystore-cart-summary">
                    <div class="mb-2" x-show="!isLoading">
                        <strong><?php echo Text::_('COM_EASYSTORE_CART_SUBTOTAL'); ?>: </strong> <span x-text="item.sub_total_with_currency"></span>
                    </div>

                    <div class="mb-4 text-muted" x-show="!isLoading"><?php echo Text::_('COM_EASYSTORE_CART_TAX_SHIPPING'); ?></div>

                    <div class="easystore-skeleton-container" x-show="isLoading">
                        <span class="easystore-skeleton"></span>
                        <span class="easystore-skeleton"></span>
                    </div>

                    <?php echo LayoutHelper::render('checkout', ['token' => $this->getToken()]); ?>
                    <a class="btn btn-link d-block" href="<?php echo Route::_($shopPage, false); ?>"><?php echo Text::_('COM_EASYSTORE_CART_CONTINUE_SHOPPING'); ?></a>
                </div>
            </div>
        </div>
    <?php endif;?>
</div>