<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\View\Checkout;

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use JoomShaper\Component\EasyStore\Site\Traits\Token;
use JoomShaper\Component\EasyStore\Site\Model\CartModel;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * View for the user identity validation form
 */
class HtmlView extends BaseHtmlView
{
    use Token;

    /**
     * The cart item
     *
     * @var    mixed
     * @since  1.0.0
     */
    protected $item;

    /**
     * Pagination object
     *
     * @var    \Joomla\CMS\Pagination\Pagination
     * @since  1.0.0
     */
    protected $pagination;

    /**
     * Guest checkout
     *
     * @var bool
     */
    protected $allowGuestCheckout = false;

    /**
     * Display the view
     *
     * @param   string  $template  The name of the layout file to parse.
     * @return  void
     */
    public function display($template = null)
    {
        /** @var CMSApplication */
        $app                      = Factory::getApplication();
        $user                     = $app->getIdentity();
        $settings                 = SettingsHelper::getSettings();
        $this->allowGuestCheckout = $settings->get('checkout.allow_guest_checkout', false);

        $token = $this->getToken();

        if (!$this->allowGuestCheckout && $user->guest) {
            $redirect = 'index.php?option=com_easystore&view=checkout&step=information&cart_token=' . $token;
            $url      = Route::_('index.php?option=com_users&view=login&return=' . base64_encode($redirect), false);
            $app->redirect($url);
        }

        $this->item = $this->get('Item');
        $cartItems  = (new CartModel())->getItem();

        if (empty($cartItems)) {
            throw new Exception(Text::_('COM_EASYSTORE_INVALID_CHECKOUT_ERROR'));
        }

        $this->params = ComponentHelper::getParams('com_easystore');

        /** @var CMSApplication */
        $app          = Factory::getApplication();
        $active       = $app->getMenu()->getActive();

        if (
            $active
            && $active->component === 'com_easystore'
            && $active->query['view'] === 'checkout'
        ) {
            $temp       = clone $this->params;
            $menuParams = $active->getParams();
            $temp->merge($menuParams);
            $this->params = $temp;
        }

        parent::display($template);
    }
}
