<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\View\Cart;

use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use JoomShaper\Component\EasyStore\Site\Traits\Token;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects



/**
 * View for the user identity validation form
 */
class HtmlView extends BaseHtmlView
{
    use Token;

    /**
     * The cart products
     *
     * @var  \stdClass
     */
    protected $items;

    /**
     * The cart coupon info
     *
     * @var  \stdClass
     */
    protected $coupon;

    /**
     * Pricing info
     *
     * @var  \stdClass
     */
    protected $pricing;

    /**
     * The page parameters
     *
     * @var    \Joomla\Registry\Registry|null
     *
     * @since  4.0.0
     */
    protected $params = null;

    /**
     * Display the view
     *
     * @param   string  $template  The name of the layout file to parse.
     * @return  void
     */
    public function display($template = null)
    {
        $this->item  = $this->get('Item');

        $this->params = ComponentHelper::getParams('com_easystore');
        $app          = Factory::getApplication();
        $active       = $app->getMenu()->getActive();

        if (
            $active
            && $active->component == 'com_easystore'
            && $active->query['view'] == 'cart'
        ) {
            $temp       = clone $this->params;
            $menuParams = $active->getParams();
            $temp->merge($menuParams);
            $this->params = $temp;
        }

        // Call the parent display to display the layout file
        parent::display($template);
    }
}
