<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Site\Traits;

use Joomla\CMS\Factory;
use Joomla\CMS\User\User;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

trait Notification
{
    /**
     * Send Email notification
     *
     * @param User $user Joomla user
     * @param string $subject Email subject String
     * @param string $body  Email body string
     * @param array $replacements array of string [ key => value] where key as placeholder for value.
     * @return mixed
     */
    public static function sendEmail(User $user, string $subject, string $body, array $replacements)
    {
        try {
            foreach ($replacements as $key => $value) {
                $subject = str_replace('{' . strtoupper($key) . '}', $value, $subject);
                $body    = str_replace('{' . strtoupper($key) . '}', $value, $body);
            }

            $mailer = Factory::getMailer();
            $mailer->setSubject($subject);
            $mailer->setBody($body);
            $mailer->addRecipient($user->email, $user->name);
            $mailer->Send();
        } catch (\Throwable $error) {
            throw $error;
        }
    }
}
