<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

namespace JoomShaper\Component\EasyStore\Site\Email;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Application\CMSApplication;

/**
 * Base Email class
 *
 * @since 1.0.0
 */
class BaseEmail implements EmailInterface
{
    /**
     * Email subject
     *
     * @var string
     *
     * @since 1.0.0
     */
    protected $subject;

    /**
     * HTML Body content
     *
     * @var string
     *
     * @since 1.0.0
     */
    protected $htmlContent;

    /**
     * Receiver email address
     *
     * @var string
     *
     * @since 1.0.0
     */
    protected $receiver;

    /**
     * Method to instantiate the email object.
     *
     * @param string $receiver  Receiver email address
     * @param string $subject   Email subject
     *
     * @since 1.0.0
     */
    public function __construct($receiver, $subject)
    {
        $this->receiver = $receiver;
        $this->subject  = $subject;
    }

    /**
     * Method to send email
     *
     * @return bool Return true if successful.
     *
     * @since 1.0.0
     */
    public function send()
    {
        /** @var CMSApplication */
        $app    = Factory::getApplication();
        $config = $app->getConfig();

        // Get the sender email and name from the global configuration
        $senderEmail = $config->get('mailfrom');
        $senderName  = $config->get('fromname');

        if (empty($senderEmail) || empty($senderName)) {
            return false;
        }

        $mailer = Factory::getMailer();
        $mailer->isHTML(true);
        $mailer->setSender([$senderEmail, $senderName]);
        $mailer->addRecipient($this->receiver);

        $mailer->setSubject($this->subject);
        $mailer->setBody($this->htmlContent);

        try {
            return $mailer->Send();
        } catch (Exception $error) {
            return false;
        }
    }
}
