<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Site\Controller;

use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\MVC\Controller\BaseController;
use JoomShaper\Component\EasyStore\Site\Traits\Api;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Default Controller of Order view in EasyStore component
 *
 * @since  1.0.0
 */
class OrderController extends BaseController
{
    use Api;

    public function render_payments()
    {
        $payment_methods = SettingsHelper::getSettings()->get('payment', []);

        $this->sendResponse(LayoutHelper::render('order.payment_methods', ['payment_methods' => $payment_methods]));
    }
}
