<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Site\Controller;

use Joomla\Input\Input;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use JoomShaper\Component\EasyStore\Site\Traits\Api;
use JoomShaper\Component\EasyStore\Site\Traits\Cart;
use JoomShaper\Component\EasyStore\Site\Traits\Token;
use JoomShaper\Component\EasyStore\Site\Model\CartModel;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Default Controller of EasyStore component
 *
 * @since  1.0.0
 */
class CartController extends BaseController
{
    use Api;
    use Token;
    use Cart;


    public function __construct($config = [], MVCFactoryInterface $factory = null, ?CMSApplication $app = null, ?Input $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
    }

    public function getCartData()
    {
        $model  = new CartModel();
        $item   = $model->getItem();

        $this->sendResponse($item);
    }

    public function getCartDrawerContent()
    {
        $model       = new CartModel();
        $item        = $model->getItem();
        $output      = LayoutHelper::render('cart.mini', ['items' => $item ?? []]);
        $token       = $this->getToken();
        $checkoutUrl = Route::_('index.php?option=com_easystore&view=checkout&cart_token=' . $token, false);

        $this->sendResponse(['content' => $output, 'checkout_url' => $checkoutUrl]);
    }
}
