<?php

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SppagebuilderAddonEasystoreSingleThumbnail extends SppagebuilderAddons
{
    public function render()
    {
        $settings = $this->addon->settings;

        return EasyStoreHelper::loadLayout(
            'thumbnail',
            [
                'item'             => $this->addon->easystoreItem,
                'open_in_lightbox' => $settings->open_in_lightbox ?? 1,
                'show_controls'    => $settings->show_controls ?? 1,
                'show_thumbnails'  => $settings->show_thumbnails ?? 1,
                'origin'           => 'single',
            ]
        );
    }

    public function css()
    {
        $css = '';

        $addon_id  = '#sppb-addon-' . $this->addon->id;
        $settings  = $this->addon->settings;
        $cssHelper = new CSSHelper($addon_id);

        $css .= $cssHelper->generateStyle('.easystore-product-image', $settings, [
            'padding'          => 'padding',
            'background_color' => 'background-color',
            'radius'           => 'border-radius',
        ], ['background_color' => false, 'padding' => false]);

        $css .= $cssHelper->border('.easystore-product-image', $settings, 'border');

        return $css;
    }
}
