<?php

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class SppagebuilderAddonEasystoreListRatings extends SppagebuilderAddons
{
    public function render()
    {
        $settings = $this->addon->settings;
        $products = $this->addon->easystoreList;
        $index    = $this->addon->listIndex;

        return EasyStoreHelper::loadLayout(
            'ratings',
            [
                'count'      => $products[$index]->reviewData->rating,
                'show_count' => $settings->show_count ?? 1,
                'show_label' => $settings->show_label ?? 0,
            ]
        );
    }

    public function css()
    {
        $css = '';

        $addon_id  = '#sppb-addon-' . $this->addon->id;
        $settings  = $this->addon->settings;
        $cssHelper = new CSSHelper($addon_id);

        // general
        $css .= $cssHelper->generateStyle('.easystore-rating-stars', $settings, [
            'color'   => 'color',
            'size'    => 'font-size',
            'spacing' => 'gap',
        ], ['color' => false]);

        // count
        $css .= $cssHelper->generateStyle('.easystore-rating-count', $settings, [
            'count_color' => 'color',
        ], false);

        $css .= $cssHelper->typography('.easystore-rating-count', $settings, 'count_typography');

        $css .= $cssHelper->generateStyle('.easystore-ratings-container', $settings, [
            'count_spacing' => 'gap',
        ]);

        return $css;
    }
}
