<?php

/**
 * @package SP Page Builder
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2024 JoomShaper
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

//no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

$presetsData = SpPageBuilderAddonHelper::getPresets('easystore_common_productlist');

SpAddonsConfig::addonConfig([
    'type'       => 'structure',
    'addon_name' => 'productlist',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_PRODUCT_LIST'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_PRODUCT_LIST_DESC'),
    'category'   => Text::_('COM_EASYSTORE_ADDON_GROUP_COMMON'),
    'context'    => 'easystore.common',
    'icon'       => '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M19 5.47v7.145a.616.616 0 0 1-.352.464l-6.4 2.865a.577.577 0 0 1-.496 0l-6.4-2.865A.665.665 0 0 1 5 12.527V5.47a.64.64 0 0 1 .352-.552l6.4-2.864a.6.6 0 0 1 .496 0l6.4 2.864c.127.059.23.161.288.288A.584.584 0 0 1 19 5.47Zm-7.6 3.257L6.2 6.39v5.753l5.2 2.329V8.727Zm4.158-1.33L12.6 8.728v5.745l5.2-2.329V6.39l-2.2.989-.014.031-.028-.012Zm-.223-1.204 1.617-.723-4.936-2.216-1.546.694 4.865 2.245ZM9.261 4.491l4.863 2.245-2.108.943L7.08 5.47l2.18-.979ZM4 18.285c0-.315.265-.571.593-.571h14.814c.328 0 .593.256.593.571a.582.582 0 0 1-.593.572H4.593A.582.582 0 0 1 4 18.285ZM9.571 20a.571.571 0 1 0 0 1.143h5.715a.571.571 0 0 0 0-1.143H9.57Z" fill="#6F7CA3"/></svg>',
    'settings'   => [
        'content' => [
            'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_GENERAL'),
            'fields' => [
                'presets' => [
                    'type'   => 'preset',
                    'title'  => 'Presets',
                    'desc'   => 'Select a preset.',
                    'values' => $presetsData['presets'],
                    'std'    => $presetsData['default_preset'],
                ],
                'grid_columns' => [
                    'type'       => 'slider',
                    'title'      => 'Grid Column',
                    'desc'       => 'Enter number of column',
                    'min'        => 1,
                    'max'        => 6,
                    'responsive' => true,
                    'std'        => ['xl' => '3'],
                    'depends'    => [['enable_scroller', '=', 0]],
                ],
                'gap_x' => [
                    'type'       => 'slider',
                    'title'      => 'Column Gap',
                    'desc'       => 'Enter grid gap',
                    'min'        => 0,
                    'max'        => 100,
                    'responsive' => true,
                    'std'        => ['xl' => '32'],
                ],
                'gap_y' => [
                    'type'       => 'slider',
                    'title'      => 'Row Gap',
                    'desc'       => 'Enter grid gap',
                    'min'        => 0,
                    'max'        => 100,
                    'responsive' => true,
                    'std'        => ['xl' => '32'],
                    'depends'    => [['enable_scroller', '=', 0]],
                ],
                'limit' => [
                    'type'  => 'slider',
                    'title' => 'Limit',
                    'desc'  => 'Total number of products',
                    'min'   => 1,
                    'max'   => 100,
                    'std'   => 16,
                ],
                'source' => [
                    'type'   => 'select',
                    'title'  => 'Source',
                    'desc'   => 'Select a source.',
                    'values' => [
                        'latest'       => 'Latest',
                        'featured'     => 'Featured',
                        'best_selling' => 'Best Selling',
                        'on_sale'      => 'On Sale',
                        'related'      => 'Related',
                        'wishlist'     => 'Wishlist',
                    ],
                    'std' => 'latest',
                ],
                'category' => [
                    'type'    => 'category',
                    'context' => 'com_easystore',
                    'title'   => 'Category',
                    'desc'    => 'Select a category.',
                    'std'     => '',
                ],
                'enable_scroller' => [
                    'type'  => 'checkbox',
                    'title' => 'Enable scroller',
                    'desc'  => 'Enable scroller',
                    'std'   => 0,
                ],
                'items_per_slide' => [
                    'type'       => 'slider',
                    'title'      => 'Slides per item',
                    'desc'       => 'Enter number of items per slide',
                    'min'        => 1,
                    'max'        => 6,
                    'std'        => ['xl' => '4'],
                    'responsive' => true,
                    'depends'    => [['enable_scroller', '=', 1]],
                ],
                'slides_to_scroll' => [
                    'type'       => 'slider',
                    'title'      => 'Number of slides to scroll',
                    'desc'       => 'Enter number of slides to scroll',
                    'min'        => 1,
                    'max'        => 6,
                    'std'        => ['xl' => '1'],
                    'responsive' => true,
                    'depends'    => [['enable_scroller', '=', 1]],
                ],
                'show_indicators' => [
                    'type'    => 'checkbox',
                    'title'   => 'Show indicators',
                    'desc'    => 'Enable showing indicators',
                    'std'     => 1,
                    'depends' => [['enable_scroller', '=', 1]],
                ],
                'pagination' => [
                    'type'    => 'checkbox',
                    'title'   => 'Enable Pagination',
                    'desc'    => 'Enable Pagination',
                    'std'     => 1,
                    'depends' => [['enable_scroller', '=', 0]],
                ],
            ],
        ],

        'item' => [
            'title'  => 'Item',
            'fields' => [
                'padding' => [
                    'type'       => 'padding',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
                    'responsive' => true,
                ],

                'item_options_separator' => [
                    'type' => 'separator',
                ],

                'item_options' => [
                    'type'   => 'buttons',
                    'values' => [
                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
                    ],
                    'std' => 'normal',
                ],

                'background' => [
                    'type'    => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                    'depends' => [['item_options', '=', 'normal']],
                ],

                'border_separator' => [
                    'type'    => 'separator',
                    'depends' => [['item_options', '=', 'normal']],
                ],

                'border' => [
                    'type'       => 'border',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'normal']],
                ],

                'border_radius' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'normal']],
                ],

                'box_shadow' => [
                    'type'    => 'boxshadow',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BOX_SHADOW'),
                    'depends' => [['item_options', '=', 'normal']],
                ],

                // hover state
                'background_hover' => [
                    'type'    => 'color',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_separator_hover' => [
                    'type'    => 'separator',
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_hover' => [
                    'type'    => 'border',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER'),
                    'depends' => [['item_options', '=', 'hover']],
                ],

                'border_radius_hover' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_RADIUS'),
                    'responsive' => true,
                    'depends'    => [['item_options', '=', 'hover']],
                ],

                'box_shadow_hover' => [
                    'type'    => 'boxshadow',
                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BOX_SHADOW'),
                    'depends' => [['item_options', '=', 'hover']],
                ],
            ],
        ],
    ],
]);
