<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use JoomShaper\Component\EasyStore\Site\Helper\EasyStoreHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);

?>

<div class="easystore-product-price">
    <?php if ($item->has_sale && (float) $item->discount_value > 0) : ?>
        <span class="easystore-price-current" aria-hidden="true">
            <?php echo EasyStoreHelper::loadLayout('price_segments', ['segments' => $item->prices->discounted_price_with_segments]); ?>
        </span>
        <span class="easystore-visually-hidden"><?php echo $item->prices->discounted_price_with_currency; ?></span>
        <span class="easystore-price-original" aria-hidden="true">
            <?php echo EasyStoreHelper::loadLayout('price_segments', ['segments' => $item->prices->price_with_segments]); ?>
        </span>
    <?php else : ?>
        <span class="easystore-price-current" aria-hidden="true">
            <?php echo EasyStoreHelper::loadLayout('price_segments', ['segments' => $item->prices->price_with_segments]); ?>
        </span>
    <?php endif; ?>
    <span class="easystore-visually-hidden"><?php echo $item->prices->price_with_currency; ?></span>
</div>