<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

extract($displayData);
?>

<div class="row">
    <div class="col">
        <h3><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY'); ?></h3>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_ORDER_PLACED_ON') ?> <?php echo HTMLHelper::_('date', $item->created, Text::_("COM_EASYSTORE_DATE_FORMAT_1")); ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_SUB_TOTAL') ?>: <?php echo $item->sub_total; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_SALES_TAX') ?>: <?php echo $item->saleTax; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_SUB_TOTAL_AFTER_TAX') ?>: <?php echo $item->sub_total_tax; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_SPECIAL_DISCOUNT_TOTAL') ?>: -<?php echo $item->special_discounted_amount; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_EXTRA_DISCOUNT_TOTAL') ?>: -<?php echo $item->extra_discount_amount; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_COUPON_AMOUNT') ?>: -<?php echo $item->couponAmount; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_DELIVERY_PRICE') ?>: <?php echo $item->deliveryCharge; ?>
        </div>
        <div>
        <?php echo Text::_('COM_EASYSTORE_ORDER_TOTAL_PRICE') ?>: <?php echo $item->total_price; ?>
        </div>
    </div>
</div>