<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Language\Text;

 // phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);
?>
<style>
table,td,th{border:1px solid #000;border-collapse:collapse}table{width:100%}th{height:30px;text-align:center}td{padding:5px;text-align:left}.text-center{text-align:center!important}.text-end{text-align:right!important}thead{background:#000;color:#fff}tfoot{border-top:2px solid}
</style>

<table style="border: 1px solid;">
    <thead>
        <tr>
            <th><?php echo Text::_('COM_EASYSTORE_CART_PRODUCT');?></th>
            <th><?php echo Text::_('COM_EASYSTORE_CART_QUANTITY');?></th>
            <th><?php echo Text::_('COM_EASYSTORE_CART_PRICE');?></th>
            <th><?php echo Text::_('COM_EASYSTORE_CART_TOTAL');?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($products as $product) : ?>
        <tr>
            <td><?php echo $product->title;?></td>
            <td class="text-center"><?php echo $product->quantity;?></td>
            <td class="text-end"><?php echo $product->price_with_currency;?></td>
            <td class="text-end"><?php echo $product->total_price_with_currency;?></td>
        </tr>
        <?php endforeach; ?>
        
    </tbody>
    <tfoot>
        <tr>
            <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_PRODUCT_PRICE_TOTAL') ?></th>
            <th class="text-end"><?php echo $sub_total_with_currency;?></th>
        </tr>
        <tr>
            <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_CART_ORDER_SUMMARY_SALES_TAX') ?></th>
            <th class="text-end"><?php echo $sale_tax_with_currency;?></th>
        </tr>
        <tr>
            <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_SUB_TOTAL_AFTER_TAX') ?></th>
            <th class="text-end"><?php echo $sub_total_tax_with_currency;?></th>
        </tr>
        <?php if (!empty(floatval($special_discounted_amount))) :?>
            <tr>
                <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_SPECIAL_DISCOUNT_TOTAL') ?></th>
                <th class="text-end"><?php echo $special_discounted_amount_with_currency;?></th>
            </tr>
        <?php endif; ?>
        <?php if (!empty(floatval($extra_discount_amount))) :?>
            <tr>
                <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_EXTRA_DISCOUNT_TOTAL') ?></th>
                <th class="text-end"><?php echo $extra_discount_amount_with_currency;?></th>
            </tr>
        <?php endif; ?>
        <?php if (!empty(floatval($coupon_amount))) :?>
            <tr>
                <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_COUPON_AMOUNT') ?></th>
                <th class="text-end"><?php echo $coupon_discount_with_currency;?></th>
            </tr>
        <?php endif; ?>
        <tr>
            <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_SHIPPING_COST') ?></th>
            <th class="text-end"><?php echo $shipping_cost_with_currency;?></th>
        </tr>
        <tr>
            <th colspan="3" class="text-end"><?php echo Text::_('COM_EASYSTORE_ORDER_TOTAL_PRICE') ?></th>
            <th class="text-end"><?php echo $total_price_with_currency;?></th>
        </tr>
    </tfoot>
</table>
