<?php

/**
 * @package     EasyStore.Site
 * @subpackage  com_easystore
 *
 * @copyright   Copyright (C) 2023 - 2024 JoomShaper <https://www.joomshaper.com>. All rights reserved.
 * @license     GNU General Public License version 3; see LICENSE
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use JoomShaper\Component\EasyStore\Administrator\Helper\SettingsHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

extract($displayData);

$user                    = Factory::getApplication()->getIdentity();
$settings                = SettingsHelper::getSettings();
$allowGuestCheckout      = $settings->get('checkout.allow_guest_checkout', false);
$phoneNumberCondition    = $settings->get('checkout.phone_number', 'optional');
$addressLineTwoCondition = $settings->get('checkout.address_line_two', 'optional');
$isGuestCheckout         = $user->guest && $allowGuestCheckout;
?>

<div class="easystore-checkout-information">
    <div class="easystore-checkout-form">
        <?php if ($address === 'shipping') : ?>
        <div class="easystore-widget">
            <h3 class="easystore-widget-title"><?php echo Text::_('COM_EASYSTORE_ADDRESS_SHIPPING'); ?></h3>
            <div class="easystore-compact-form">
                <div>
                    <input type="text" class="form-control" name="shipping_customer_name" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CUSTOMER_NAME'); ?>" required
                        x-model="information.shipping_address.name" />
                </div>
                <div>
                    <select name="shipping_country" class="form-select form-control" required x-model="information.shipping_address.country">
                        <option value=""><?php echo Text::_('COM_EASYSTORE_SELECT_COUNTRY_PLACEHOLDER'); ?></option>
                        <template x-for="(country, index) in countries" :key="country.value">
                            <option :value="country.value" x-text="country.label" :selected="country.value === information.shipping_address.country"></option>
                        </template>
                    </select>
                </div>
                <div>
                    <input name="shipping_address_line_1" type="text" class="form-control" required x-model="information.shipping_address.address_1"
                        placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_ADDRESS_LINE_1'); ?>" />
                </div>

                <?php if ($addressLineTwoCondition !== 'do-not-include') : ?>
                    <div>
                        <input
                            name="shipping_address_line_2"
                            type="text"
                            class="form-control"
                            placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_ADDRESS_LINE_2'); ?>"
                            x-model="information.shipping_address.address_2" <?php echo $addressLineTwoCondition === 'required' ? 'required' : ''; ?>
                        />
                    </div>
                <?php endif;?>

                <div class="easystore-half-width">
                    <input name="shipping_city" type="text" class="form-control" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CITY'); ?>" required
                        x-model="information.shipping_address.city" />
                </div>
                <div class="easystore-half-width">
                    <input name="shipping_zip_code" type="text" class="form-control" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_ZIP_CODE'); ?>" required
                        x-model="information.shipping_address.zip_code" />
                </div>
                <div x-show="shipping_states.length > 0">
                    <select name="shipping_state" class="form-select form-control" x-model="information.shipping_address.state">
                        <option value=""><?php echo Text::_('COM_EASYSTORE_SELECT_STATE_PLACEHOLDER'); ?></option>
                        <template x-for="(state, index) in shipping_states" :key="state.value">
                            <option :value="state.value" x-text="state.label" :selected="state.value == information.shipping_address.state"></option>
                        </template>
                    </select>
                </div>
                <?php if ($phoneNumberCondition !== 'do-not-include') : ?>
                    <div>
                        <input name="shipping_phone" type="text" class="form-control" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CUSTOMER_NUMBER'); ?>" x-model="information.shipping_address.phone" <?php echo $phoneNumberCondition === 'required' ? 'required' : ''; ?> />
                    </div>
                <?php endif;?>
            </div>

            <?php if ($isGuestCheckout) : ?>
                <div class="form-check form-check-inline mt-3">
                    <input type="checkbox" name="save_address" class="form-check-input" id="save-for-next-time" x-model="information.save_guest_shipping" />
                    <label for="save-for-next-time" class="form-check-label">
                        <?php echo Text::_('COM_EASYSTORE_CHECKOUT_SAVE_SHIPPING_ADDRESS'); ?>
                    </label>
                </div>
            <?php endif;?>
        </div>
        <?php endif;?>

        <?php if ($address === 'billing') : ?>
        <div class="easystore-checkout-billing-address">

            <div class="form-check form-check-inline mb-3">
                <input class="form-check-input" type="checkbox" id="is_billing_and_shipping_address_same" name="is_billing_and_shipping_address_same"
                    x-model="information.is_billing_and_shipping_address_same" :checked="!!information.is_billing_and_shipping_address_same">
                <label class="form-check-label" for="is_billing_and_shipping_address_same"><?php echo Text::_('COM_EASYSTORE_ADDRESS_SAME_AS_SHIPPING'); ?></label>
            </div>

            <div class="easystore-compact-form" x-cloak x-show="!information.is_billing_and_shipping_address_same">
                <div>
                    <input type="text" class="form-control" name="billing_customer_name" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CUSTOMER_NAME'); ?>"
                        x-model="information.billing_address.name" />
                </div>
                <div>
                    <select name="billing_country" class="form-select form-control" :required="!information.is_billing_and_shipping_address_same" x-model="information.billing_address.country">
                        <option value=""><?php echo Text::_('COM_EASYSTORE_SELECT_COUNTRY_PLACEHOLDER'); ?></option>
                        <template x-for="(country, index) in countries" :key="country.value">
                            <option :value="country.value" x-text="country.label"></option>
                        </template>
                    </select>
                </div>
                <div>
                    <input name="billing_address_line_1" type="text" class="form-control" x-model="information.billing_address.address_1"
                        placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_ADDRESS_LINE_1'); ?>" />
                </div>

                <?php if ($addressLineTwoCondition !== 'do-not-include') : ?>
                    <?php $isAddressTwoRequired = $addressLineTwoCondition === 'required';?>
                    <div>
                        <input
                            name="billing_address_line_2"
                            type="text"
                            class="form-control"
                            placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_ADDRESS_LINE_2'); ?>"
                            x-model="information.billing_address.address_2"
                            <?php if ($isAddressTwoRequired) : ?>
                                :required="!information.is_billing_and_shipping_address_same"
                            <?php endif;?>
                        />
                    </div>
                <?php endif;?>
                <div class="easystore-half-width">
                    <input name="billing_city" type="text" class="form-control" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CITY'); ?>"
                        x-model="information.billing_address.city" />
                </div>
                <div class="easystore-half-width">
                    <input name="billing_zip_code" type="text" class="form-control" placeholder="ex. 1100" x-model="information.billing_address.zip_code" />
                </div>
                <div x-show="billing_states.length > 0">
                    <select name="billing_state" class="form-select form-control" x-model="information.billing_address.state">
                        <option value=""><?php echo Text::_('COM_EASYSTORE_SELECT_STATE_PLACEHOLDER'); ?></option>
                        <template x-for="(state, index) in billing_states" :key="state.value">
                            <option :value="state.value" x-text="state.label" :selected="state.value == information.billing_address.state"></option>
                        </template>
                    </select>
                </div>
                <?php if ($phoneNumberCondition !== 'do-not-include') : ?>
                    <?php $isPhoneRequired = $phoneNumberCondition === 'required';?>
                    <div>
                        <input name="billing_phone" type="text" class="form-control" placeholder="<?php echo Text::_('COM_EASYSTORE_CHECKOUT_SHIPPING_CUSTOMER_NUMBER'); ?>" x-model="information.billing_address.phone"
                        <?php if ($isPhoneRequired) : ?>
                            :required="!information.is_billing_and_shipping_address_same"
                        <?php endif;?>
                        />
                    </div>
                <?php endif;?>
            </div>
        </div>
        <?php endif;?>
    </div>
</div>