<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useStyle('com_easystore.admin');

$user = Factory::getApplication()->getIdentity();
?>
<form action="<?php echo Route::_('index.php?option=com_easystore&task=coupon.add'); ?>" method="post" name="adminForm" id="adminForm">
<div class="easystore-container">
    <div class="easystore-card">
        <div class="easystore-empty-state">
            <div class="easystore-empty-state-icon mb-3">
                <svg xmlns="http://www.w3.org/2000/svg" width="158" height="121" fill="none"><path fill="#EFF1FB" d="M21.624 9.662a1.148 1.148 0 1 0 0-2.296 1.148 1.148 0 0 0 0 2.296ZM27.918 6.164a2.082 2.082 0 1 0 0-4.164 2.082 2.082 0 0 0 0 4.164ZM10.024 21.668a4.024 4.024 0 1 0 0-8.047 4.024 4.024 0 0 0 0 8.047Z"/><path fill="#F0F2FD" d="M141.094 120.645a3.322 3.322 0 1 0 .001-6.645 3.322 3.322 0 0 0-.001 6.645ZM131.619 116.69a1.62 1.62 0 1 0 0-3.238 1.62 1.62 0 0 0 0 3.238ZM153 87a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"/><path fill="#C4CAF1" d="M146.448 1.436 31.74 19.399l10.552 67.386L157 68.822 146.448 1.436Z"/><path stroke="#7682B7" stroke-dasharray="3.04 3.04" stroke-width="1.218" d="M146.202 1.613 31.677 19.583 44.47 88.726l56.196-9.9 56.196-9.898-10.66-67.314Z"/><path fill="#F0F2FD" d="M140.909 32.09H33.754c-.491 0-.89.4-.89.891v6.105c0 .23-.186.416-.416.416h-3.203a.414.414 0 0 1-.415-.416v-6.105c0-.49-.4-.89-.89-.89H4.374A4.375 4.375 0 0 0 0 36.465v10.85c0 .709.59 1.282 1.3 1.282 10.453 0 18.925 8.474 18.925 18.925 0 10.45-8.475 18.925-18.925 18.925-.715 0-1.3.585-1.3 1.3v12.98a4.836 4.836 0 0 0 4.836 4.836h23.249a.745.745 0 0 0 .745-.745v-7.736c0-.206.167-.373.373-.373h3.293c.206 0 .373.167.373.373v7.736c0 .412.333.745.745.745h107.098a4.87 4.87 0 0 0 4.869-4.869V36.763a4.666 4.666 0 0 0-4.666-4.667l-.006-.006ZM32.481 94.11H29.21a.38.38 0 0 1-.382-.38v-7.627c0-.218.176-.394.394-.394h3.248c.218 0 .394.176.394.394v7.626a.38.38 0 0 1-.382.382Zm.055-10.998h-3.382a.326.326 0 0 1-.327-.327v-7.748c0-.181.146-.327.327-.327h3.382c.182 0 .327.146.327.327v7.748a.326.326 0 0 1-.327.327Zm-.06-10.999h-3.264a.386.386 0 0 1-.385-.385v-7.63c0-.211.173-.384.385-.384h3.263c.212 0 .385.173.385.385v7.63a.386.386 0 0 1-.385.384Zm-.013-10.61h-3.242a.398.398 0 0 1-.397-.398v-7.608c0-.218.179-.397.397-.397h3.242c.218 0 .397.179.397.397v7.608a.398.398 0 0 1-.397.397Zm-.018-11h-3.203a.414.414 0 0 1-.415-.415V42.48c0-.209.17-.379.379-.379h3.281c.21 0 .38.17.38.38v7.607c0 .23-.186.416-.416.416h-.006Z"/><path fill="#DDE1FC" d="M28.53 35.481H4.072a.755.755 0 0 0-.751.76v7.009c0 .376.276.69.642.751 11.62 1.843 20.492 11.672 20.492 23.522 0 11.85-8.872 21.68-20.492 23.521a.758.758 0 0 0-.642.752v9.481c0 .418.336.76.751.76h24.461M32.83 102.034h107.358a.755.755 0 0 0 .751-.76V36.242a.757.757 0 0 0-.751-.761H32.83"/><path fill="#A8B2E5" d="M98.978 56.774c.563-.29 1.187-.34 1.872-.147.567.16.998.474 1.301.946.299.47.376.973.223 1.508-.042.15-.098.284-.165.413a2.936 2.936 0 0 1-.254.385L88.46 70.963 74.045 82.751c-.37.281-.75.431-1.138.449a3.267 3.267 0 0 1-1.03-.098c-.566-.159-1.004-.459-1.313-.902-.31-.44-.386-.946-.223-1.508a2.561 2.561 0 0 1 .78-1.224c2.49-1.995 4.87-3.928 7.13-5.794 2.264-1.87 4.522-3.72 6.777-5.56 2.215-1.817 4.47-3.655 6.764-5.512 2.291-1.86 4.669-3.79 7.131-5.794l.059-.03-.004-.004Zm-24.34.165c.37-1.083.879-1.97 1.521-2.655a6.877 6.877 0 0 1 2.13-1.566 6.337 6.337 0 0 1 2.477-.579 8.277 8.277 0 0 1 2.518.303c.832.236 1.615.6 2.344 1.096a6.825 6.825 0 0 1 1.823 1.817c.49.716.814 1.523.979 2.423.165.9.104 1.854-.184 2.863-.284 1.013-.746 1.879-1.382 2.597a7.456 7.456 0 0 1-2.197 1.717 7.344 7.344 0 0 1-5.357.538 6.48 6.48 0 0 1-2.172-1.095 6.7 6.7 0 0 1-1.689-1.875c-.45-.738-.758-1.579-.923-2.527-.169-.946-.129-1.964.116-3.054l-.003-.003Zm7.429-.697c-.358-.101-.686-.104-.985-.012-.3.091-.575.238-.823.443a3.358 3.358 0 0 0-.664.728 8.277 8.277 0 0 0-.505.845c-.171.948-.077 1.698.281 2.248.359.55.836.912 1.432 1.08.566.16 1.157.086 1.774-.223.618-.31 1.053-.909 1.304-1.802a2.56 2.56 0 0 0-.263-2.05c-.38-.651-.897-1.07-1.548-1.257h-.003Zm2.824 23.116c.36-1.056.856-1.918 1.48-2.595a6.386 6.386 0 0 1 2.096-1.529 6.616 6.616 0 0 1 2.426-.569 7.89 7.89 0 0 1 2.471.287 7.594 7.594 0 0 1 2.277 1.077 7.079 7.079 0 0 1 1.807 1.79c.493.7.827 1.487.998 2.355.171.87.116 1.809-.168 2.821-.294 1.043-.747 1.928-1.353 2.655-.608.729-1.303 1.289-2.089 1.677a6.772 6.772 0 0 1-2.53.682 7.572 7.572 0 0 1-2.65-.266 7.237 7.237 0 0 1-2.126-1.01 6.427 6.427 0 0 1-1.719-1.761c-.474-.713-.804-1.536-.988-2.472-.187-.936-.162-1.982.068-3.14v-.002Zm7.363-.475c-.774-.216-1.389-.119-1.845.3-.456.42-.807.897-1.055 1.438-.156.888-.07 1.613.257 2.169.324.557.783.921 1.38 1.09.505.143 1.058.067 1.654-.233.597-.297 1.02-.875 1.264-1.74.211-.744.135-1.393-.223-1.944-.358-.55-.835-.911-1.432-1.08Z"/><path fill="#fff" d="m52.68 68.626 1.628 3.099 3.447-.21-3.048 1.625.233 3.492-1.628-3.098-3.448.209 3.048-1.624-.232-3.493ZM58.278 75.788l.718 1.368 1.523-.093-1.346.717.102 1.542-.718-1.368-1.523.093 1.346-.718-.102-1.54Z"/><path fill="#C4CAF1" d="M119.041 52.824c.198-.284.643-.097.578.243l-.564 2.964a.318.318 0 0 0 .131.322l2.455 1.721c.282.198.096.64-.242.578l-2.949-.544a.32.32 0 0 0-.321.133l-1.718 2.48c-.197.285-.643.098-.578-.242l.565-2.964a.322.322 0 0 0-.131-.322l-2.456-1.721c-.281-.198-.096-.64.243-.578l2.948.544c.124.023.25-.029.322-.133l1.717-2.48ZM121.225 62.074c.074-.106.24-.036.216.09l-.211 1.105a.118.118 0 0 0 .049.12l.915.643c.106.073.037.238-.09.215l-1.099-.203a.12.12 0 0 0-.12.05l-.64.925c-.074.106-.24.036-.216-.09l.211-1.106a.122.122 0 0 0-.049-.12l-.916-.642c-.105-.074-.036-.239.091-.215l1.099.203a.12.12 0 0 0 .12-.05l.64-.925Z"/></svg>
            </div>
            
            <div class="easystore-empty-state-title mb-2">
                <?php echo Text::_('COM_EASYSTORE_EMPTYSTATE_COUPON_TITLE'); ?>
            </div>

            <div class="easystore-empty-state-description mb-4">
                <?php echo Text::_('COM_EASYSTORE_EMPTYSTATE_COUPON_DESCRIPTION'); ?>
            </div>

            <?php if ($user->authorise('core.create', 'com_easystore') || count($user->getAuthorisedCategories('com_easystore', 'core.create')) > 0) : ?>
                <div class="easystore-empty-state-actions">
                    <a href="<?php echo Route::_('index.php?option=com_easystore&task=coupon.add'); ?>" class="btn btn-primary"><?php echo Text::_('COM_EASYSTORE_EMPTYSTATE_COUPON_BUTTON_TEXT'); ?></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<input type="hidden" name="task" value="">
<input type="hidden" name="boxchecked" value="0">
<?php echo HTMLHelper::_('form.token'); ?>
</form>