<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2024 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Administrator\Traits;

use JoomShaper\Component\EasyStore\Administrator\Model\ProductModel;

trait Product
{
    /**
     * Function for processing productsWithVariants api methods
     *
     * @return void
     */
    public function productsWithVariants()
    {
        $requestMethod = $this->getInputMethod();

        $this->checkNotAllowedMethods(['POST', 'PUT', 'PATCH', 'DELETE'], $requestMethod);

        $this->getProductsWithVariants();
    }

    /**
     * Function to get Products with variants
     *
     * @return void
     */
    protected function getProductsWithVariants()
    {
        $params = (object) [
            'limit'  => $this->getInput('limit', 10),
            'offset' => $this->getInput('offset', 0),
            'search' => $this->getInput('search', '', 'STRING'),
        ];

        $model    = new ProductModel();
        $products = $model->getProductsWithVariants($params);

        $this->sendResponse($products);
    }
}
