<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace JoomShaper\Component\EasyStore\Administrator\Field;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Database\DatabaseInterface;
use JoomShaper\Component\EasyStore\Administrator\Helper\EasyStoreHelper;

/**
 * AddProduct field.
 *
 * @since  1.0.0
 */
class AddProductField extends ListField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  1.0.0
     */
    protected $type = 'AddProduct';

    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     * @since  1.0.0
     */
    protected $layout = 'joomla.form.field.addproduct';

    /**
     * Method to get a list of products with image which are published.
     *
     * @return  array  The field option objects.
     *
     * @since   1.0.0
     */
    protected function getOptions()
    {
        $db    = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true);

        $options = [];

        $query->select(
            [
                $db->quoteName('a.id', 'value'),
                $db->quoteName('a.name', 'text'),
                $db->quoteName('a.images'),
            ]
        );
        $query->from($db->quoteName('#__easystore_products', 'a'));
        $query->where($db->quoteName('a.published') . ' = 1');
        $query->order($db->quoteName('a.name'));

        // Get the options.
        $db->setQuery($query);

        try {
            $options = $db->loadObjectList();
            foreach ($options as &$option) {
                $images = json_decode($option->images ?? '');
                unset($option->images);
                $option->image = EasyStoreHelper::getFirstImage($images);
            }
        } catch (\RuntimeException $e) {
            Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
        }

        foreach ($options as &$option) {
            $option->text = '#' . $option->value . ' - ' . $option->text;
        }

        array_unshift($options, HTMLHelper::_('select.option', '0', Text::_('COM_EASYSTORE_ADD_PRODUCT_FIELD_EMPTY_LABEL')));

        return $options;
    }

    /**
     * Method to get the field input markup for a generic list.
     *
     * @return  string  The field input markup.
     *
     * @since   1.0.0
     */
    protected function getInput()
    {
        $data             = $this->getLayoutData();
        $data['options']  = $this->getOptions();
        $data['order_id'] = $this->form->getData()['id'];
        $renderer         = $this->getRenderer($this->layout);
        $renderer->setComponent('com_easystore');
        $renderer->setClient(1);

        return $renderer->render($data);
    }
}
